/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import sun.net.www.http.ClientVector;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveEntry;
import sun.net.www.http.KeepAliveKey;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetIntegerAction;
import sun.util.logging.PlatformLogger;

public class KeepAliveCache
extends HashMap<KeepAliveKey, ClientVector>
implements Runnable {
    private static final long serialVersionUID = -2937172892064557949L;
    private static final String keepAliveProp = "http.keepAlive.time.";
    private static final int userKeepAliveServer;
    private static final int userKeepAliveProxy;
    static final PlatformLogger logger;
    static final int MAX_CONNECTIONS = 5;
    static int result;
    static final int LIFETIME = 5000;
    private Thread keepAliveTimer = null;

    static int getUserKeepAliveSeconds(String string) {
        int n = AccessController.doPrivileged(new GetIntegerAction(keepAliveProp + string, -1));
        return n < -1 ? -1 : n;
    }

    static int getMaxConnections() {
        if (result == -1 && (result = AccessController.doPrivileged(new GetIntegerAction("http.maxConnections", 5)).intValue()) <= 0) {
            result = 5;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URL uRL, Object object, HttpClient httpClient) {
        HttpClient httpClient2 = null;
        KeepAliveCache keepAliveCache = this;
        synchronized (keepAliveCache) {
            ClientVector clientVector;
            Object object2;
            boolean bl;
            boolean bl2 = bl = this.keepAliveTimer == null;
            if (!bl && !this.keepAliveTimer.isAlive()) {
                bl = true;
            }
            if (bl) {
                this.clear();
                object2 = this;
                AccessController.doPrivileged(new PrivilegedAction<Void>((KeepAliveCache)object2){
                    final /* synthetic */ KeepAliveCache val$cache;
                    {
                        this.val$cache = keepAliveCache2;
                    }

                    @Override
                    public Void run() {
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        ThreadGroup threadGroup2 = null;
                        while ((threadGroup2 = threadGroup.getParent()) != null) {
                            threadGroup = threadGroup2;
                        }
                        KeepAliveCache.this.keepAliveTimer = new Thread(threadGroup, this.val$cache, "Keep-Alive-Timer");
                        KeepAliveCache.this.keepAliveTimer.setDaemon(true);
                        KeepAliveCache.this.keepAliveTimer.setPriority(8);
                        KeepAliveCache.this.keepAliveTimer.setContextClassLoader(null);
                        KeepAliveCache.this.keepAliveTimer.start();
                        return null;
                    }
                });
            }
            if ((clientVector = (ClientVector)super.get(object2 = new KeepAliveKey(uRL, object))) == null) {
                int n = httpClient.getKeepAliveTimeout();
                if (n == 0) {
                    n = KeepAliveCache.getUserKeepAlive(httpClient.getUsingProxy());
                    if (n == -1) {
                        n = 5;
                    }
                } else if (n == -1 && (n = KeepAliveCache.getUserKeepAlive(httpClient.getUsingProxy())) == -1) {
                    int n2 = n = httpClient.getUsingProxy() ? 60 : 5;
                }
                assert (n >= 0);
                if (n == 0) {
                    httpClient2 = httpClient;
                } else {
                    clientVector = new ClientVector(n * 1000);
                    clientVector.put(httpClient);
                    super.put(object2, clientVector);
                }
            } else {
                httpClient2 = clientVector.put(httpClient);
            }
        }
        if (httpClient2 != null) {
            httpClient2.closeServer();
        }
    }

    private static int getUserKeepAlive(boolean bl) {
        return bl ? userKeepAliveProxy : userKeepAliveServer;
    }

    public synchronized void remove(HttpClient httpClient, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(httpClient.url, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector != null) {
            clientVector.remove(httpClient);
            if (clientVector.isEmpty()) {
                this.removeVector(keepAliveKey);
            }
        }
    }

    synchronized void removeVector(KeepAliveKey keepAliveKey) {
        super.remove(keepAliveKey);
    }

    public synchronized HttpClient get(URL uRL, Object object) {
        KeepAliveKey keepAliveKey = new KeepAliveKey(uRL, object);
        ClientVector clientVector = (ClientVector)super.get(keepAliveKey);
        if (clientVector == null) {
            return null;
        }
        return clientVector.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ArrayList<HttpClient> arrayList = null;
            KeepAliveCache keepAliveCache = this;
            synchronized (keepAliveCache) {
                long l = System.currentTimeMillis();
                ArrayList<KeepAliveKey> arrayList2 = new ArrayList<KeepAliveKey>();
                for (KeepAliveKey keepAliveKey : this.keySet()) {
                    ClientVector clientVector;
                    ClientVector clientVector2 = clientVector = (ClientVector)this.get(keepAliveKey);
                    synchronized (clientVector2) {
                        KeepAliveEntry keepAliveEntry = (KeepAliveEntry)clientVector.peekLast();
                        while (keepAliveEntry != null && l - keepAliveEntry.idleStartTime > (long)clientVector.nap) {
                            clientVector.pollLast();
                            if (arrayList == null) {
                                arrayList = new ArrayList<HttpClient>();
                            }
                            arrayList.add(keepAliveEntry.hc);
                            keepAliveEntry = (KeepAliveEntry)clientVector.peekLast();
                        }
                        if (clientVector.isEmpty()) {
                            arrayList2.add(keepAliveKey);
                        }
                    }
                }
                for (KeepAliveKey keepAliveKey : arrayList2) {
                    this.removeVector(keepAliveKey);
                }
            }
            if (arrayList == null) continue;
            for (HttpClient httpClient : arrayList) {
                httpClient.closeServer();
            }
        } while (!this.isEmpty());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    static {
        logger = HttpURLConnection.getHttpLogger();
        userKeepAliveServer = KeepAliveCache.getUserKeepAliveSeconds("server");
        userKeepAliveProxy = KeepAliveCache.getUserKeepAliveSeconds("proxy");
        result = -1;
    }
}

