/*
 * Decompiled with CFR 0.152.
 */
package sun.net.sdp;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Scanner;
import sun.net.NetHooks;
import sun.net.sdp.SdpSupport;
import sun.security.action.GetPropertyAction;

public class SdpProvider
extends NetHooks.Provider {
    private static final int MAX_PORT = 65535;
    private final boolean enabled;
    private final List<Rule> rules;
    private PrintStream log;

    public SdpProvider() {
        String string = AccessController.doPrivileged(new GetPropertyAction("com.sun.sdp.conf"));
        if (string == null) {
            this.enabled = false;
            this.rules = null;
            return;
        }
        List<Rule> list = null;
        if (string != null) {
            try {
                list = SdpProvider.loadRulesFromFile(string);
            }
            catch (IOException iOException) {
                SdpProvider.fail("Error reading %s: %s", string, iOException.getMessage());
            }
        }
        PrintStream printStream = null;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("com.sun.sdp.debug"));
        if (string2 != null) {
            printStream = System.out;
            if (string2.length() > 0) {
                try {
                    printStream = new PrintStream(string2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.enabled = !list.isEmpty();
        this.rules = list;
        this.log = printStream;
    }

    private static int[] parsePortRange(String string) {
        int n = string.indexOf(45);
        try {
            int[] nArray = new int[2];
            if (n < 0) {
                boolean bl = string.equals("*");
                nArray[0] = bl ? 0 : Integer.parseInt(string);
                nArray[1] = bl ? 65535 : nArray[0];
            } else {
                String string2;
                String string3 = string.substring(0, n);
                if (string3.length() == 0) {
                    string3 = "*";
                }
                if ((string2 = string.substring(n + 1)).length() == 0) {
                    string2 = "*";
                }
                nArray[0] = string3.equals("*") ? 0 : Integer.parseInt(string3);
                nArray[1] = string2.equals("*") ? 65535 : Integer.parseInt(string2);
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new int[0];
        }
    }

    private static void fail(String string, Object ... objectArray) {
        Formatter formatter = new Formatter();
        formatter.format(string, objectArray);
        throw new RuntimeException(formatter.out().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static List<Rule> loadRulesFromFile(String string) throws IOException {
        try (Scanner scanner = new Scanner(new File(string));){
            Object object;
            ArrayList<PortRangeRule> arrayList = new ArrayList<PortRangeRule>();
            while (scanner.hasNextLine()) {
                object = scanner.nextLine().trim();
                if (((String)object).length() == 0 || ((String)object).charAt(0) == '#') continue;
                String[] stringArray = ((String)object).split("\\s+");
                if (stringArray.length != 3) {
                    SdpProvider.fail("Malformed line '%s'", object);
                    continue;
                }
                Action inetAddressArray = null;
                for (Action action : Action.values()) {
                    if (!stringArray[0].equalsIgnoreCase(action.name())) continue;
                    inetAddressArray = action;
                    break;
                }
                if (inetAddressArray == null) {
                    SdpProvider.fail("Action '%s' not recognized", stringArray[0]);
                    continue;
                }
                int[] nArray = SdpProvider.parsePortRange(stringArray[2]);
                if (nArray.length == 0) {
                    SdpProvider.fail("Malformed port range '%s'", stringArray[2]);
                    continue;
                }
                if (stringArray[1].equals("*")) {
                    arrayList.add(new PortRangeRule(inetAddressArray, nArray[0], nArray[1]));
                    continue;
                }
                int n = stringArray[1].indexOf(47);
                try {
                    void var9_19;
                    Object object2;
                    if (n < 0) {
                        for (InetAddress inetAddress : object2 = InetAddress.getAllByName(stringArray[1])) {
                            int n2 = inetAddress instanceof Inet4Address ? 32 : 128;
                            arrayList.add(new AddressPortRangeRule(inetAddressArray, inetAddress, n2, nArray[0], nArray[1]));
                        }
                        continue;
                    }
                    object2 = InetAddress.getByName(stringArray[1].substring(0, n));
                    int n3 = -1;
                    try {
                        int n4 = Integer.parseInt(stringArray[1].substring(n + 1));
                        if (object2 instanceof Inet4Address) {
                            if (n4 < 0 || n4 > 32) {
                                int n5 = -1;
                            }
                        } else if (n4 < 0 || n4 > 128) {
                            int n6 = -1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (var9_19 > 0) {
                        arrayList.add(new AddressPortRangeRule(inetAddressArray, (InetAddress)object2, (int)var9_19, nArray[0], nArray[1]));
                        continue;
                    }
                    SdpProvider.fail("Malformed prefix '%s'", stringArray[1]);
                }
                catch (UnknownHostException unknownHostException) {
                    SdpProvider.fail("Unknown host or malformed IP address '%s'", stringArray[1]);
                }
            }
            object = arrayList;
            return object;
        }
    }

    private void convertTcpToSdpIfMatch(FileDescriptor fileDescriptor, Action action, InetAddress inetAddress, int n) throws IOException {
        boolean bl = false;
        Object object = this.rules.iterator();
        while (object.hasNext()) {
            Rule rule = object.next();
            if (!rule.match(action, inetAddress, n)) continue;
            SdpSupport.convertSocket(fileDescriptor);
            bl = true;
            break;
        }
        if (this.log != null) {
            Object object2 = object = inetAddress instanceof Inet4Address ? inetAddress.getHostAddress() : "[" + inetAddress.getHostAddress() + "]";
            if (bl) {
                this.log.format("%s to %s:%d (socket converted to SDP protocol)\n", new Object[]{action, object, n});
            } else {
                this.log.format("%s to %s:%d (no match)\n", new Object[]{action, object, n});
            }
        }
    }

    @Override
    public void implBeforeTcpBind(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        if (this.enabled) {
            this.convertTcpToSdpIfMatch(fileDescriptor, Action.BIND, inetAddress, n);
        }
    }

    @Override
    public void implBeforeTcpConnect(FileDescriptor fileDescriptor, InetAddress inetAddress, int n) throws IOException {
        if (this.enabled) {
            this.convertTcpToSdpIfMatch(fileDescriptor, Action.CONNECT, inetAddress, n);
        }
    }

    private static enum Action {
        BIND,
        CONNECT;

    }

    private static class AddressPortRangeRule
    extends PortRangeRule {
        private final byte[] addressAsBytes;
        private final int prefixByteCount;
        private final byte mask;

        AddressPortRangeRule(Action action, InetAddress inetAddress, int n, int n2, int n3) {
            super(action, n2, n3);
            this.addressAsBytes = inetAddress.getAddress();
            this.prefixByteCount = n >> 3;
            this.mask = (byte)(255 << 8 - n % 8);
        }

        @Override
        public boolean match(Action action, InetAddress inetAddress, int n) {
            if (action != this.action()) {
                return false;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length != this.addressAsBytes.length) {
                return false;
            }
            for (int i = 0; i < this.prefixByteCount; ++i) {
                if (byArray[i] == this.addressAsBytes[i]) continue;
                return false;
            }
            if (this.prefixByteCount < this.addressAsBytes.length && (byArray[this.prefixByteCount] & this.mask) != (this.addressAsBytes[this.prefixByteCount] & this.mask)) {
                return false;
            }
            return super.match(action, inetAddress, n);
        }
    }

    private static class PortRangeRule
    implements Rule {
        private final Action action;
        private final int portStart;
        private final int portEnd;

        PortRangeRule(Action action, int n, int n2) {
            this.action = action;
            this.portStart = n;
            this.portEnd = n2;
        }

        Action action() {
            return this.action;
        }

        @Override
        public boolean match(Action action, InetAddress inetAddress, int n) {
            return action == this.action && n >= this.portStart && n <= this.portEnd;
        }
    }

    private static interface Rule {
        public boolean match(Action var1, InetAddress var2, int var3);
    }
}

