/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.screencast;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import sun.awt.OSInfo;
import sun.awt.UNIXToolkit;
import sun.awt.screencast.TokenItem;
import sun.awt.screencast.TokenStorage;
import sun.awt.screencast.XdgDesktopPortal;
import sun.security.action.GetPropertyAction;

public class ScreencastHelper {
    static final boolean SCREENCAST_DEBUG;
    private static final boolean IS_NATIVE_LOADED;
    private static final int ERROR = -1;
    private static final int DENIED = -11;
    private static final int OUT_OF_BOUNDS = -12;
    private static final int NO_STREAMS = -13;
    private static final int XDG_METHOD_SCREENCAST = 0;
    private static final int XDG_METHOD_REMOTE_DESKTOP = 1;
    private static final int DELAY_BEFORE_SESSION_CLOSE = 2000;
    private static volatile TimerTask timerTask;
    private static final Timer timerCloseSession;

    private ScreencastHelper() {
    }

    public static boolean isAvailable() {
        return IS_NATIVE_LOADED;
    }

    private static native boolean loadPipewire(int var0, boolean var1);

    private static native int getRGBPixelsImpl(int var0, int var1, int var2, int var3, int[] var4, int[] var5, String var6);

    private static List<Rectangle> getSystemScreensBounds() {
        return Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(graphicsDevice -> graphicsDevice.getDefaultConfiguration().getBounds()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static synchronized native void closeSession();

    private static void timerCloseSessionRestart() {
        if (timerTask != null) {
            timerTask.cancel();
        }
        timerTask = new TimerTask(){

            @Override
            public void run() {
                ScreencastHelper.closeSession();
            }
        };
        timerCloseSession.schedule(timerTask, 2000L);
    }

    public static synchronized void getRGBPixels(int n, int n2, int n3, int n4, int[] nArray) {
        int n5;
        if (!IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        List list = ScreencastHelper.getSystemScreensBounds().stream().filter(rectangle2::intersects).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        if (SCREENCAST_DEBUG) {
            System.out.printf("// getRGBPixels in %s, affectedScreenBounds %s\n", rectangle2, list);
        }
        if (list.isEmpty()) {
            if (SCREENCAST_DEBUG) {
                System.out.println("// getRGBPixels - requested area outside of any screen");
            }
            return;
        }
        Set<TokenItem> set = TokenStorage.getTokens(list);
        int[] nArray2 = list.stream().filter(rectangle2::intersects).flatMapToInt(rectangle -> IntStream.of(rectangle.x, rectangle.y, rectangle.width, rectangle.height)).toArray();
        for (TokenItem tokenItem : set) {
            n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, tokenItem.token);
            if (n5 >= 0) {
                return;
            }
            if (ScreencastHelper.checkReturnValue(n5, true)) continue;
            return;
        }
        n5 = ScreencastHelper.getRGBPixelsImpl(n, n2, n3, n4, nArray, nArray2, null);
        ScreencastHelper.checkReturnValue(n5, true);
    }

    private static boolean checkReturnValue(int n, boolean bl) {
        if (n == -11) {
            if (SCREENCAST_DEBUG) {
                System.err.println("robot action: access denied by user.");
            }
            if (bl) {
                throw new SecurityException("Screen Capture in the selected area was not allowed");
            }
        } else if (n == -1) {
            if (SCREENCAST_DEBUG) {
                System.err.println("robot action: failed.");
            }
        } else if (n == -12) {
            if (SCREENCAST_DEBUG) {
                System.err.println("Token does not provide access to requested area.");
            }
        } else if (n == -13 && SCREENCAST_DEBUG) {
            System.err.println("robot action: no streams available");
        }
        return n != -1;
    }

    private static void performWithToken(Function<String, Integer> function) {
        if (!XdgDesktopPortal.isRemoteDesktop() || !IS_NATIVE_LOADED) {
            return;
        }
        ScreencastHelper.timerCloseSessionRestart();
        for (TokenItem tokenItem : TokenStorage.getTokens(ScreencastHelper.getSystemScreensBounds())) {
            int n = function.apply(tokenItem.token);
            if (n < 0 && ScreencastHelper.checkReturnValue(n, false)) continue;
            return;
        }
        ScreencastHelper.checkReturnValue(function.apply(null), false);
    }

    public static synchronized void remoteDesktopMouseMove(int n, int n2) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseMoveImpl(n, n2, string));
    }

    public static synchronized void remoteDesktopMouseButton(boolean bl, int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseButtonImpl(bl, n, string));
    }

    public static synchronized void remoteDesktopMouseWheel(int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopMouseWheelImpl(n, string));
    }

    public static synchronized void remoteDesktopKey(boolean bl, int n) {
        ScreencastHelper.performWithToken(string -> ScreencastHelper.remoteDesktopKeyImpl(bl, n, string));
    }

    private static synchronized native int remoteDesktopMouseMoveImpl(int var0, int var1, String var2);

    private static synchronized native int remoteDesktopMouseButtonImpl(boolean var0, int var1, String var2);

    private static synchronized native int remoteDesktopMouseWheelImpl(int var0, String var1);

    private static synchronized native int remoteDesktopKeyImpl(boolean var0, int var1, String var2);

    static {
        timerTask = null;
        timerCloseSession = new Timer("auto-close screencast session", true);
        if (AccessController.doPrivileged(() -> OSInfo.getOSType()) == OSInfo.OSType.SOLARIS) {
            SCREENCAST_DEBUG = false;
            IS_NATIVE_LOADED = false;
        } else {
            int n;
            SCREENCAST_DEBUG = Boolean.parseBoolean(AccessController.doPrivileged(new GetPropertyAction("awt.robot.screenshotDebug", "false")));
            boolean bl = false;
            boolean bl2 = XdgDesktopPortal.isRemoteDesktop() || XdgDesktopPortal.isScreencast();
            int n2 = n = XdgDesktopPortal.isScreencast() ? 0 : 1;
            if (!(Toolkit.getDefaultToolkit() instanceof UNIXToolkit && ((UNIXToolkit)Toolkit.getDefaultToolkit()).loadGTK() && bl2 && ScreencastHelper.loadPipewire(n, SCREENCAST_DEBUG))) {
                System.err.println("Could not load native libraries for ScreencastHelper");
                bl = true;
            }
            IS_NATIVE_LOADED = !bl;
        }
    }
}

