/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio;

import java.io.FileDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class NIOUtils {
    private static boolean separateIPv6Stack;
    private static final Field fdObjField;
    private static final Field fdInUseField;
    private static final Field fdValField;

    public static long getFileDescriptor(SocketChannel socketChannel) {
        if (!socketChannel.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (separateIPv6Stack) {
            return NIOUtils.getFileDescriptorSeparateIPv6Stack(socketChannel);
        }
        return NIOUtils.getFileDescriptorDefault(socketChannel);
    }

    private static long getFileDescriptorDefault(SocketChannel socketChannel) {
        long l = -1L;
        if (fdValField == null) {
            throw new IllegalStateException("Error retrieving socket from " + socketChannel + " (field not found)");
        }
        try {
            l = fdValField.getLong(socketChannel);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socketChannel);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return l;
    }

    private static long getFileDescriptorSeparateIPv6Stack(SocketChannel socketChannel) {
        assert (socketChannel.isConnected());
        long l = -1L;
        if (fdObjField == null) {
            throw new IllegalStateException("Error retrieving socket from " + socketChannel + " (FileDescriptor field not found)");
        }
        if (fdInUseField == null) {
            throw new IllegalStateException("Error retrieving socket from " + socketChannel + " (field not found)");
        }
        try {
            FileDescriptor fileDescriptor = (FileDescriptor)fdObjField.get(socketChannel);
            if (fileDescriptor == null) {
                throw new IllegalStateException("Error retrieving socket from " + socketChannel + " (null FileDescriptor)");
            }
            l = fdInUseField.getLong(fileDescriptor);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalStateException illegalStateException = new IllegalStateException("Error retrieving socket from " + socketChannel);
            illegalStateException.initCause(illegalAccessException);
            throw illegalStateException;
        }
        return l;
    }

    static {
        AnnotatedElement annotatedElement;
        separateIPv6Stack = false;
        Field field = null;
        Field field2 = null;
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.toUpperCase().startsWith("WINDOWS")) {
            try {
                annotatedElement = Class.forName("sun.nio.ch.Net");
                Field field3 = ((Class)annotatedElement).getDeclaredField("isSecondSocketRequired");
                field3.setAccessible(true);
                if (field3.getBoolean(null)) {
                    field = Class.forName("sun.nio.ch.SocketChannelImpl").getDeclaredField("fd");
                    field.setAccessible(true);
                    field2 = Class.forName("java.io.FileDescriptor").getDeclaredField("fdinuse");
                    field2.setAccessible(true);
                    separateIPv6Stack = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        fdObjField = field;
        fdInUseField = field2;
        annotatedElement = null;
        try {
            annotatedElement = Class.forName("sun.nio.ch.SocketChannelImpl").getDeclaredField("fdVal");
            ((AccessibleObject)annotatedElement).setAccessible(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdValField = annotatedElement;
    }
}

