/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump;

import java.util.Map;

public class HeapDumpSettings {
    public static final String HEAP_DUMP_FILE_PROPERTY = "heap_dump_file";
    public static final String HEAP_DUMP_FORMAT_PROPERTY = "heap_dump_format";
    public static final String MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY = "heap_dump_multiple_heaps_multiple_files";
    public static final String HEAP_DUMP_RUNTIME_ID = "heap_dump_runtime_id";

    public static void setFileName(String fileName, Map properties) {
        properties.put(HEAP_DUMP_FILE_PROPERTY, fileName);
    }

    public static String getFileName(Map properties) {
        String propertyFileName = (String)properties.get(HEAP_DUMP_FILE_PROPERTY);
        if (propertyFileName != null) {
            return propertyFileName;
        }
        return HeapDumpSettings.getDefaultHeapDumpFileName(properties);
    }

    public static boolean heapDumpFileNameSet(Map properties) {
        return properties.containsKey(HEAP_DUMP_FILE_PROPERTY);
    }

    private static String getDefaultHeapDumpFileName(Map properties) {
        String baseFileName = (String)properties.get("core_file_path");
        String runtimeID = (String)properties.get(HEAP_DUMP_RUNTIME_ID);
        if (runtimeID == null) {
            runtimeID = "";
        }
        if (HeapDumpSettings.areHeapDumpsPHD(properties)) {
            return baseFileName + runtimeID + ".phd";
        }
        return baseFileName + runtimeID + ".txt";
    }

    public static void setClassicHeapDumps(Map properties) {
        properties.put(HEAP_DUMP_FORMAT_PROPERTY, "classic");
    }

    public static boolean areHeapDumpsPHD(Map properties) {
        Object formatValue = properties.get(HEAP_DUMP_FORMAT_PROPERTY);
        return formatValue == null || !formatValue.equals("classic");
    }

    public static void setPHDHeapDumps(Map properties) {
        properties.put(HEAP_DUMP_FORMAT_PROPERTY, "phd");
    }

    public static void setMultipleHeapsMultipleFiles(Map properties) {
        properties.put(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY, "true");
    }

    public static void setMultipleHeapsSingleFile(Map properties) {
        properties.put(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY, "false");
    }

    public static void setRuntimeID(Map properties, int id) {
        properties.put(HEAP_DUMP_RUNTIME_ID, "." + id);
    }

    public static boolean multipleHeapsInMultipleFiles(Map properties) {
        Object multipleFilesValue = properties.get(MULTIPLE_HEAPS_MULTIPLE_FILES_PROPERTY);
        if (multipleFilesValue == null) {
            return false;
        }
        return multipleFilesValue.equals("true");
    }
}

