/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.DemoGroup;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import java2d.Java2Demo;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class RunWindow
extends JPanel
implements Runnable,
ActionListener {
    private final DemoInstVarsAccessor demoInstVars;
    private final JButton runB;
    private int delay = 10;
    private int numRuns = 20;
    private boolean exit;
    private final JCheckBox zoomCB = new JCheckBox("Zoom");
    private final JCheckBox printCB = new JCheckBox("Print");
    private boolean buffersFlag;
    private int bufBeg;
    private int bufEnd;
    private JTextField delayTextField;
    private JTextField runsTextField;
    private Thread thread;
    private JProgressBar pb;
    private DemoGroup dg = null;
    private DemoPanel dp = null;

    public RunWindow(DemoInstVarsAccessor demoInstVarsAccessor, RunWindowSettings runWindowSettings) {
        this.demoInstVars = demoInstVarsAccessor;
        this.delay = runWindowSettings.getDelay();
        this.numRuns = runWindowSettings.getNumRuns();
        this.exit = runWindowSettings.getExit();
        this.zoomCB.setSelected(runWindowSettings.isZoomCBSelected());
        this.printCB.setSelected(runWindowSettings.isPrintCBSelected());
        this.buffersFlag = runWindowSettings.getBuffersFlag();
        this.bufBeg = runWindowSettings.getBufBeg();
        this.bufEnd = runWindowSettings.getBufEnd();
        this.setLayout(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(new CompoundBorder(emptyBorder, new BevelBorder(1)));
        Font font = new Font("serif", 0, 10);
        this.runB = new JButton("Run");
        this.runB.setBackground(Color.GREEN);
        this.runB.addActionListener(this);
        this.runB.setMinimumSize(new Dimension(70, 30));
        Java2Demo.addToGridBag(this, this.runB, 0, 0, 1, 1, 0.0, 0.0);
        this.pb = new JProgressBar();
        this.pb.setPreferredSize(new Dimension(100, 30));
        this.pb.setMinimum(0);
        Java2Demo.addToGridBag(this, this.pb, 1, 0, 2, 1, 1.0, 0.0);
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Runs:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.BLACK);
        jPanel2.add(jLabel);
        this.runsTextField = new JTextField(String.valueOf(this.numRuns));
        jPanel2.add(this.runsTextField);
        this.runsTextField.setPreferredSize(new Dimension(30, 20));
        this.runsTextField.addActionListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Delay:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.BLACK);
        jPanel2.add(jLabel);
        this.delayTextField = new JTextField(String.valueOf(this.delay));
        jPanel2.add(this.delayTextField);
        this.delayTextField.setPreferredSize(new Dimension(30, 20));
        this.delayTextField.addActionListener(this);
        jPanel.add(jPanel2);
        this.zoomCB.setHorizontalAlignment(0);
        this.zoomCB.setFont(font);
        this.printCB.setFont(font);
        jPanel.add(this.zoomCB);
        jPanel.add(this.printCB);
        this.printCB.addActionListener(this);
        Java2Demo.addToGridBag(this, jPanel, 0, 1, 3, 1, 1.0, 1.0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.printCB)) {
            this.demoInstVars.getPrintCB().setSelected(this.printCB.isSelected());
        } else if (actionEvent.getSource().equals(this.delayTextField)) {
            this.delay = Integer.parseInt(this.delayTextField.getText().trim());
        } else if (actionEvent.getSource().equals(this.runsTextField)) {
            this.numRuns = Integer.parseInt(this.runsTextField.getText().trim());
        } else if ("Run".equals(actionEvent.getActionCommand())) {
            this.doRunAction();
        } else if ("Stop".equals(actionEvent.getActionCommand())) {
            this.stop();
        }
    }

    public void doRunAction() {
        this.runB.setText("Stop");
        this.runB.setBackground(Color.RED);
        this.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(6);
        this.thread.setName("RunWindow");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public void sleepPerTab() {
        for (int i = 0; i < this.delay + 1 && this.thread != null; ++i) {
            for (int j = 0; j < 10 && this.thread != null; ++j) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RunWindow.this.pb.setValue(RunWindow.this.pb.getValue() + 1);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void printDemo(final DemoGroup demoGroup) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!((RunWindow)RunWindow.this).demoInstVars.getControls().toolBarCB.isSelected()) {
                    ((RunWindow)RunWindow.this).demoInstVars.getControls().toolBarCB.setSelected(true);
                    demoGroup.invalidate();
                }
                for (Component component : demoGroup.getPanel().getComponents()) {
                    DemoPanel demoPanel = (DemoPanel)component;
                    if (demoPanel.tools == null) continue;
                    if (demoPanel.surface.animating != null && demoPanel.surface.animating.running()) {
                        demoPanel.tools.startStopB.doClick();
                    }
                    demoPanel.tools.printB.doClick();
                }
            }
        };
        RunWindow.invokeAndWait(runnable);
    }

    @Override
    public void run() {
        System.out.println("\nJava2D Demo RunWindow : " + this.numRuns + " Runs, " + this.delay + " second delay between tabs\njava version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < this.numRuns && this.thread != null; ++i) {
            Date date = new Date();
            System.out.print("#" + i + " " + date.toString() + ", ");
            runtime.gc();
            float f = runtime.freeMemory();
            float f2 = runtime.totalMemory();
            System.out.println((f2 - f) / 1024.0f + "K used");
            for (int j = 0; j < this.demoInstVars.getTabbedPane().getTabCount() && this.thread != null; ++j) {
                final int n = j;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        RunWindow.this.pb.setValue(0);
                        RunWindow.this.pb.setMaximum(RunWindow.this.delay);
                        if (n != 0) {
                            RunWindow.this.dg = RunWindow.this.demoInstVars.getGroup()[n - 1];
                            RunWindow.this.dg.invalidate();
                        }
                        RunWindow.this.demoInstVars.getTabbedPane().setSelectedIndex(n);
                    }
                };
                RunWindow.invokeAndWait(runnable);
                if (j != 0 && (this.zoomCB.isSelected() || this.buffersFlag)) {
                    this.dp = (DemoPanel)this.dg.getPanel().getComponent(0);
                    if (this.dg.tabbedPane == null && this.dp.surface != null) {
                        Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                RunWindow.this.dg.mouseClicked(((RunWindow)RunWindow.this).dp.surface);
                            }
                        };
                        RunWindow.invokeAndWait(runnable2);
                    }
                    for (int k = 1; k < this.dg.tabbedPane.getTabCount() && this.thread != null; ++k) {
                        final int n2 = k;
                        Runnable runnable3 = new Runnable(){

                            @Override
                            public void run() {
                                RunWindow.this.pb.setValue(0);
                                RunWindow.this.pb.setMaximum(RunWindow.this.delay);
                                ((RunWindow)RunWindow.this).dg.tabbedPane.setSelectedIndex(n2);
                            }
                        };
                        RunWindow.invokeAndWait(runnable3);
                        final JPanel jPanel = this.dg.getPanel();
                        if (this.buffersFlag && jPanel.getComponentCount() == 1) {
                            this.dp = (DemoPanel)jPanel.getComponent(0);
                            if (this.dp.surface.animating != null) {
                                this.dp.surface.animating.stop();
                            }
                            int n3 = this.bufBeg;
                            while (n3 <= this.bufEnd && this.thread != null) {
                                final int n4 = n3++;
                                Runnable runnable4 = new Runnable(){

                                    @Override
                                    public void run() {
                                        ((RunWindow)RunWindow.this).dp.tools.cloneB.doClick();
                                        int n = jPanel.getComponentCount();
                                        DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(n - 1);
                                        if (demoPanel.surface.animating != null) {
                                            demoPanel.surface.animating.stop();
                                        }
                                        demoPanel.tools.issueRepaint = true;
                                        demoPanel.tools.screenCombo.setSelectedIndex(n4);
                                        demoPanel.tools.issueRepaint = false;
                                    }
                                };
                                RunWindow.invokeAndWait(runnable4);
                            }
                        }
                        if (this.printCB.isSelected()) {
                            this.printDemo(this.dg);
                        }
                        this.sleepPerTab();
                    }
                    continue;
                }
                if (j != 0 && this.printCB.isSelected()) {
                    this.printDemo(this.dg);
                    this.sleepPerTab();
                    continue;
                }
                this.sleepPerTab();
            }
            if (i + 1 != this.numRuns) continue;
            System.out.println("Finished.");
            if (!this.exit || this.thread == null) continue;
            System.out.println("System.exit(0).");
            System.exit(0);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RunWindow.this.runB.setText("Run");
                RunWindow.this.runB.setBackground(Color.GREEN);
                RunWindow.this.pb.setValue(0);
            }
        };
        RunWindow.invokeAndWait(runnable);
        this.thread = null;
        this.dg = null;
        this.dp = null;
    }

    private static void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            Logger.getLogger(RunWindow.class.getName()).log(Level.SEVERE, "ERROR in invokeAndWait", exception);
        }
    }

    public static class RunWindowSettings {
        private int delay = 10;
        private int numRuns = 20;
        private boolean exit;
        private boolean zoomCBIsSelected;
        private boolean printCBIsSelected;
        private boolean buffersFlag;
        private int bufBeg;
        private int bufEnd;

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int n) {
            this.delay = n;
        }

        public int getNumRuns() {
            return this.numRuns;
        }

        public void setNumRuns(int n) {
            this.numRuns = n;
        }

        public boolean getExit() {
            return this.exit;
        }

        public void setExit(boolean bl) {
            this.exit = bl;
        }

        public boolean isZoomCBSelected() {
            return this.zoomCBIsSelected;
        }

        public void setZoomCBSelected(boolean bl) {
            this.zoomCBIsSelected = bl;
        }

        public boolean isPrintCBSelected() {
            return this.printCBIsSelected;
        }

        public void setPrintCBIsSelected(boolean bl) {
            this.printCBIsSelected = bl;
        }

        public boolean getBuffersFlag() {
            return this.buffersFlag;
        }

        public void setBuffersFlag(boolean bl) {
            this.buffersFlag = bl;
        }

        public int getBufBeg() {
            return this.bufBeg;
        }

        public void setBufBeg(int n) {
            this.bufBeg = n;
        }

        public int getBufEnd() {
            return this.bufEnd;
        }

        public void setBufEnd(int n) {
            this.bufEnd = n;
        }
    }
}

