/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java2d.DemoImages;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class Intro
extends JPanel {
    private static final Color myBlack = new Color(20, 20, 20);
    private static final Color myWhite = new Color(240, 240, 255);
    private static final Color myRed = new Color(149, 43, 42);
    private static final Color myBlue = new Color(94, 105, 176);
    private static final Color myYellow = new Color(255, 255, 140);
    private ScenesTable scenesTable;
    private boolean doTable;
    private final Surface surface;

    public Intro() {
        EmptyBorder emptyBorder = new EmptyBorder(80, 110, 80, 110);
        BevelBorder bevelBorder = new BevelBorder(1);
        this.setBorder(new CompoundBorder(emptyBorder, bevelBorder));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.GRAY);
        this.setToolTipText("click for scene table");
        this.surface = new Surface();
        this.add(this.surface);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Intro.this.removeAll();
                if (Intro.this.doTable = !Intro.this.doTable) {
                    Intro.this.setToolTipText("click for animation");
                    Intro.this.surface.stop();
                    if (Intro.this.scenesTable == null) {
                        Intro.this.scenesTable = new ScenesTable(Intro.this);
                    }
                    Intro.this.add(Intro.this.scenesTable);
                } else {
                    Intro.this.setToolTipText("click for scene table");
                    Intro.this.surface.start();
                    Intro.this.add(Intro.this.surface);
                }
                Intro.this.revalidate();
                Intro.this.repaint();
            }
        });
    }

    public void start() {
        if (!this.doTable) {
            this.surface.start();
        }
    }

    public void stop() {
        if (!this.doTable) {
            this.surface.stop();
        }
    }

    public static void main(String[] stringArray) {
        final Intro intro = new Intro();
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                intro.start();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                intro.stop();
            }
        };
        JFrame jFrame = new JFrame("Java2D Demo - Intro");
        jFrame.addWindowListener(windowAdapter);
        jFrame.getContentPane().add("Center", intro);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 720;
        int n2 = 510;
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
        intro.start();
    }

    static class ScenesTable
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private final Intro intro;
        private JTable table;
        private TableModel dataModel;

        public ScenesTable(final Intro intro) {
            this.intro = intro;
            this.setBackground(Color.WHITE);
            this.setLayout(new BorderLayout());
            final String[] stringArray = new String[]{"", "Scenes", "Pause"};
            this.dataModel = new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return stringArray.length;
                }

                @Override
                public int getRowCount() {
                    return ((Intro)intro).surface.director.size();
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    Surface.Scene scene = (Surface.Scene)((Intro)intro).surface.director.get(n);
                    if (n2 == 0) {
                        return scene.participate;
                    }
                    if (n2 == 1) {
                        return scene.name;
                    }
                    return scene.pauseAmt;
                }

                @Override
                public String getColumnName(int n) {
                    return stringArray[n];
                }

                @Override
                public Class<?> getColumnClass(int n) {
                    return this.getValueAt(0, n).getClass();
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return n2 != 1;
                }

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    Surface.Scene scene = (Surface.Scene)((Intro)intro).surface.director.get(n);
                    if (n2 == 0) {
                        scene.participate = object;
                    } else if (n2 == 1) {
                        scene.name = object;
                    } else {
                        scene.pauseAmt = object;
                    }
                }
            };
            this.table = new JTable(this.dataModel);
            TableColumn tableColumn = this.table.getColumn("");
            tableColumn.setWidth(16);
            tableColumn.setMinWidth(16);
            tableColumn.setMaxWidth(20);
            tableColumn = this.table.getColumn("Pause");
            tableColumn.setWidth(60);
            tableColumn.setMinWidth(60);
            tableColumn.setMaxWidth(60);
            this.table.sizeColumnsToFit(0);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.add(jScrollPane);
            JPanel jPanel = new JPanel(new BorderLayout());
            JButton jButton = new JButton("Unselect All");
            jButton.setHorizontalAlignment(2);
            Font font = new Font("serif", 0, 10);
            jButton.setFont(font);
            jButton.addActionListener(this);
            jPanel.add("West", jButton);
            JSlider jSlider = new JSlider(0, 0, 200, (int)((Intro)intro).surface.sleepAmt);
            jSlider.addChangeListener(this);
            TitledBorder titledBorder = new TitledBorder(new EtchedBorder());
            titledBorder.setTitleFont(font);
            titledBorder.setTitle("Anim delay = " + String.valueOf(((Intro)intro).surface.sleepAmt) + " ms");
            jSlider.setBorder(titledBorder);
            jSlider.setPreferredSize(new Dimension(140, 40));
            jSlider.setMinimumSize(new Dimension(100, 40));
            jSlider.setMaximumSize(new Dimension(180, 40));
            jPanel.add("East", jSlider);
            this.add("South", jPanel);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            jButton.setSelected(!(jButton = (JButton)actionEvent.getSource()).isSelected());
            jButton.setText(jButton.isSelected() ? "Select All" : "Unselect All");
            for (int i = 0; i < ((Intro)this.intro).surface.director.size(); ++i) {
                Surface.Scene scene = (Surface.Scene)((Intro)this.intro).surface.director.get(i);
                scene.participate = !jButton.isSelected();
            }
            this.table.tableChanged(new TableModelEvent(this.dataModel));
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            TitledBorder titledBorder = (TitledBorder)jSlider.getBorder();
            titledBorder.setTitle("Anim delay = " + String.valueOf(n) + " ms");
            ((Intro)this.intro).surface.sleepAmt = n;
            jSlider.repaint();
        }
    }

    static class Surface
    extends JPanel
    implements Runnable {
        private final Image cupanim;
        private final Image java_logo;
        private BufferedImage bimg;
        public Director director;
        public int index;
        public long sleepAmt = 30L;
        private Thread thread;

        public Surface() {
            this.setBackground(myBlack);
            this.setLayout(new BorderLayout());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (thread == null) {
                        this.start();
                    } else {
                        this.stop();
                    }
                }
            });
            this.cupanim = DemoImages.getImage("cupanim.gif", this);
            this.java_logo = DemoImages.getImage("java_logo.png", this);
            this.director = new Director(this);
        }

        public FontMetrics getMetrics(Font font) {
            return this.getFontMetrics(font);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            if (this.bimg == null || this.bimg.getWidth() != dimension.width || this.bimg.getHeight() != dimension.height) {
                this.bimg = this.getGraphicsConfiguration().createCompatibleImage(dimension.width, dimension.height);
                for (int i = this.index + 1; i < this.director.size(); ++i) {
                    ((Scene)this.director.get(i)).reset(dimension.width, dimension.height);
                }
            }
            Scene scene = (Scene)this.director.get(this.index);
            if (scene.index <= scene.length) {
                if (this.thread != null) {
                    scene.step(dimension.width, dimension.height);
                }
                Graphics2D graphics2D = this.bimg.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                scene.render(dimension.width, dimension.height, graphics2D);
                if (this.thread != null) {
                    ++scene.index;
                }
                graphics2D.dispose();
            }
            graphics.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.setName("Intro");
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
            this.notifyAll();
        }

        public void reset() {
            this.index = 0;
            Dimension dimension = this.getSize();
            for (Scene scene : this.director) {
                scene.reset(dimension.width, dimension.height);
            }
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width <= 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            if (this.index == 0) {
                this.reset();
            }
            while (this.thread == thread) {
                Scene scene = (Scene)this.director.get(this.index);
                if (((Boolean)scene.participate).booleanValue()) {
                    this.repaint();
                    try {
                        Thread.sleep(this.sleepAmt);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    if (scene.index <= scene.length) continue;
                    scene.pause();
                    if (++this.index < this.director.size()) continue;
                    this.reset();
                    continue;
                }
                if (++this.index < this.director.size()) continue;
                this.reset();
            }
            this.thread = null;
        }

        static class CoE
        implements Part {
            private final Surface surf;
            static final int WID = 1;
            static final int HEI = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int RAND = 16;
            static final int ARC = 32;
            private int type;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Shape shape;
            private double zoom;
            private double extent;
            private double zIncr;
            private double eIncr;
            private boolean doRandom;

            public CoE(int n, int n2, int n3, Surface surface) {
                this.type = n;
                this.beginning = n2;
                this.ending = n3;
                this.surf = surface;
                this.zIncr = -(2.0 / (double)(this.ending - this.beginning));
                this.eIncr = 360.0 / (double)(this.ending - this.beginning);
                this.doRandom = (n & 0x10) != 0;
            }

            @Override
            public void reset(int n, int n2) {
                if (this.doRandom) {
                    int n3 = (int)(Math.random() * 5.0);
                    switch (n3) {
                        case 0: {
                            this.type = 4;
                            break;
                        }
                        case 1: {
                            this.type = 8;
                            break;
                        }
                        case 2: {
                            this.type = 9;
                            break;
                        }
                        case 3: {
                            this.type = 10;
                            break;
                        }
                        case 4: {
                            this.type = 32;
                            break;
                        }
                        default: {
                            this.type = 4;
                        }
                    }
                }
                this.shape = null;
                this.bimg = null;
                this.extent = 360.0;
                this.zoom = 2.0;
            }

            @Override
            public void step(int n, int n2) {
                if (this.bimg == null) {
                    int n3 = this.surf.bimg.getWidth();
                    int n4 = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    Graphics2D graphics2D = this.bimg.createGraphics();
                    graphics2D.drawImage((Image)this.surf.bimg, 0, 0, null);
                }
                double d = (double)Math.min(n, n2) * this.zoom;
                if ((this.type & 4) != 0) {
                    this.shape = new Ellipse2D.Double((double)(n / 2) - d / 2.0, (double)(n2 / 2) - d / 2.0, d, d);
                } else if ((this.type & 0x20) != 0) {
                    this.shape = new Arc2D.Double(-100.0, -100.0, n + 200, n2 + 200, 90.0, this.extent, 2);
                    this.extent -= this.eIncr;
                } else if ((this.type & 8) != 0) {
                    this.shape = (this.type & 1) != 0 ? new Rectangle2D.Double((double)(n / 2) - d / 2.0, 0.0, d, n2) : ((this.type & 2) != 0 ? new Rectangle2D.Double(0.0, (double)(n2 / 2) - d / 2.0, n, d) : new Rectangle2D.Double((double)(n / 2) - d / 2.0, (double)(n2 / 2) - d / 2.0, d, d));
                }
                this.zoom += this.zIncr;
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.clip(this.shape);
                graphics2D.drawImage((Image)this.bimg, 0, 0, null);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Contributors
        implements Part {
            private static final String[] members = new String[]{"Brian Lichtenwalter", "Jeannette Hung", "Thanh Nguyen", "Jim Graham", "Jerry Evans", "John Raley", "Michael Peirce", "Robert Kim", "Jennifer Ball", "Deborah Adair", "Paul Charlton", "Dmitry Feld", "Gregory Stone", "Richard Blanchard", "Link Perry", "Phil Race", "Vincent Hardy", "Parry Kejriwal", "Doug Felt", "Rekha Rangarajan", "Paula Patel", "Michael Bundschuh", "Joe Warzecha", "Joey Beheler", "Aastha Bhardwaj", "Daniel Rice", "Chris Campbell", "Shinsuke Fukuda", "Dmitri Trembovetski", "Chet Haase", "Jennifer Godinez", "Nicholas Talian", "Raul Vera", "Ankit Patel", "Ilya Bagrak", "Praveen Mohan", "Rakesh Menon"};
            private static final Font font = new Font("serif", 0, 26);
            private final FontMetrics fm;
            private int beginning;
            private int ending;
            private int nStrs;
            private int strH;
            private int index;
            private int yh;
            private int height;
            private List<String> v = new ArrayList<String>();
            private List<String> cast = new ArrayList<String>(members.length + 3);
            private int counter;
            private int cntMod;
            private GradientPaint gp;

            public Contributors(int n, int n2, Surface surface) {
                this.beginning = n;
                this.ending = n2;
                this.fm = surface.getMetrics(font);
                Arrays.sort(members);
                this.cast.add("CONTRIBUTORS");
                this.cast.add(" ");
                this.cast.addAll(Arrays.asList(members));
                this.cast.add(" ");
                this.cast.add(" ");
                this.cntMod = (this.ending - this.beginning) / this.cast.size() - 1;
            }

            @Override
            public void reset(int n, int n2) {
                this.v.clear();
                this.strH = this.fm.getAscent() + this.fm.getDescent();
                this.nStrs = (n2 - 40) / this.strH + 1;
                this.height = this.strH * (this.nStrs - 1) + 48;
                this.index = 0;
                this.gp = new GradientPaint(0.0f, n2 / 2, Color.WHITE, 0.0f, n2 + 20, Color.BLACK);
                this.counter = 0;
            }

            @Override
            public void step(int n, int n2) {
                if (this.counter++ % this.cntMod == 0) {
                    if (this.index < this.cast.size()) {
                        this.v.add(this.cast.get(this.index));
                    }
                    if (!(this.v.size() != this.nStrs && this.index < this.cast.size() || this.v.isEmpty())) {
                        this.v.remove(0);
                    }
                    ++this.index;
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setPaint(this.gp);
                graphics2D.setFont(font);
                double d = this.counter % this.cntMod;
                double d2 = 1.0 - d / (double)this.cntMod;
                d2 = d2 == 1.0 ? 0.0 : d2;
                int n3 = (int)(d2 * (double)this.strH);
                n3 = this.index >= this.cast.size() ? this.yh + n3 : (this.yh = this.height - this.v.size() * this.strH + n3);
                for (String string : this.v) {
                    graphics2D.drawString(string, n / 2 - this.fm.stringWidth(string) / 2, n3 += this.strH);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class DdE
        implements Part {
            private final Surface surf;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private Graphics2D big;
            private List<Integer> list;
            private List<Integer> xlist;
            private List<Integer> ylist;
            private int xeNum;
            private int yeNum;
            private int xcSize;
            private int ycSize;
            private int inc;
            private int blocksize;

            public DdE(int n, int n2, int n3, Surface surface) {
                this.beginning = n;
                this.ending = n2;
                this.blocksize = n3;
                this.surf = surface;
            }

            private void createShuffledLists() {
                int n;
                int n2 = this.bimg.getWidth();
                int n3 = this.bimg.getHeight();
                this.xlist = new ArrayList<Integer>(n2);
                this.ylist = new ArrayList<Integer>(n3);
                this.list = new ArrayList<Integer>(this.ending - this.beginning + 1);
                for (n = 0; n < n2; ++n) {
                    this.xlist.add(n, n);
                }
                for (n = 0; n < n3; ++n) {
                    this.ylist.add(n, n);
                }
                for (n = 0; n < this.ending - this.beginning + 1; ++n) {
                    this.list.add(n, n);
                }
                Collections.shuffle(this.xlist);
                Collections.shuffle(this.ylist);
                Collections.shuffle(this.list);
            }

            @Override
            public void reset(int n, int n2) {
                this.bimg = null;
            }

            @Override
            public void step(int n, int n2) {
                if (this.inc > this.ending) {
                    this.bimg = null;
                }
                if (this.bimg == null) {
                    int n3 = this.surf.bimg.getWidth();
                    int n4 = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    this.createShuffledLists();
                    this.big = this.bimg.createGraphics();
                    this.big.drawImage((Image)this.surf.bimg, 0, 0, null);
                    this.xcSize = this.xlist.size() / (this.ending - this.beginning) + 1;
                    this.ycSize = this.ylist.size() / (this.ending - this.beginning) + 1;
                    this.xeNum = 0;
                    this.inc = 0;
                }
                this.xeNum = this.xcSize * this.list.get(this.inc);
                this.yeNum = -this.ycSize;
                ++this.inc;
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                this.big.setColor(myBlack);
                for (int i = 0; i <= this.ending - this.beginning; ++i) {
                    this.xeNum = this.xeNum + this.xcSize > this.xlist.size() ? 0 : (this.xeNum += this.xcSize);
                    this.yeNum += this.ycSize;
                    for (int j = this.xeNum; j < this.xeNum + this.xcSize && j < this.xlist.size(); ++j) {
                        for (int k = this.yeNum; k < this.yeNum + this.ycSize && k < this.ylist.size(); ++k) {
                            int n3 = this.xlist.get(j);
                            int n4 = this.ylist.get(k);
                            if (n3 % this.blocksize != 0 || n4 % this.blocksize != 0) continue;
                            this.big.fillRect(n3, n4, this.blocksize, this.blocksize);
                        }
                    }
                }
                graphics2D.drawImage((Image)this.bimg, 0, 0, null);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Director
        extends ArrayList<Scene> {
            GradientPaint gp = new GradientPaint(0.0f, 40.0f, Intro.access$500(), 38.0f, 2.0f, Intro.access$300());
            Font f1 = new Font("serif", 0, 200);
            Font f2 = new Font("serif", 0, 120);
            Font f3 = new Font("serif", 0, 72);

            public Director(Surface surface) {
                Object[][][] objectArrayArray;
                for (Object[][] objectArray : objectArrayArray = new Object[][][]{{{"J  -  scale text on gradient", "0"}, {new GpE(69, myBlack, myBlue, 0, 20), new TxE("J", this.f1, 9, myYellow, 2, 20)}}, {{"2  -  scale & rotate text on gradient", "0"}, {new GpE(69, myBlue, myBlack, 0, 22), new TxE("2", this.f1, 13, myYellow, 2, 22)}}, {{"D  -  scale text on gradient", "0"}, {new GpE(69, myBlack, myBlue, 0, 20), new TxE("D", this.f1, 9, myYellow, 2, 20)}}, {{"Java2D  -  scale & rotate text on gradient", "1000"}, {new GpE(53, myBlue, myBlack, 0, 40), new TxE("Java2D", this.f2, 13, myYellow, 0, 40)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 1, surface)}}, {{"Graphics Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surface.java_logo, 2, 15), new Temp(7, surface.java_logo, 16, 130), new Features(0, 16, 130, surface)}}, {{"Java2D  -  texture text on gradient", "1000"}, {new GpE(9, myBlue, myBlack, 0, 20), new GpE(10, myBlue, myBlack, 21, 40), new TpE(37, myBlack, myYellow, 4, 0, 10), new TpE(38, myBlack, myYellow, 4, 11, 20), new TpE(53, myBlack, myYellow, 5, 21, 40), new TxE("Java2D", this.f2, 0, null, 0, 40)}}, {{"Previous scene random close out", "0"}, {new CoE(16, 0, 20, surface)}}, {{"Text Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surface.java_logo, 2, 15), new Temp(7, surface.java_logo, 16, 130), new Features(1, 16, 130, surface)}}, {{"Java2D  -  composite text on texture", "1000"}, {new TpE(9, myBlack, this.gp, 40, 0, 20), new TpE(10, myBlack, this.gp, 40, 21, 40), new TpE(9, myBlack, this.gp, 40, 41, 60), new TxE("Java2D", this.f2, 64, myYellow, 0, 60)}}, {{"Previous scene dither dissolve out", "0"}, {new DdE(0, 20, 4, surface)}}, {{"Imaging Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surface.java_logo, 2, 15), new Temp(7, surface.java_logo, 16, 130), new Features(2, 16, 130, surface)}}, {{"Java2D  -  text on gradient", "1000"}, {new GpE(54, myBlue, myBlack, 0, 20), new GpE(53, myBlue, myBlack, 21, 40), new GpE(54, myBlue, myBlack, 41, 50), new GpE(129, myRed, myYellow, 0, 50), new TxE("Java2D", this.f2, 512, null, 0, 50)}}, {{"Previous scene ellipse close out", "0"}, {new CoE(4, 0, 20, surface)}}, {{"Color Features", "999"}, {new Temp(2, null, 0, 15), new Temp(4, surface.java_logo, 2, 15), new Temp(7, surface.java_logo, 16, 99), new Features(3, 16, 99, surface)}}, {{"Java2D  -  composite and rotate text on paints", "2000"}, {new GpE(69, myBlack, myBlue, 0, 20), new GpE(70, myBlack, myBlue, 21, 30), new TpE(21, myBlack, myBlue, 10, 31, 40), new TxE("Java2D", this.f2, 69, myYellow, 0, 40)}}, {{"Previous scene subimage transform out", "0"}, {new SiE(60, 60, 0, 40, surface)}}, {{"CREDITS  -  transform in", "1000"}, {new LnE(45, 0, 60), new TxE("CREDITS", this.f3, 73, Color.RED, 20, 30), new TxE("CREDITS", this.f3, 26, Color.RED, 31, 38), new TxE("CREDITS", this.f3, 25, Color.RED, 39, 48), new TxE("CREDITS", this.f3, 26, Color.RED, 49, 54), new TxE("CREDITS", this.f3, 25, Color.RED, 55, 60)}}, {{"CREDITS  -  transform out", "0"}, {new LnE(46, 0, 45), new TxE("CREDITS", this.f3, 0, Color.RED, 0, 9), new TxE("CREDITS", this.f3, 14, Color.RED, 10, 30)}}, {{"Contributors", "1000"}, {new Temp(2, null, 0, 30), new Temp(4, surface.cupanim, 4, 30), new Temp(7, surface.cupanim, 31, 200), new Contributors(34, 200, surface)}}}) {
                    ArrayList<Part> arrayList = new ArrayList<Part>();
                    for (Object object : objectArray[1]) {
                        arrayList.add((Part)object);
                    }
                    this.add(new Scene(arrayList, objectArray[0][0], objectArray[0][1]));
                }
            }
        }

        static class Features
        implements Part {
            static final int GRAPHICS = 0;
            static final int TEXT = 1;
            static final int IMAGES = 2;
            static final int COLOR = 3;
            static final Font font1 = new Font("serif", 1, 38);
            static final Font font2 = new Font("serif", 0, 24);
            private final FontMetrics fm1;
            private final FontMetrics fm2;
            private static final String[][] table = new String[][]{{"Graphics", "Antialiased rendering", "Bezier paths", "Transforms", "Compositing", "Stroking parameters"}, {"Text", "Extended font support", "Advanced text layout", "Dynamic font loading", "AttributeSets for font customization"}, {"Images", "Flexible image layouts", "Extended imaging operations", "   Convolutions, Lookup Tables", "RenderableImage interface"}, {"Color", "ICC profile support", "Color conversion", "Arbitrary color spaces"}};
            private String[] list;
            private int beginning;
            private int ending;
            private int strH;
            private int endIndex;
            private int listIndex;
            private List<String> v = new ArrayList<String>();

            public Features(int n, int n2, int n3, Surface surface) {
                this.list = table[n];
                this.beginning = n2;
                this.ending = n3;
                this.fm1 = surface.getMetrics(font1);
                this.fm2 = surface.getMetrics(font2);
            }

            @Override
            public void reset(int n, int n2) {
                this.strH = this.fm2.getAscent() + this.fm2.getDescent();
                this.endIndex = 1;
                this.listIndex = 0;
                this.v.clear();
                this.v.add(this.list[this.listIndex].substring(0, this.endIndex));
            }

            @Override
            public void step(int n, int n2) {
                if (this.listIndex < this.list.length) {
                    if (++this.endIndex > this.list[this.listIndex].length()) {
                        if (++this.listIndex < this.list.length) {
                            this.endIndex = 1;
                            this.v.add(this.list[this.listIndex].substring(0, this.endIndex));
                        }
                    } else {
                        this.v.set(this.listIndex, this.list[this.listIndex].substring(0, this.endIndex));
                    }
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setColor(myWhite);
                graphics2D.setFont(font1);
                graphics2D.drawString(this.v.get(0), 90, 85);
                graphics2D.setFont(font2);
                int n3 = 90;
                for (int i = 1; i < this.v.size(); ++i) {
                    graphics2D.drawString(this.v.get(i), 120, n3 += this.strH);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class GpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int CNT = 4;
            static final int WID = 8;
            static final int WI = 9;
            static final int WD = 10;
            static final int HEI = 16;
            static final int HI = 17;
            static final int HD = 18;
            static final int SPL = 36;
            static final int SIW = 45;
            static final int SDW = 46;
            static final int SIH = 53;
            static final int SDH = 54;
            static final int BUR = 68;
            static final int BURI = 69;
            static final int BURD = 70;
            static final int NF = 128;
            private Color c1;
            private Color c2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private List<Rectangle2D> rect = new ArrayList<Rectangle2D>();
            private List<GradientPaint> grad = new ArrayList<GradientPaint>();
            private int type;

            public GpE(int n, Color color, Color color2, int n2, int n3) {
                this.type = n;
                this.c1 = color;
                this.c2 = color2;
                this.beginning = n2;
                this.ending = n3;
            }

            @Override
            public void reset(int n, int n2) {
                this.incr = 1.0f / (float)(this.ending - this.beginning);
                if ((this.type & 4) != 0) {
                    this.incr /= 2.3f;
                }
                if ((this.type & 4) != 0 && (this.type & 1) != 0) {
                    this.index = 0.5f;
                } else if ((this.type & 2) != 0) {
                    this.index = 1.0f;
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            @Override
            public void step(int n, int n2) {
                this.rect.clear();
                this.grad.clear();
                if ((this.type & 8) != 0) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        f = (float)n * 0.5f;
                        f2 = (float)n * (1.0f - this.index);
                        f3 = (float)n * this.index;
                    } else {
                        f2 = f3 = (f = (float)n * this.index);
                    }
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, f, n2));
                    this.rect.add(new Rectangle2D.Float(f, 0.0f, (float)n - f, n2));
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, f2, 0.0f, this.c2));
                    this.grad.add(new GradientPaint(f3, 0.0f, this.c2, n, 0.0f, this.c1));
                } else if ((this.type & 0x10) != 0) {
                    float f = 0.0f;
                    float f4 = 0.0f;
                    float f5 = 0.0f;
                    if ((this.type & 0x24) != 0) {
                        f = (float)n2 * 0.5f;
                        f4 = (float)n2 * (1.0f - this.index);
                        f5 = (float)n2 * this.index;
                    } else {
                        f4 = f5 = (f = (float)n2 * this.index);
                    }
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, n, f));
                    this.rect.add(new Rectangle2D.Float(0.0f, f, n, (float)n2 - f));
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, f4, this.c2));
                    this.grad.add(new GradientPaint(0.0f, f5, this.c2, 0.0f, n2, this.c1));
                } else if ((this.type & 0x44) != 0) {
                    float f = n / 2;
                    float f6 = n2 / 2;
                    this.rect.add(new Rectangle2D.Float(0.0f, 0.0f, f, f6));
                    this.rect.add(new Rectangle2D.Float(f, 0.0f, f, f6));
                    this.rect.add(new Rectangle2D.Float(0.0f, f6, f, f6));
                    this.rect.add(new Rectangle2D.Float(f, f6, f, f6));
                    float f7 = (float)n * (1.0f - this.index);
                    float f8 = (float)n * this.index;
                    float f9 = (float)n2 * (1.0f - this.index);
                    float f10 = (float)n2 * this.index;
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, f7, f9, this.c2));
                    this.grad.add(new GradientPaint(n, 0.0f, this.c1, f8, f9, this.c2));
                    this.grad.add(new GradientPaint(0.0f, n2, this.c1, f7, f10, this.c2));
                    this.grad.add(new GradientPaint(n, n2, this.c1, f8, f10, this.c2));
                } else if ((this.type & 0x80) != 0) {
                    float f = (float)n2 * this.index;
                    this.grad.add(new GradientPaint(0.0f, 0.0f, this.c1, 0.0f, f, this.c2));
                }
                if ((this.type & 1) != 0 || (this.type & 2) != 0) {
                    this.index += this.incr;
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                for (int i = 0; i < this.grad.size(); ++i) {
                    graphics2D.setPaint(this.grad.get(i));
                    if ((this.type & 0x80) != 0) continue;
                    graphics2D.fill(this.rect.get(i));
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class LnE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int ZOOM = 8;
            static final int AC = 32;
            static final int RI = 5;
            static final int RD = 6;
            static final int ZOOMI = 9;
            static final int ZOOMD = 10;
            static final int ACI = 33;
            static final int ACD = 34;
            private int beginning;
            private int ending;
            private double rIncr;
            private double rotate;
            private double zIncr;
            private double zoom;
            private List<Point2D.Double> pts = new ArrayList<Point2D.Double>();
            private float alpha;
            private float aIncr;
            private int type;

            public LnE(int n, int n2, int n3) {
                this.type = n;
                this.beginning = n2;
                this.ending = n3;
                float f = this.ending - this.beginning;
                this.rIncr = 360.0f / f;
                this.aIncr = 0.9f / f;
                this.zIncr = 2.0f / f;
                if ((n & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.aIncr = -this.aIncr;
                    this.zIncr = -this.zIncr;
                }
            }

            public void generatePts(int n, int n2, double d) {
                this.pts.clear();
                double d2 = (double)Math.min(n, n2) * d;
                Ellipse2D.Double double_ = new Ellipse2D.Double((double)(n / 2) - d2 / 2.0, (double)(n2 / 2) - d2 / 2.0, d2, d2);
                PathIterator pathIterator = double_.getPathIterator(null, 0.8);
                while (!pathIterator.isDone()) {
                    double[] dArray = new double[6];
                    switch (pathIterator.currentSegment(dArray)) {
                        case 0: 
                        case 1: {
                            this.pts.add(new Point2D.Double(dArray[0], dArray[1]));
                        }
                    }
                    pathIterator.next();
                }
            }

            @Override
            public void reset(int n, int n2) {
                if ((this.type & 2) != 0) {
                    this.rotate = 360.0;
                    this.alpha = 1.0f;
                    this.zoom = 2.0;
                } else {
                    this.alpha = 0.0f;
                    this.rotate = 0.0f;
                    this.zoom = 0.0;
                }
                if ((this.type & 8) == 0) {
                    this.generatePts(n, n2, 0.5);
                }
            }

            @Override
            public void step(int n, int n2) {
                if ((this.type & 8) != 0) {
                    this.generatePts(n, n2, this.zoom += this.zIncr);
                }
                if ((this.type & 5) != 0 || (this.type & 5) != 0) {
                    this.rotate += this.rIncr;
                }
                if ((this.type & 0x21) != 0 || (this.type & 0x22) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                Cloneable cloneable;
                Composite composite = null;
                if ((this.type & 0x20) != 0 && this.alpha >= 0.0f && this.alpha <= 1.0f) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                }
                AffineTransform affineTransform = null;
                if ((this.type & 4) != 0) {
                    affineTransform = graphics2D.getTransform();
                    cloneable = new AffineTransform();
                    cloneable.rotate(Math.toRadians(this.rotate), n / 2, n2 / 2);
                    graphics2D.setTransform((AffineTransform)cloneable);
                }
                cloneable = new Point2D.Double(n / 2, n2 / 2);
                graphics2D.setColor(Color.YELLOW);
                for (Point2D point2D : this.pts) {
                    graphics2D.draw(new Line2D.Float((Point2D)cloneable, point2D));
                }
                if (affineTransform != null) {
                    graphics2D.setTransform(affineTransform);
                }
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static interface Part {
            public void reset(int var1, int var2);

            public void step(int var1, int var2);

            public void render(int var1, int var2, Graphics2D var3);

            public int getBegin();

            public int getEnd();
        }

        static class Scene {
            public Object name;
            public Object participate = Boolean.TRUE;
            public Object pauseAmt;
            public List<Part> parts;
            public int index;
            public int length;

            public Scene(List<Part> list, Object object, Object object2) {
                this.name = object;
                this.parts = list;
                this.pauseAmt = object2;
                for (Part part : list) {
                    int n = part.getEnd();
                    if (n <= this.length) continue;
                    this.length = n;
                }
            }

            public void reset(int n, int n2) {
                this.index = 0;
                for (int i = 0; i < this.parts.size(); ++i) {
                    this.parts.get(i).reset(n, n2);
                }
            }

            public void step(int n, int n2) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.step(n, n2);
                }
            }

            public void render(int n, int n2, Graphics2D graphics2D) {
                for (int i = 0; i < this.parts.size(); ++i) {
                    Part part = this.parts.get(i);
                    if (this.index < part.getBegin() || this.index > part.getEnd()) continue;
                    part.render(n, n2, graphics2D);
                }
            }

            public void pause() {
                try {
                    Thread.sleep(Long.parseLong((String)this.pauseAmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
            }
        }

        static class SiE
        implements Part {
            private final Surface surf;
            private int beginning;
            private int ending;
            private BufferedImage bimg;
            private double rIncr;
            private double sIncr;
            private double scale;
            private double rotate;
            private int siw;
            private int sih;
            private List<BufferedImage> subs = new ArrayList<BufferedImage>(20);
            private List<Point> pts = new ArrayList<Point>(20);

            public SiE(int n, int n2, int n3, int n4, Surface surface) {
                this.siw = n;
                this.sih = n2;
                this.beginning = n3;
                this.ending = n4;
                this.surf = surface;
                this.rIncr = 360.0 / (double)(this.ending - this.beginning);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
            }

            @Override
            public void reset(int n, int n2) {
                this.scale = 1.0;
                this.rotate = 0.0;
                this.bimg = null;
                this.subs.clear();
                this.pts.clear();
            }

            @Override
            public void step(int n, int n2) {
                if (this.bimg == null) {
                    int n3 = this.surf.bimg.getWidth();
                    int n4 = this.surf.bimg.getHeight();
                    this.bimg = new BufferedImage(n3, n4, 1);
                    Graphics2D graphics2D = this.bimg.createGraphics();
                    graphics2D.drawImage((Image)this.surf.bimg, 0, 0, null);
                    for (int i = 0; i < n && this.scale > 0.0; i += this.siw) {
                        int n5 = i + this.siw < n ? this.siw : n - i;
                        for (int j = 0; j < n2; j += this.sih) {
                            int n6 = j + this.sih < n2 ? this.sih : n2 - j;
                            this.subs.add(this.bimg.getSubimage(i, j, n5, n6));
                            this.pts.add(new Point(i, j));
                        }
                    }
                }
                this.rotate += this.rIncr;
                this.scale -= this.sIncr;
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.setColor(myBlue);
                for (int i = 0; i < this.subs.size() && this.scale > 0.0; ++i) {
                    BufferedImage bufferedImage = this.subs.get(i);
                    Point point = this.pts.get(i);
                    int n3 = bufferedImage.getWidth();
                    int n4 = bufferedImage.getHeight();
                    AffineTransform affineTransform2 = new AffineTransform();
                    affineTransform2.rotate(Math.toRadians(this.rotate), point.x + n3 / 2, point.y + n4 / 2);
                    affineTransform2.translate(point.x, point.y);
                    affineTransform2.scale(this.scale, this.scale);
                    Rectangle rectangle = new Rectangle(0, 0, n3, n4);
                    Shape shape = affineTransform2.createTransformedShape(rectangle);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    double d = (double)(point.x + n3 / 2) - (rectangle2D.getX() + rectangle2D.getWidth() / 2.0);
                    double d2 = (double)(point.y + n4 / 2) - (rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
                    AffineTransform affineTransform3 = new AffineTransform();
                    affineTransform3.translate(d, d2);
                    affineTransform3.concatenate(affineTransform2);
                    graphics2D.setTransform(affineTransform3);
                    graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                    graphics2D.draw(rectangle);
                }
                graphics2D.setTransform(affineTransform);
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static class Temp
        implements Part {
            static final int NOANIM = 1;
            static final int RECT = 2;
            static final int IMG = 4;
            static final int RNA = 3;
            static final int INA = 5;
            private int beginning;
            private int ending;
            private float alpha;
            private float aIncr;
            private int type;
            private Rectangle rect1;
            private Rectangle rect2;
            private int x;
            private int y;
            private int xIncr;
            private int yIncr;
            private Image img;

            public Temp(int n, Image image, int n2, int n3) {
                this.type = n;
                this.img = image;
                this.beginning = n2;
                this.ending = n3;
                this.aIncr = 0.9f / (float)(this.ending - this.beginning);
                if ((n & 1) != 0) {
                    this.alpha = 1.0f;
                }
            }

            @Override
            public void reset(int n, int n2) {
                this.rect1 = new Rectangle(8, 20, n - 20, 30);
                this.rect2 = new Rectangle(20, 8, 30, n2 - 20);
                if ((this.type & 1) == 0) {
                    this.alpha = 0.0f;
                    this.xIncr = n / (this.ending - this.beginning);
                    this.yIncr = n2 / (this.ending - this.beginning);
                    this.x = n + (int)((double)this.xIncr * 1.4);
                    this.y = n2 + (int)((double)this.yIncr * 1.4);
                }
            }

            @Override
            public void step(int n, int n2) {
                if ((this.type & 1) != 0) {
                    return;
                }
                if ((this.type & 2) != 0) {
                    this.rect1.setLocation(this.x -= this.xIncr, 20);
                    this.rect2.setLocation(20, this.y -= this.yIncr);
                }
                if ((this.type & 4) != 0) {
                    this.alpha += this.aIncr;
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                if ((this.type & 2) != 0) {
                    graphics2D.setColor(myBlue);
                    graphics2D.fill(this.rect1);
                    graphics2D.setColor(myRed);
                    graphics2D.fill(this.rect2);
                }
                if ((this.type & 4) != 0) {
                    Composite composite = graphics2D.getComposite();
                    if (this.alpha >= 0.0f && this.alpha <= 1.0f) {
                        graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                    }
                    graphics2D.drawImage(this.img, 30, 30, null);
                    graphics2D.setComposite(composite);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static final class TpE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int OVAL = 4;
            static final int RECT = 8;
            static final int HAF = 16;
            static final int NF = 32;
            static final int OI = 5;
            static final int OD = 6;
            static final int RI = 9;
            static final int RD = 10;
            private Paint p1;
            private Paint p2;
            private int beginning;
            private int ending;
            private float incr;
            private float index;
            private TexturePaint texture;
            private int type;
            private int size;
            private BufferedImage bimg;
            private Rectangle rect;

            public TpE(int n, Paint paint, Paint paint2, int n2, int n3, int n4) {
                this.type = n;
                this.p1 = paint;
                this.p2 = paint2;
                this.beginning = n3;
                this.ending = n4;
                this.setTextureSize(n2);
            }

            public void setTextureSize(int n) {
                this.size = n;
                this.bimg = new BufferedImage(n, n, 1);
                this.rect = new Rectangle(0, 0, n, n);
            }

            @Override
            public void reset(int n, int n2) {
                this.incr = (float)this.size / (float)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0) {
                    this.incr /= 2.0f;
                }
                if ((this.type & 2) != 0) {
                    this.index = this.size;
                    if ((this.type & 0x10) != 0) {
                        this.index /= 2.0f;
                    }
                    this.incr = -this.incr;
                } else {
                    this.index = 0.0f;
                }
                this.index += this.incr;
            }

            @Override
            public void step(int n, int n2) {
                Graphics2D graphics2D = this.bimg.createGraphics();
                graphics2D.setPaint(this.p1);
                graphics2D.fillRect(0, 0, this.size, this.size);
                graphics2D.setPaint(this.p2);
                if ((this.type & 4) != 0) {
                    graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, this.index, this.index));
                } else if ((this.type & 8) != 0) {
                    graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, this.index, this.index));
                }
                this.texture = new TexturePaint(this.bimg, this.rect);
                graphics2D.dispose();
                this.index += this.incr;
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                graphics2D.setPaint(this.texture);
                if ((this.type & 0x20) == 0) {
                    graphics2D.fillRect(0, 0, n, n2);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }

        static final class TxE
        implements Part {
            static final int INC = 1;
            static final int DEC = 2;
            static final int R = 4;
            static final int RI = 5;
            static final int RD = 6;
            static final int SC = 8;
            static final int SCI = 9;
            static final int SCD = 10;
            static final int SCX = 16;
            static final int SCXI = 25;
            static final int SCXD = 26;
            static final int SCY = 32;
            static final int SCYI = 41;
            static final int SCYD = 42;
            static final int AC = 64;
            static final int CLIP = 128;
            static final int NOP = 512;
            private int beginning;
            private int ending;
            private int type;
            private double rIncr;
            private double sIncr;
            private double sx;
            private double sy;
            private double rotate;
            private Shape[] shapes;
            private Shape[] txShapes;
            private int sw;
            private int numRev;
            private Paint paint;

            public TxE(String string, Font font, int n, Paint paint, int n2, int n3) {
                this.type = n;
                this.paint = paint;
                this.beginning = n2;
                this.ending = n3;
                this.setIncrements(2.0);
                char[] cArray = string.toCharArray();
                this.shapes = new Shape[cArray.length];
                this.txShapes = new Shape[cArray.length];
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
                TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
                this.sw = (int)textLayout.getOutline(null).getBounds().getWidth();
                for (int i = 0; i < cArray.length; ++i) {
                    String string2 = String.valueOf(cArray[i]);
                    this.shapes[i] = new TextLayout(string2, font, fontRenderContext).getOutline(null);
                }
            }

            public void setIncrements(double d) {
                this.numRev = (int)d;
                this.rIncr = 360.0 / ((double)(this.ending - this.beginning) / d);
                this.sIncr = 1.0 / (double)(this.ending - this.beginning);
                if ((this.type & 0x10) != 0 || (this.type & 0x20) != 0) {
                    this.sIncr *= 2.0;
                }
                if ((this.type & 2) != 0) {
                    this.rIncr = -this.rIncr;
                    this.sIncr = -this.sIncr;
                }
            }

            @Override
            public void reset(int n, int n2) {
                if (this.type == 25) {
                    this.sx = -1.0;
                    this.sy = 1.0;
                } else if (this.type == 41) {
                    this.sx = 1.0;
                    this.sy = -1.0;
                } else {
                    this.sy = (this.type & 2) != 0 ? 1.0 : 0.0;
                    this.sx = this.sy;
                }
                this.rotate = 0.0;
            }

            @Override
            public void step(int n, int n2) {
                float f = n / 2 - this.sw / 2;
                for (int i = 0; i < this.shapes.length; ++i) {
                    AffineTransform affineTransform = new AffineTransform();
                    Rectangle rectangle = this.shapes[i].getBounds();
                    affineTransform.translate(f, (double)(n2 / 2) + ((RectangularShape)rectangle).getHeight() / 2.0);
                    f += (float)((RectangularShape)rectangle).getWidth() + 1.0f;
                    Shape shape = affineTransform.createTransformedShape(this.shapes[i]);
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    if ((this.type & 4) != 0) {
                        affineTransform.rotate(Math.toRadians(this.rotate));
                    }
                    if ((this.type & 8) != 0) {
                        affineTransform.scale(this.sx, this.sy);
                    }
                    shape = affineTransform.createTransformedShape(this.shapes[i]);
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    double d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - (rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
                    double d2 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
                    AffineTransform affineTransform2 = new AffineTransform();
                    affineTransform2.translate(d, d2);
                    affineTransform2.concatenate(affineTransform);
                    this.txShapes[i] = affineTransform2.createTransformedShape(this.shapes[i]);
                }
                if (Math.abs(this.rotate) <= (double)(this.numRev * 360)) {
                    this.rotate += this.rIncr;
                    if ((this.type & 0x10) != 0) {
                        this.sx += this.sIncr;
                    } else if ((this.type & 0x20) != 0) {
                        this.sy += this.sIncr;
                    } else {
                        this.sx += this.sIncr;
                        this.sy += this.sIncr;
                    }
                }
            }

            @Override
            public void render(int n, int n2, Graphics2D graphics2D) {
                Composite composite = null;
                if ((this.type & 0x40) != 0 && this.sx > 0.0 && this.sx < 1.0) {
                    composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.sx));
                }
                GeneralPath generalPath = null;
                if ((this.type & 0x80) != 0) {
                    generalPath = new GeneralPath();
                }
                if (this.paint != null) {
                    graphics2D.setPaint(this.paint);
                }
                for (int i = 0; i < this.txShapes.length; ++i) {
                    if ((this.type & 0x80) != 0) {
                        generalPath.append(this.txShapes[i], false);
                        continue;
                    }
                    graphics2D.fill(this.txShapes[i]);
                }
                if ((this.type & 0x80) != 0) {
                    graphics2D.clip(generalPath);
                }
                if (composite != null) {
                    graphics2D.setComposite(composite);
                }
            }

            @Override
            public int getBegin() {
                return this.beginning;
            }

            @Override
            public int getEnd() {
                return this.ending;
            }
        }
    }
}

