/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import java.net.URI;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import org.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import org.jcp.xml.dsig.internal.dom.Policy;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public final class DOMURIDereferencer
implements URIDereferencer {
    static final URIDereferencer INSTANCE = new DOMURIDereferencer();

    private DOMURIDereferencer() {
        Init.init();
    }

    @Override
    public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
        boolean secVal;
        String baseURI;
        DOMCryptoContext dcc;
        String uri;
        Attr uriAttr;
        block21: {
            if (uriRef == null) {
                throw new NullPointerException("uriRef cannot be null");
            }
            if (context == null) {
                throw new NullPointerException("context cannot be null");
            }
            DOMURIReference domRef = (DOMURIReference)uriRef;
            uriAttr = (Attr)domRef.getHere();
            uri = uriRef.getURI();
            dcc = (DOMCryptoContext)context;
            baseURI = context.getBaseURI();
            secVal = Utils.secureValidation(context);
            if (secVal) {
                try {
                    if (Policy.restrictReferenceUriScheme(uri)) {
                        throw new URIReferenceException("URI " + uri + " is forbidden when secure validation is enabled");
                    }
                    if (uri == null || uri.isEmpty() || uri.charAt(0) == '#' || URI.create(uri).getScheme() != null) break block21;
                    try {
                        if (Policy.restrictReferenceUriScheme(baseURI)) {
                            throw new URIReferenceException("Base URI " + baseURI + " is forbidden when secure validation is enabled");
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new URIReferenceException("Invalid base URI " + baseURI);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new URIReferenceException("Invalid URI " + uri);
                }
            }
        }
        if (uri != null && uri.length() != 0 && uri.charAt(0) == '#') {
            Element referencedElem;
            String id = uri.substring(1);
            if (id.startsWith("xpointer(id(")) {
                int i1 = id.indexOf(39);
                int i2 = id.indexOf(39, i1 + 1);
                if (i1 >= 0 && i2 >= 0) {
                    id = id.substring(i1 + 1, i2);
                }
            }
            if ((referencedElem = uriAttr.getOwnerDocument().getElementById(id)) == null) {
                referencedElem = dcc.getElementById(id);
            }
            if (referencedElem != null) {
                Element start;
                if (secVal && Policy.restrictDuplicateIds() && !XMLUtils.protectAgainstWrappingAttack(start = referencedElem.getOwnerDocument().getDocumentElement(), referencedElem, id)) {
                    String error = "Multiple Elements with the same ID " + id + " detected when secure validation is enabled";
                    throw new URIReferenceException(error);
                }
                XMLSignatureInput result = new XMLSignatureInput(referencedElem);
                result.setSecureValidation(secVal);
                if (!uri.substring(1).startsWith("xpointer(id(")) {
                    result.setExcludeComments(true);
                }
                result.setMIMEType("text/xml");
                if (baseURI != null && baseURI.length() > 0) {
                    result.setSourceURI(baseURI.concat(uriAttr.getNodeValue()));
                } else {
                    result.setSourceURI(uriAttr.getNodeValue());
                }
                return new ApacheNodeSetData(result);
            }
        }
        try {
            ResourceResolverContext resContext = new ResourceResolverContext(uriAttr, baseURI, secVal);
            XMLSignatureInput in = ResourceResolver.resolve(resContext);
            if (in.isOctetStream()) {
                return new ApacheOctetStreamData(in);
            }
            return new ApacheNodeSetData(in);
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }
}

