/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDJavaMethod;
import com.ibm.dtfj.phd.PHDJavaRuntime;

public class PHDJavaLocation
implements JavaLocation {
    private ImagePointer address;
    private CorruptData address_cd;
    private int compilationLevel;
    private CorruptData compilationLevel_cd;
    private String filename;
    private CorruptData filename_cd;
    private int lineNumber;
    private CorruptData lineNumber_cd;
    private JavaMethod method;
    private CorruptData method_cd;

    PHDJavaLocation(ImageAddressSpace space, PHDJavaRuntime runtime, JavaLocation shadow) {
        try {
            this.address = space.getPointer(shadow.getAddress().getAddress());
        }
        catch (CorruptDataException e) {
            this.address_cd = new PHDCorruptData(space, e);
        }
        try {
            this.compilationLevel = shadow.getCompilationLevel();
        }
        catch (CorruptDataException e) {
            this.compilationLevel_cd = new PHDCorruptData(space, e);
        }
        try {
            this.filename = shadow.getFilename();
        }
        catch (CorruptDataException e) {
            this.filename_cd = new PHDCorruptData(space, e);
        }
        catch (DataUnavailable e) {
            // empty catch block
        }
        try {
            this.lineNumber = shadow.getLineNumber();
        }
        catch (CorruptDataException e) {
            this.lineNumber_cd = new PHDCorruptData(space, e);
        }
        catch (DataUnavailable e) {
            this.lineNumber = -1;
        }
        try {
            this.method = new PHDJavaMethod(space, runtime, shadow.getMethod());
        }
        catch (CorruptDataException e) {
            this.method_cd = new PHDCorruptData(space, e);
        }
    }

    @Override
    public ImagePointer getAddress() throws CorruptDataException {
        this.checkCD(this.address_cd);
        return this.address;
    }

    @Override
    public int getCompilationLevel() throws CorruptDataException {
        this.checkCD(this.compilationLevel_cd);
        return this.compilationLevel;
    }

    @Override
    public String getFilename() throws DataUnavailable, CorruptDataException {
        this.checkCD(this.filename_cd);
        if (this.filename == null) {
            throw new DataUnavailable();
        }
        return this.filename;
    }

    @Override
    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        this.checkCD(this.lineNumber_cd);
        if (this.lineNumber == -1) {
            throw new DataUnavailable();
        }
        return this.lineNumber;
    }

    @Override
    public JavaMethod getMethod() throws CorruptDataException {
        this.checkCD(this.method_cd);
        return this.method;
    }

    private void checkCD(CorruptData cd) throws CorruptDataException {
        if (cd != null) {
            throw new CorruptDataException(cd);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PHDJavaLocation l = (PHDJavaLocation)o;
        return this.equals(this.method, l.method) && this.equals(this.lineNumber, l.lineNumber);
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.method) ^ this.hashCode(this.lineNumber);
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            JavaMethod m = this.getMethod();
            sb.append(m.getDeclaringClass().getName().replace('/', '.'));
            sb.append('.');
            sb.append(m.getName());
        }
        catch (CorruptDataException e) {
            sb.append("corrupt");
        }
        catch (DataUnavailable e) {
            sb.append("data unavailable");
        }
        sb.append('(');
        boolean d = false;
        try {
            sb.append(this.getFilename());
            d = true;
            int line = this.getLineNumber();
            sb.append(':');
            sb.append(line);
        }
        catch (CorruptDataException e) {
            try {
                if (this.getCompilationLevel() > 0) {
                    if (d) {
                        sb.append('(');
                    }
                    sb.append("Compiled Code");
                    if (d) {
                        sb.append(')');
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        catch (DataUnavailable e) {
            try {
                if (this.getCompilationLevel() > 0) {
                    if (d) {
                        sb.append('(');
                    }
                    sb.append("Compiled Code");
                    if (d) {
                        sb.append(')');
                    }
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        finally {
            sb.append(')');
        }
        return sb.toString();
    }
}

