/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.javacore.parser.framework.Section;
import com.ibm.dtfj.javacore.parser.framework.parser.ISectionParser;
import com.ibm.dtfj.javacore.parser.framework.tag.ITagParser;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import com.ibm.dtfj.javacore.parser.j9.SovereignParserPartManager;
import com.ibm.dtfj.javacore.parser.j9.SovereignSectionParserPart;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.ClassLoaderSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.classloader.ClassLoaderTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.environment.EnvironmentSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.environment.EnvironmentTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.memory.MemorySectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.memory.MemoryTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorSovSectionParserPart;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.NativeMemorySectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.nativememory.NativeMemoryTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.platform.PlatformSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.platform.PlatformTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.stack.StackSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.stack.StackTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadSovSectionParserPart;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadTagParser;
import com.ibm.dtfj.javacore.parser.j9.section.title.TitleSectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.title.TitleTagParser;
import java.util.ArrayList;
import java.util.List;

public class DTFJComponentLoader {
    public List loadSections() {
        ArrayList sections = this.getSections();
        if (sections == null) {
            throw new NullPointerException("No java core sections loaded.");
        }
        J9TagManager.getCurrent().loadTagParsers(this.getTagParsers(sections));
        SovereignParserPartManager.getCurrent().loadSovParts(this.getSovParts(sections));
        return this.getSectionParsers(sections);
    }

    private ArrayList getTagParsers(ArrayList sections) {
        ArrayList<ITagParser> tagParsers = null;
        if (sections != null) {
            tagParsers = new ArrayList<ITagParser>();
            for (Section section : sections) {
                ITagParser tagParser;
                if (section == null || (tagParser = section.getTagParser()) == null || tagParsers.contains(tagParser)) continue;
                tagParsers.add(tagParser);
            }
        }
        return tagParsers;
    }

    private ArrayList getSovParts(ArrayList sections) {
        ArrayList<SovereignSectionParserPart> sovParts = null;
        if (sections != null) {
            sovParts = new ArrayList<SovereignSectionParserPart>();
            for (Section section : sections) {
                SovereignSectionParserPart part;
                if (section == null || (part = section.getSovPart()) == null || sovParts.contains(part)) continue;
                sovParts.add(part);
            }
        }
        return sovParts;
    }

    private ArrayList getSectionParsers(ArrayList sections) {
        ArrayList<ISectionParser> sectionParsers = null;
        if (sections != null) {
            sectionParsers = new ArrayList<ISectionParser>();
            for (Section section : sections) {
                ISectionParser part;
                if (section == null || (part = section.getSectionParser()) == null || sectionParsers.contains(part)) continue;
                sectionParsers.add(part);
            }
        }
        return sectionParsers;
    }

    private ArrayList getSections() {
        ArrayList<Section> loadedSections = new ArrayList<Section>();
        Section section = new Section(null, new CommonTagParser(), null);
        loadedSections.add(section);
        section = new Section(new TitleSectionParser(), new TitleTagParser(), null);
        loadedSections.add(section);
        section = new Section(new PlatformSectionParser(), new PlatformTagParser(), null);
        loadedSections.add(section);
        section = new Section(new EnvironmentSectionParser(), new EnvironmentTagParser(), null);
        loadedSections.add(section);
        section = new Section(new NativeMemorySectionParser(), new NativeMemoryTagParser(), null);
        loadedSections.add(section);
        section = new Section(new MemorySectionParser(), new MemoryTagParser(), null);
        loadedSections.add(section);
        section = new Section(new MonitorSectionParser(), new MonitorTagParser(), new MonitorSovSectionParserPart());
        loadedSections.add(section);
        section = new Section(new ThreadSectionParser(), new ThreadTagParser(), new ThreadSovSectionParserPart());
        loadedSections.add(section);
        section = new Section(new StackSectionParser(), new StackTagParser(), null);
        loadedSections.add(section);
        section = new Section(new ClassLoaderSectionParser(), new ClassLoaderTagParser(), null);
        loadedSections.add(section);
        return loadedSections;
    }
}

