/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix32Dump
extends NewAixDump {
    private static final int CONTEXT_OFFSET_IN_THREAD = 200;
    private static final int IAR_OFFSET_IN_CONTEXT = 24;
    private static final int GPR_OFFSET_IN_CONTEXT = 208;
    private static final int GPR_COUNT = 32;

    protected Aix32Dump(DumpReader reader) throws IOException {
        super(reader);
        this.readCore();
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return 0;
    }

    @Override
    protected long userInfoOffset() {
        return 1008L;
    }

    @Override
    protected int pointerSize() {
        return 32;
    }

    @Override
    protected Map readRegisters(long threadOffset) throws IOException {
        TreeMap<String, Integer> registers = new TreeMap<String, Integer>();
        this.coreSeek(threadOffset + 200L + 24L);
        registers.put("iar", this.coreReadInt());
        registers.put("msr", this.coreReadInt());
        registers.put("cr", this.coreReadInt());
        registers.put("lr", this.coreReadInt());
        registers.put("ctr", this.coreReadInt());
        registers.put("xer", this.coreReadInt());
        registers.put("mq", this.coreReadInt());
        registers.put("tid", this.coreReadInt());
        registers.put("fpscr", this.coreReadInt());
        this.coreSeek(threadOffset + 200L + 208L);
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, this.coreReadInt());
        }
        return registers;
    }

    @Override
    protected long threadSize(long threadOffset) {
        return 792L;
    }

    @Override
    protected long getStackPointerFrom(Map registers) {
        return (long)((Integer)registers.get("gpr1")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getInstructionPointerFrom(Map registers) {
        return (long)((Integer)registers.get("iar")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getLinkRegisterFrom(Map registers) {
        return (long)((Integer)registers.get("lr")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected int sizeofTopOfStack() {
        return 144;
    }
}

