/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9VMInitArgsPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.JavaVMOptionPointer;
import com.ibm.j9ddr.vm29_00.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29_00.view.dtfj.java.DTFJJavaVMOption;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJJavaVMInitArgs
implements JavaVMInitArgs {
    private boolean isCachePopulated = false;
    private LinkedList<Object> options = new LinkedList();
    private Iterator corruptCache = null;
    private int version = 0;
    private boolean isCorrupt = false;
    private CorruptData cdata = null;
    private Logger log = DTFJContext.getLogger();
    private boolean ignoreFlag = false;

    public boolean getIgnoreUnrecognized() throws DataUnavailable, CorruptDataException {
        this.loadData();
        if (this.isCorrupt) {
            throw new CorruptDataException(this.cdata);
        }
        return this.ignoreFlag;
    }

    public Iterator getOptions() throws DataUnavailable {
        this.loadData();
        if (this.isCorrupt) {
            throw new DataUnavailable("The VM options are not available : " + this.cdata.toString());
        }
        if (this.corruptCache == null) {
            return this.options.iterator();
        }
        return this.corruptCache;
    }

    public int getVersion() throws DataUnavailable, CorruptDataException {
        this.loadData();
        if (this.isCorrupt) {
            throw new CorruptDataException(this.cdata);
        }
        return this.version;
    }

    private void loadData() {
        if (this.isCachePopulated || this.isCorrupt) {
            return;
        }
        J9VMInitArgsPointer args = null;
        try {
            args = DTFJContext.getVm().vmArgsArray();
            this.ignoreFlag = !args.actualVMArgs().ignoreUnrecognized().eq(0L);
            this.version = args.actualVMArgs().version().intValue();
        }
        catch (Throwable t) {
            this.isCorrupt = true;
            this.cdata = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
        }
        if (this.isCorrupt) {
            this.isCachePopulated = true;
            return;
        }
        try {
            int optionCount = args.nOptions().intValue();
            JavaVMOptionPointer option = args.actualVMArgs().options();
            for (int i = 0; i < optionCount; ++i) {
                try {
                    DTFJJavaVMOption vmoption = new DTFJJavaVMOption(option);
                    this.options.add(vmoption);
                    if (this.log.isLoggable(Level.FINE)) {
                        try {
                            this.log.fine(String.format("Found VM option %s", vmoption.getOptionString()));
                        }
                        catch (Exception e) {
                            this.log.warning(e.getMessage());
                        }
                    }
                    option = option.add(1L);
                    continue;
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    this.options.add(cd);
                }
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.corruptCache = J9DDRDTFJUtils.corruptIterator(cd);
        }
        this.isCachePopulated = true;
    }
}

