/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.util.PatternString;
import com.ibm.j9ddr.vm29_00.j9.DataType;
import com.ibm.j9ddr.vm29_00.j9.ROMHelp;
import com.ibm.j9ddr.vm29_00.j9.walkers.FilteredROMClassesIterator;
import com.ibm.j9ddr.vm29_00.j9.walkers.J9ROMClassAndMethod;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9UTF8Helper;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteredROMMethodsIterator
implements Iterator<J9ROMClassAndMethod>,
Iterable<J9ROMClassAndMethod> {
    J9ROMClassAndMethod nextMethod = null;
    J9ROMClassPointer currentRomClass = null;
    final FilteredROMClassesIterator classIterator;
    private PatternString classPattern = null;
    private PatternString methodPattern;
    private PatternString signaturePattern;
    private J9ROMMethodPointer currentRomMethod;
    private int remainingMethods = 0;

    public FilteredROMMethodsIterator(PrintStream out, Context context, String methodPattern) throws CorruptDataException {
        this.setPatterns(methodPattern);
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (null == vm) {
            throw new CorruptDataException("Unable to find the VM in core dump!");
        }
        this.classIterator = new FilteredROMClassesIterator(out, vm.classMemorySegments(), this.classPattern);
        this.resetMethodIterationState();
    }

    private void resetMethodIterationState() {
        this.currentRomClass = null;
        this.currentRomMethod = null;
        this.remainingMethods = 0;
    }

    private void setPatterns(String searchExpression) {
        String classNameString = "*";
        String methodNameString = "*";
        String signatureString = "*";
        int parenLocation = searchExpression.indexOf(40);
        int periodLocation = searchExpression.indexOf(46);
        if (periodLocation != -1) {
            int endOfClassName = parenLocation >= 0 ? parenLocation : searchExpression.length();
            classNameString = searchExpression.substring(0, periodLocation);
            methodNameString = searchExpression.substring(periodLocation + 1, endOfClassName);
        } else {
            methodNameString = searchExpression;
        }
        if (parenLocation != -1) {
            signatureString = searchExpression.substring(parenLocation);
        }
        this.classPattern = new PatternString(classNameString);
        this.methodPattern = new PatternString(methodNameString);
        this.signaturePattern = new PatternString(signatureString);
    }

    @Override
    public boolean hasNext() {
        if (null == this.nextMethod) {
            this.nextMethod = this.next();
        }
        return null != this.nextMethod;
    }

    @Override
    public J9ROMClassAndMethod next() {
        J9ROMClassAndMethod result = this.nextMethod;
        this.nextMethod = null;
        if (null == result) {
            do {
                try {
                    if (null != this.currentRomMethod && this.remainingMethods > 0) {
                        String methSig;
                        J9ROMMethodPointer romMethod = this.currentRomMethod;
                        J9ROMNameAndSignaturePointer nameAndSignature = romMethod.nameAndSignature();
                        J9UTF8Pointer methNameUTF = nameAndSignature.name();
                        String methName = J9UTF8Helper.stringValue(methNameUTF);
                        if (this.methodPattern.isMatch(methName) && this.signaturePattern.isMatch(methSig = J9UTF8Helper.stringValue(nameAndSignature.signature()))) {
                            result = new J9ROMClassAndMethod(romMethod, this.currentRomClass);
                        }
                        this.currentRomMethod = ROMHelp.nextROMMethod(this.currentRomMethod);
                        --this.remainingMethods;
                        continue;
                    }
                    if (this.goToNextClass()) continue;
                    break;
                }
                catch (CorruptDataException e) {
                    throw new NoSuchElementException();
                }
            } while (null == result);
        }
        return result;
    }

    private boolean goToNextClass() throws CorruptDataException {
        this.resetMethodIterationState();
        boolean classAvailable = false;
        while (null == this.currentRomMethod && this.classIterator.hasNext()) {
            J9ROMClassPointer tempRomClass = this.classIterator.next();
            String className = J9UTF8Helper.stringValue(tempRomClass.className());
            if (!this.classPattern.isMatch(className) || tempRomClass.romMethodCount().longValue() <= 0L) continue;
            this.currentRomClass = tempRomClass;
            this.currentRomMethod = this.currentRomClass.romMethods();
            this.remainingMethods = this.currentRomClass.romMethodCount().intValue();
            classAvailable = true;
        }
        return classAvailable;
    }

    @Override
    public Iterator<J9ROMClassAndMethod> iterator() {
        return this;
    }

    @Override
    public void remove() {
    }
}

