/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.events.EventManager;
import com.ibm.j9ddr.vm29_00.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm29_00.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29_00.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.util.NoSuchElementException;

public class GCPackedArrayIterator_V1
extends GCObjectIterator {
    private VoidPointer _scanPtr;
    private VoidPointer _endPtr;
    private J9ClassPointer _componentClazz;
    private GCArrayObjectModel packedArrayObjectModel;
    private UDATA _packedDataSize;
    private GCObjectIterator _packedObjectIterator;
    private boolean _targetObjectReturned;

    public GCPackedArrayIterator_V1(J9ObjectPointer objectPtr, boolean includeClassSlot, boolean includeTargetObject) throws CorruptDataException {
        super(objectPtr, includeClassSlot);
        this._targetObjectReturned = !includeTargetObject;
        this.packedArrayObjectModel = GCArrayObjectModel.from(true);
        this.initialize();
    }

    private void initialize() throws CorruptDataException {
        J9IndexableObjectPointer arrayPtr = J9IndexableObjectPointer.cast(this.object);
        if (this.packedArrayObjectModel.isPackedObjectHeader(arrayPtr)) {
            this._endPtr = VoidPointer.NULL;
            this._scanPtr = VoidPointer.NULL;
        } else {
            this._componentClazz = J9IndexableObjectHelper.clazz(arrayPtr).componentType();
            this._packedDataSize = this.packedArrayObjectModel.getPackedDataSize(this._componentClazz);
            VoidPointer dataPointer = this.packedArrayObjectModel.getDataPointerForContiguous(arrayPtr);
            this._endPtr = VoidPointer.cast(UDATA.cast(dataPointer).sub(this._packedDataSize));
            this._scanPtr = VoidPointer.cast(UDATA.cast(this._endPtr).add(this.packedArrayObjectModel.getSizeInElements(arrayPtr).mult(this._packedDataSize)));
            this._packedObjectIterator = GCObjectIterator.fromJ9Class(this._componentClazz, this._scanPtr);
        }
    }

    @Override
    public boolean hasNext() {
        if (!this._targetObjectReturned) {
            return true;
        }
        while (this._scanPtr.gt(this._endPtr)) {
            if (this._packedObjectIterator.hasNext()) {
                return true;
            }
            try {
                this._scanPtr = VoidPointer.cast(UDATA.cast(this._scanPtr).sub(this._packedDataSize));
                this._packedObjectIterator = GCObjectIterator.fromJ9Class(this._componentClazz, this._scanPtr);
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking for items", e, false);
                return false;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                J9IndexableObjectPointer arrayPtr = J9IndexableObjectPointer.cast(this.object);
                if (!this._targetObjectReturned) {
                    this._targetObjectReturned = true;
                    return this.packedArrayObjectModel.getTargetObject(arrayPtr);
                }
                return this._packedObjectIterator.next();
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        try {
            if (this.hasNext()) {
                J9IndexableObjectPointer arrayPtr = J9IndexableObjectPointer.cast(this.object);
                if (!this._targetObjectReturned) {
                    this._targetObjectReturned = true;
                    return VoidPointer.cast(this.packedArrayObjectModel.getTargetObjectEA(arrayPtr));
                }
                return this._packedObjectIterator.nextAddress();
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }
}

