/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.J9JavaStackIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9VMThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaMethod;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaStackFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaThread
implements JavaThread {
    private static final String PRIORITY_FIELD = "priority";
    private static final String NAME_FIELD = "name";
    private static final String JAVA_LANG_THREAD_CLASS = "java/lang/Thread";
    private final J9VMThreadPointer thread;
    private String name = null;
    private int priority = Integer.MIN_VALUE;
    private ImageThread imageThread = null;
    private List<Object> frames = null;
    private List<Object> sections = null;

    public DTFJJavaThread(J9VMThreadPointer thread) {
        this.thread = thread;
    }

    public ImageThread getImageThread() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        if (this.imageThread == null) {
            J9DDRImageProcess imageProcess = DTFJContext.getImageProcess();
            try {
                long tid = this.thread.osThread().tid().longValue();
                this.imageThread = imageProcess.getThread(tid);
                if (null == this.imageThread) {
                    this.imageThread = new J9DDRStubImageThread(DTFJContext.getProcess(), tid);
                }
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return this.imageThread;
    }

    public ImagePointer getJNIEnv() throws com.ibm.dtfj.image.CorruptDataException {
        return DTFJContext.getImagePointer(this.thread.getAddress());
    }

    public String getName() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.name == null) {
                JavaField nameField = this.getField(NAME_FIELD);
                this.name = nameField != null ? nameField.getString(this.getObject()) : "vmthread @" + this.thread.getAddress();
            }
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return this.name;
    }

    public JavaObject getObject() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.thread.threadObject().isNull()) {
                return null;
            }
            DTFJJavaObject threadObj = new DTFJJavaObject(this.thread.threadObject());
            threadObj.getJavaClass().getName();
            return threadObj;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public int getPriority() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            if (this.priority == Integer.MIN_VALUE) {
                JavaField priorityField = this.getField(PRIORITY_FIELD);
                this.priority = priorityField != null ? priorityField.getInt(this.getObject()) : -1;
            }
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return this.priority;
    }

    private JavaField getField(String fieldName) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        JavaClass threadClass;
        JavaObject threadObj = this.getObject();
        if (threadObj == null) {
            return null;
        }
        for (threadClass = threadObj.getJavaClass(); !JAVA_LANG_THREAD_CLASS.equals(threadClass.getName()) && threadClass != null; threadClass = threadClass.getSuperclass()) {
        }
        if (threadClass == null) {
            return null;
        }
        Iterator fieldIterator = threadClass.getDeclaredFields();
        while (fieldIterator.hasNext()) {
            JavaField field;
            Object nextField = fieldIterator.next();
            if (!(nextField instanceof JavaField) || !fieldName.equals((field = (JavaField)nextField).getName())) continue;
            return field;
        }
        return null;
    }

    public Iterator getStackFrames() {
        if (this.frames == null) {
            this.walkStack();
        }
        return this.frames.iterator();
    }

    private void walkStack() {
        this.frames = new LinkedList<Object>();
        WalkState walkState = new WalkState();
        walkState.walkThread = this.thread;
        walkState.flags = J9Consts.J9_STACKWALK_VISIBLE_ONLY | J9Consts.J9_STACKWALK_INCLUDE_NATIVES | J9Consts.J9_STACKWALK_ITERATE_FRAMES | J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET | J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
        walkState.callBacks = new StackWalkerCallbacks();
        EventManager.register((IEventListener)((Object)walkState.callBacks));
        StackWalkResult result = StackWalkResult.STACK_CORRUPT;
        try {
            result = StackWalker.walkStackFrames(walkState);
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            result = StackWalkResult.STACK_CORRUPT;
        }
        EventManager.unregister((IEventListener)((Object)walkState.callBacks));
        if (result != StackWalkResult.NONE) {
            this.frames.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Bad return from stack walker walking thread 0x" + Long.toHexString(walkState.threadAddress) + ". Some stack frames may be missing. Final state = " + (Object)((Object)result)));
        }
    }

    public Iterator getStackSections() {
        if (this.sections == null) {
            this.walkSections();
        }
        return this.sections.iterator();
    }

    private void walkSections() {
        J9JavaStackIterator stacks;
        this.sections = new ArrayList<Object>();
        try {
            stacks = J9JavaStackIterator.fromJ9JavaStack(this.thread.stackObject());
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.sections.add(cd);
            return;
        }
        int count = 0;
        while (stacks.hasNext() && count < 1) {
            J9JavaStackPointer stack = stacks.next();
            try {
                long size = stack.size().longValue();
                long baseAddress = stack.end().longValue() - size;
                J9DDRImageSection newSection = DTFJContext.getImageSection(baseAddress, this.getSectionName());
                newSection.setSize(size);
                this.sections.add(newSection);
                ++count;
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.sections.add(cd);
            }
        }
    }

    private String getSectionName() {
        try {
            return "JavaStackSection for JavaThread: " + this.getName();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return "JavaStackSection for JavaThread: Invalid Thread Name";
        }
    }

    public boolean equals(Object object) {
        boolean isEqual;
        ImageThread imageThread = null;
        try {
            imageThread = this.getImageThread();
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            // empty catch block
        }
        boolean bl = null == imageThread ? this == object : (isEqual = false);
        if (null != imageThread && object instanceof DTFJJavaThread) {
            DTFJJavaThread local = (DTFJJavaThread)object;
            try {
                isEqual = imageThread.getID().equals(local.getImageThread().getID());
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            }
            catch (DataUnavailable dataUnavailable) {
                // empty catch block
            }
        }
        return isEqual;
    }

    public int hashCode() {
        try {
            return this.getImageThread().getID().hashCode();
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            return super.hashCode();
        }
    }

    public int getState() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9VMThreadHelper.getDTFJState(this.thread);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JavaThread @ 0x");
        builder.append(Long.toHexString(this.thread.getAddress()));
        return builder.toString();
    }

    public JavaObject getBlockingObject() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            if (this.thread.blockingEnterObject().isNull()) {
                return null;
            }
            return new DTFJJavaObject(this.thread.blockingEnterObject());
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private class StackWalkerCallbacks
    extends BaseStackWalkerCallbacks
    implements IEventListener {
        private Object frame = null;

        private StackWalkerCallbacks() {
        }

        @Override
        public FrameCallbackResult frameWalkFunction(WalkState walkState) {
            if (walkState.method.isNull()) {
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (this.frame == null || this.frame instanceof J9DDRCorruptData) {
                this.setupFrame(walkState);
            }
            DTFJJavaThread.this.frames.add(this.frame);
            this.frame = null;
            return FrameCallbackResult.KEEP_ITERATING;
        }

        @Override
        public void objectSlotWalkFunction(WalkState walkState, PointerPointer objectSlot, VoidPointer stackAddress) {
            block5: {
                if (walkState.method.isNull()) {
                    return;
                }
                try {
                    J9ObjectPointer object = J9ObjectPointer.cast(objectSlot.at(0L));
                    this.addObjectReference(walkState, object);
                }
                catch (CorruptDataException e) {
                    if (this.frame instanceof DTFJJavaStackFrame) {
                        ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!(this.frame instanceof DTFJJavaStackFrame)) break block5;
                    ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), new CorruptDataException(e)));
                }
            }
        }

        @Override
        public void fieldSlotWalkFunction(WalkState walkState, ObjectReferencePointer objectSlot, VoidPointer stackLocation) {
            block5: {
                if (walkState.method.isNull()) {
                    return;
                }
                try {
                    J9ObjectPointer object = objectSlot.at(0L);
                    this.addObjectReference(walkState, object);
                }
                catch (CorruptDataException e) {
                    if (this.frame instanceof DTFJJavaStackFrame) {
                        ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!(this.frame instanceof DTFJJavaStackFrame)) break block5;
                    ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), new CorruptDataException(e)));
                }
            }
        }

        private void addObjectReference(WalkState walkState, J9ObjectPointer object) {
            if (this.frame == null) {
                this.setupFrame(walkState);
            }
            if (this.frame instanceof DTFJJavaStackFrame && object.notNull()) {
                DTFJJavaObject dtfjObject = new DTFJJavaObject(object);
                DTFJJavaReference reference = new DTFJJavaReference(this.frame, dtfjObject, "StackFrame Root", 0, 4, 1);
                ((DTFJJavaStackFrame)this.frame).addReference(reference);
            }
        }

        private void setupFrame(WalkState walkState) {
            try {
                J9DDRImagePointer basePointer = DTFJContext.getImagePointer(walkState.arg0EA.longValue());
                J9DDRImagePointer pc = DTFJContext.getImagePointer(walkState.pc.getAddress());
                J9DDRCorruptData corrupt = null;
                if (this.frame instanceof J9DDRCorruptData) {
                    corrupt = (J9DDRCorruptData)this.frame;
                }
                DTFJJavaClass clazz = new DTFJJavaClass(ConstantPoolHelpers.J9_CLASS_FROM_METHOD(walkState.method));
                boolean jitted = walkState.jitInfo.notNull();
                this.frame = new DTFJJavaStackFrame(DTFJJavaThread.this, new DTFJJavaMethod(clazz, walkState.method), walkState.method, pc, basePointer, walkState.bytecodePCOffset, jitted);
                if (corrupt != null && this.frame instanceof DTFJJavaStackFrame) {
                    ((DTFJJavaStackFrame)this.frame).addReference(corrupt);
                }
            }
            catch (CorruptDataException e) {
                this.frame = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
            }
        }

        @Override
        public void corruptData(String message2, CorruptDataException e, boolean fatal) {
            if (this.frame == null) {
                this.frame = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
            } else if (this.frame instanceof DTFJJavaStackFrame) {
                ((DTFJJavaStackFrame)this.frame).addReference(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e));
            }
        }
    }
}

