/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class ITableSizeCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public ITableSizeCommand() {
        this.addCommand("itablesize", "", "Dump experimental iTable sizing");
    }

    public long iTableChainSize(J9ITablePointer startTable, J9ITablePointer superTable) throws CorruptDataException {
        long size = 0L;
        J9ITablePointer iTable = startTable;
        while (!iTable.eq(superTable)) {
            size += J9ITable.SIZEOF;
            J9ClassPointer interfaceClass = iTable.interfaceClass();
            J9ROMClassPointer romClass = interfaceClass.romClass();
            size += (long)(UDATA.SIZEOF * romClass.romMethodCount().intValue());
            iTable = iTable.next();
        }
        return size;
    }

    public long iTableExtendedSize(J9ITablePointer startTable, J9ITablePointer superTable) throws CorruptDataException {
        long size = 0L;
        J9ITablePointer iTable = startTable;
        while (!iTable.eq(superTable)) {
            size += J9ITable.SIZEOF;
            J9ClassPointer interfaceClass = iTable.interfaceClass();
            J9ROMClassPointer romClass = interfaceClass.romClass();
            J9ITablePointer allInterfaces = J9ITablePointer.cast(interfaceClass.iTable());
            do {
                size += (long)(UDATA.SIZEOF * allInterfaces.interfaceClass().romClass().romMethodCount().intValue());
            } while (!(allInterfaces = allInterfaces.next()).eq(J9ITablePointer.NULL));
            iTable = iTable.next();
        }
        return size;
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        long currentSize = 0L;
        long duplicatedSize = 0L;
        long extendedSize = 0L;
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer clazz = (J9ClassPointer)classSegmentIterator.next();
                int classDepth = clazz.classDepthAndFlags().bitAnd(J9JavaAccessFlags.J9AccClassDepthMask).intValue();
                J9ITablePointer superITable = J9ITablePointer.NULL;
                J9ITablePointer startITable = J9ITablePointer.cast(clazz.iTable());
                if (0 != classDepth) {
                    PointerPointer superclasses = clazz.superclasses();
                    J9ClassPointer superclazz = J9ClassPointer.cast(superclasses.at(classDepth - 1));
                    superITable = J9ITablePointer.cast(superclazz.iTable());
                }
                currentSize += this.iTableChainSize(startITable, superITable);
                duplicatedSize += this.iTableChainSize(superITable, J9ITablePointer.NULL);
                extendedSize += this.iTableExtendedSize(startITable, superITable);
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
        long totalSize = duplicatedSize + currentSize;
        double percent = (double)totalSize / (double)currentSize;
        out.append("iTable duplication" + nl);
        out.append("------------------" + nl);
        out.append("current    iTable size : " + currentSize + nl);
        out.append("additional iTable size : " + duplicatedSize + nl);
        out.append("total      iTable size : " + totalSize + nl);
        out.append("growth factor          : " + percent + nl);
        out.append(nl);
        percent = (double)extendedSize / (double)currentSize;
        out.append("iTable contains extends" + nl);
        out.append("-----------------------" + nl);
        out.append("current    iTable size : " + currentSize + nl);
        out.append("new        iTable size : " + extendedSize + nl);
        out.append("growth factor          : " + percent + nl);
        out.append(nl);
    }
}

