/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindAllModulesCommand
extends Command {
    public FindAllModulesCommand() {
        this.addCommand("findallmodules", "", "Outputs all the modules loaded by the runtime");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
                while (iterator.hasNext()) {
                    J9ClassLoaderPointer classLoaderPointer = iterator.next();
                    HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(classLoaderPointer.moduleHashTable());
                    Iterator slotIterator = moduleHashTable.iterator();
                    while (slotIterator.hasNext()) {
                        J9ModulePointer modulePtr = (J9ModulePointer)slotIterator.next();
                        String moduleName = ModularityHelper.getModuleName(modulePtr);
                        String hexAddress = modulePtr.getHexAddress();
                        out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
                    }
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

