/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ModularityHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleReadsCommand
extends Command {
    public DumpModuleReadsCommand() {
        this.addCommand("dumpmodulereads", "<targetModuleAddress>", "display all modules read by the target module");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !dumpmodulereads <targetModuleAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                String targetModuleAddress = args[0];
                J9ModulePointer modulePtr = J9ModulePointer.cast(Long.decode(targetModuleAddress));
                J9HashTablePointer readTable = modulePtr.readAccessHashTable();
                HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(readTable);
                Iterator slotIterator = moduleHashTable.iterator();
                while (slotIterator.hasNext()) {
                    J9ModulePointer readModulePtr = (J9ModulePointer)slotIterator.next();
                    String moduleName = ModularityHelper.getModuleName(readModulePtr);
                    String hexAddress = readModulePtr.getHexAddress();
                    out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

