/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_ContinuationObjectListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class VirtualThreadsCommand
extends Command {
    private static J9ObjectFieldOffset vthreadOffset;
    private static J9ObjectFieldOffset vmRefOffset;
    private static J9ObjectFieldOffset nameOffset;

    private static J9ObjectPointer getVirtualThread(J9ObjectPointer continuation) throws CorruptDataException {
        if (vthreadOffset == null) {
            vthreadOffset = J9ObjectHelper.getFieldOffset(continuation, "vthread", "Ljava/lang/Thread;");
        }
        return J9ObjectHelper.getObjectField(continuation, vthreadOffset);
    }

    private static long getVmRef(J9ObjectPointer continuation) throws CorruptDataException {
        if (vmRefOffset == null) {
            vmRefOffset = J9ObjectHelper.getFieldOffset(continuation, "vmRef", "J");
        }
        return J9ObjectHelper.getLongField(continuation, vmRefOffset);
    }

    private static String getName(J9ObjectPointer vthread) throws CorruptDataException {
        String name = null;
        if (vthread.notNull()) {
            if (nameOffset == null) {
                nameOffset = J9ObjectHelper.getFieldOffset(vthread, "name", "Ljava/lang/String;");
            }
            name = J9ObjectHelper.getStringField(vthread, nameOffset);
        }
        return name != null ? name : "<N/A>";
    }

    public VirtualThreadsCommand() {
        this.addCommand("vthreads", "", "Lists virtual threads");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureMinimumJavaVersion(19, vm, out)) {
                VirtualThreadsCommand.displayVirtualThreads(vm, out);
            }
        }
        catch (CorruptDataException | NoSuchFieldException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private static void displayVirtualThreads(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException, NoSuchFieldException {
        String addressFormat = "0x%0" + UDATA.SIZEOF * 2 + "x";
        String outputFormat = "!continuationstack " + addressFormat + " !j9vmcontinuation " + addressFormat + " !j9object %s (Continuation) !j9object %s (VThread) - %s%n";
        MM_GCExtensionsPointer extensions = GCBase.getExtensions();
        UDATA linkOffset = extensions.accessBarrier()._continuationLinkOffset();
        MM_ContinuationObjectListPointer continuationObjectList = extensions.continuationObjectLists();
        while (continuationObjectList.notNull()) {
            J9ObjectPointer continuation = continuationObjectList._head();
            while (continuation.notNull()) {
                long vmRef = VirtualThreadsCommand.getVmRef(continuation);
                J9ObjectPointer vthread = VirtualThreadsCommand.getVirtualThread(continuation);
                String name = VirtualThreadsCommand.getName(vthread);
                out.format(outputFormat, vmRef, vmRef, continuation.getHexAddress(), vthread.getHexAddress(), name);
                continuation = ObjectReferencePointer.cast(continuation.addOffset(linkOffset)).at(0L);
            }
            continuationObjectList = continuationObjectList._nextList();
        }
    }
}

