/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.util.RuntimeTypeResolutionUtils;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;

public abstract class StructurePointer
extends AbstractPointer {
    private static final String nl = System.getProperty("line.separator");

    protected StructurePointer(long address) {
        super(address);
    }

    @Override
    public DataType at(long count) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(long count) instead.");
    }

    @Override
    public DataType at(Scalar count) {
        throw new UnsupportedOperationException("StructurePointers are implicitly dereferenced.  Use add(Scalar count) instead.");
    }

    protected final I8 getI8Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 8);
        long cell = this.getByteAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 8, true);
        return new I8(field);
    }

    protected final I16 getI16Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 16);
        long cell = this.getShortAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 16, true);
        return new I16(field);
    }

    protected final I32 getI32Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 32);
        long cell = this.getIntAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 32, true);
        return new I32(field);
    }

    protected final I64 getI64Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 64);
        long cell = this.getLongAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 64, true);
        return new I64(field);
    }

    protected final U8 getU8Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 8);
        long cell = this.getByteAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 8, false);
        return new U8(field);
    }

    protected final U16 getU16Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 16);
        long cell = this.getShortAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 16, false);
        return new U16(field);
    }

    protected final U32 getU32Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 32);
        long cell = this.getIntAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 32, false);
        return new U32(field);
    }

    protected final U64 getU64Bitfield(int bitOffset, int bitWidth) throws CorruptDataException {
        long cellOffset = StructurePointer.getCellOffset(bitOffset, 64);
        long cell = this.getLongAtOffset(cellOffset);
        long field = StructurePointer.getBitfield(cell, bitOffset, bitWidth, 64, false);
        return new U64(field);
    }

    private static long getCellOffset(int bitOffset, int cellSize) {
        long cellIndex = bitOffset / cellSize;
        return cellIndex * (long)(cellSize / 8);
    }

    private static long getBitfield(long cell, int bitOffset, int bitWidth, int cellSize, boolean isSigned) {
        int leftShift;
        switch (BITFIELD_FORMAT) {
            case 1: {
                leftShift = 64 - bitWidth - bitOffset % cellSize;
                break;
            }
            case 2: {
                leftShift = 64 - cellSize + bitOffset % cellSize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bitfield format");
            }
        }
        long leftAligned = cell << leftShift;
        int rightShift = 64 - bitWidth;
        if (isSigned) {
            return leftAligned >> rightShift;
        }
        return leftAligned >>> rightShift;
    }

    public StructurePointer getAsRuntimeType() {
        try {
            Method typeIdGetter = this.getClass().getMethod("_typeId", new Class[0]);
            U8Pointer strPtr = (U8Pointer)typeIdGetter.invoke((Object)this, new Object[0]);
            String typeStr = strPtr.getCStringAtOffset(0L);
            if (strPtr.notNull()) {
                typeStr = RuntimeTypeResolutionUtils.cleanTypeStr(typeStr);
                Class<?> runtimeClass = Class.forName(this.getClass().getPackage().getName() + "." + typeStr + "Pointer");
                Method castMethod = runtimeClass.getMethod("cast", AbstractPointer.class);
                Object retVal = castMethod.invoke(null, this);
                return (StructurePointer)retVal;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public String formatFullInteractive() {
        StructureField[] fields;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTargetName());
        builder.append(" at ");
        builder.append("0x");
        builder.append(Long.toHexString(this.getAddress()));
        builder.append(" {");
        builder.append(nl);
        for (StructureField thisField : fields = this.getStructureFields()) {
            builder.append("\t0x");
            builder.append(Integer.toHexString(thisField.offset));
            builder.append(": ");
            builder.append(thisField.type);
            builder.append(" ");
            builder.append(thisField.name);
            builder.append(" = ");
            if (thisField.cde != null) {
                builder.append("<FAULT: " + thisField.cde.getMessage() + ">");
            } else if (thisField.value != null) {
                builder.append(thisField.value.formatShortInteractive());
            } else {
                builder.append("null");
            }
            builder.append(nl);
        }
        builder.append("}");
        builder.append("\n");
        return builder.toString();
    }

    public StructureField[] getStructureFields() {
        GeneratedPointerClass classAnnotation;
        LinkedList<StructureField> fields = new LinkedList<StructureField>();
        for (Class<?> working = this.getClass(); working != null && null != (classAnnotation = working.getAnnotation(GeneratedPointerClass.class)); working = working.getSuperclass()) {
            for (Method thisMethod : working.getMethods()) {
                if (!thisMethod.isAnnotationPresent(GeneratedFieldAccessor.class)) continue;
                GeneratedFieldAccessor fieldAnnotation = thisMethod.getAnnotation(GeneratedFieldAccessor.class);
                Field offsetField = null;
                try {
                    offsetField = classAnnotation.structureClass().getField(fieldAnnotation.offsetFieldName());
                }
                catch (SecurityException e) {
                    throw new Error("Unexpected security exception", e);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                int offset = -1;
                try {
                    offset = offsetField.getInt(null);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
                DataType result = null;
                CorruptDataException cde = null;
                try {
                    result = (DataType)thisMethod.invoke((Object)this, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CorruptDataException) {
                        cde = (CorruptDataException)cause;
                    }
                    throw new RuntimeException(e);
                }
                fields.add(new StructureField(thisMethod.getName(), fieldAnnotation.declaredType(), offset, result, cde));
            }
        }
        Collections.sort(fields);
        StructureField[] result = new StructureField[fields.size()];
        fields.toArray(result);
        return result;
    }

    public static class StructureField
    implements Comparable<StructureField> {
        public final int offset;
        public final String name;
        public final DataType value;
        public final String type;
        public final CorruptDataException cde;

        StructureField(String name, String type2, int offset, DataType value, CorruptDataException cde) {
            this.name = name;
            this.offset = offset;
            this.value = value;
            this.type = type2;
            this.cde = cde;
        }

        @Override
        public int compareTo(StructureField o) {
            return this.offset - o.offset;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.type);
            builder.append(" ");
            builder.append(this.name);
            builder.append(" (");
            if (this.cde == null) {
                builder.append(Integer.toHexString(this.offset));
            } else {
                builder.append("<FAULT: " + this.cde.getMessage() + ">");
            }
            builder.append(")");
            return builder.toString();
        }
    }
}

