/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectDiscontiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectWithDataAddressContiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectWithDataAddressDiscontiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class AbstractPointer
extends DataType {
    private static final int CACHE_SIZE = 32;
    private static final int[] counts = new int[32];
    private static long hits;
    private static final long[] keys;
    private static long probes;
    private static final J9ClassPointer[] values;
    protected final long address;

    protected AbstractPointer(long address) {
        this.address = 4 == DataType.getProcess().bytesPerPointer() ? 0xFFFFFFFFL & address : address;
    }

    public abstract AbstractPointer add(long var1);

    public abstract AbstractPointer add(Scalar var1);

    public abstract AbstractPointer addOffset(long var1);

    public abstract AbstractPointer addOffset(Scalar var1);

    public abstract AbstractPointer sub(long var1);

    public abstract AbstractPointer sub(Scalar var1);

    public abstract AbstractPointer subOffset(long var1);

    public abstract AbstractPointer subOffset(Scalar var1);

    public abstract AbstractPointer untag(long var1);

    public abstract AbstractPointer untag();

    public final boolean allBitsIn(long bitmask) {
        if (0L == bitmask) {
            return false;
        }
        return bitmask == (this.address & bitmask);
    }

    public boolean anyBitsIn(long bitmask) {
        return 0L != (this.address & bitmask);
    }

    @Override
    public long longValue() throws CorruptDataException {
        return this.address;
    }

    public abstract DataType at(long var1) throws CorruptDataException;

    public abstract DataType at(Scalar var1) throws CorruptDataException;

    public boolean isNull() {
        return this.address == 0L;
    }

    public boolean notNull() {
        return this.address != 0L;
    }

    public boolean eq(Object obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractPointer)) {
            return false;
        }
        return this.address == ((AbstractPointer)obj).address;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFFL & this.address ^ (0xFFFFFFFF00000000L & this.address) >> 32);
    }

    public long getAddress() {
        return this.address;
    }

    public final long nonNullAddress() throws NullPointerDereference {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return this.address;
    }

    public final long nonNullFieldEA(long offset) throws NullPointerDereference {
        return this.nonNullAddress() + offset;
    }

    public String getHexAddress() {
        return String.format("0x%0" + UDATA.SIZEOF * 2 + "X", this.address);
    }

    public String hexAt(long index) throws CorruptDataException {
        String result = "0x";
        int bufferSize = this instanceof StructurePointer ? UDATA.SIZEOF : (int)this.sizeOfBaseType();
        byte[] buffer = new byte[bufferSize];
        this.getBytesAtOffset(index, buffer);
        for (int i = 0; i < buffer.length; ++i) {
            result = result + String.format("%02X", buffer[i]);
        }
        return result;
    }

    public String hexAt(Scalar index) throws CorruptDataException {
        return this.hexAt(index.longValue());
    }

    public String getHexValue() throws CorruptDataException {
        String result = "0x";
        int bufferSize = this instanceof StructurePointer ? UDATA.SIZEOF : (int)this.sizeOfBaseType();
        byte[] buffer = new byte[bufferSize];
        this.getBytesAtOffset(0L, buffer);
        if (J9BuildFlags.J9VM_ENV_LITTLE_ENDIAN) {
            for (int i = buffer.length - 1; i >= 0; --i) {
                result = result + String.format("%02X", buffer[i]);
            }
        } else {
            for (int i = 0; i < buffer.length; ++i) {
                result = result + String.format("%02X", buffer[i]);
            }
        }
        return result;
    }

    protected static IProcess getAddressSpace() {
        return process;
    }

    public boolean lt(AbstractPointer pointer) {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new U64(this.address).lt(new U64(pointer.address));
        }
        return this.address < pointer.address;
    }

    public boolean lte(AbstractPointer pointer) {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new U64(this.address).lte(new U64(pointer.address));
        }
        return this.address <= pointer.address;
    }

    public boolean gt(AbstractPointer pointer) {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new U64(this.address).gt(new U64(pointer.address));
        }
        return this.address > pointer.address;
    }

    public boolean gte(AbstractPointer pointer) {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new U64(this.address).gte(new U64(pointer.address));
        }
        return this.address >= pointer.address;
    }

    public IDATA sub(AbstractPointer pointer) {
        if (this.getClass() != pointer.getClass()) {
            throw new UnsupportedOperationException("Cannot subtract different pointer types. This type = " + this.getClass() + ", parameter type = " + pointer.getClass());
        }
        IDATA diff = new IDATA(this.address).sub(new IDATA(pointer.address));
        return new IDATA(diff.longValue() / this.sizeOfBaseType());
    }

    protected abstract long sizeOfBaseType();

    public int compare(AbstractPointer pointer) {
        return this.address == pointer.address ? 0 : (this.lt(pointer) ? -1 : 1);
    }

    public String toString() {
        String pointerType = this.getClass().getName();
        try {
            if (this instanceof J9ObjectPointer || this instanceof J9IndexableObjectPointer || this instanceof J9IndexableObjectContiguousPointer || this instanceof J9IndexableObjectDiscontiguousPointer || this instanceof J9IndexableObjectWithDataAddressContiguousPointer || this instanceof J9IndexableObjectWithDataAddressDiscontiguousPointer) {
                pointerType = J9ObjectHelper.getClassName(J9ObjectPointer.cast(this));
            }
            if (this instanceof J9ROMFieldShapePointer) {
                return J9ROMFieldShapeHelper.toString(J9ROMFieldShapePointer.cast(this));
            }
            if (this.address == 0L) {
                return String.format("%s @ 00000", pointerType);
            }
            return String.format("%s @ 0x%08X%n%s", pointerType, this.address, this.getMemString(16));
        }
        catch (CorruptDataException e) {
            return super.toString();
        }
    }

    private String getMemString(int words) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(bos);
        this.dumpHex(words, stream);
        return bos.toString();
    }

    private void dumpHex(int words, PrintStream stream) {
        if (this.isNull()) {
            return;
        }
        stream.println();
        for (int i = 0; i < words; ++i) {
            try {
                int word = this.getIntAtOffset(i * 4);
                if (i % 4 == 0) {
                    stream.print(String.format("%08X : ", this.getAddress() + (long)(i * 4)));
                }
                stream.print(String.format("%08X ", word));
                if (i % 4 != 3) continue;
                stream.println();
                continue;
            }
            catch (CorruptDataException e) {
                stream.print(" FAULT ");
            }
        }
        stream.println();
    }

    protected long getPointerAtOffset(long offset) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getPointerAt(this.nonNullFieldEA(offset));
    }

    protected int getIntAtOffset(long offset) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getIntAt(this.nonNullFieldEA(offset));
    }

    protected double getDoubleAtOffset(long offset) throws CorruptDataException {
        return Double.longBitsToDouble(this.getLongAtOffset(offset));
    }

    protected float getFloatAtOffset(long offset) throws CorruptDataException {
        return Float.intBitsToFloat(this.getIntAtOffset(offset));
    }

    protected boolean getBoolAtOffset(long offset) throws CorruptDataException {
        switch (SIZEOF_BOOL) {
            case 1: {
                return 0 != this.getByteAtOffset(offset);
            }
            case 2: {
                return 0 != this.getShortAtOffset(offset);
            }
            case 4: {
                return 0 != this.getIntAtOffset(offset);
            }
            case 8: {
                return 0L != this.getLongAtOffset(offset);
            }
        }
        byte[] buffer = new byte[SIZEOF_BOOL];
        this.getBytesAtOffset(offset, buffer);
        for (int i = 0; i < SIZEOF_BOOL; ++i) {
            if (0 == buffer[i]) continue;
            return true;
        }
        return false;
    }

    protected UDATA getUDATAAtOffset(long offset) throws CorruptDataException {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new UDATA(this.getLongAtOffset(offset));
        }
        return new UDATA(this.getIntAtOffset(offset));
    }

    protected IDATA getIDATAAtOffset(long offset) throws CorruptDataException {
        if (J9BuildFlags.J9VM_ENV_DATA64) {
            return new IDATA(this.getLongAtOffset(offset));
        }
        return new IDATA(this.getIntAtOffset(offset));
    }

    protected short getShortAtOffset(long offset) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getShortAt(this.nonNullFieldEA(offset));
    }

    protected byte getByteAtOffset(long offset) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getByteAt(this.nonNullFieldEA(offset));
    }

    public int getBytesAtOffset(long offset, byte[] data) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getBytesAt(this.nonNullFieldEA(offset), data);
    }

    protected char getBaseCharAtOffset(long offset) throws CorruptDataException {
        return (char)(this.getShortAtOffset(offset) & 0xFFFF);
    }

    protected long getLongAtOffset(long offset) throws CorruptDataException {
        return AbstractPointer.getAddressSpace().getLongAt(this.nonNullFieldEA(offset));
    }

    protected J9ObjectPointer getObjectReferenceAtOffset(long offset) throws CorruptDataException {
        if (J9ObjectHelper.compressObjectReferences) {
            return ObjectAccessBarrier.convertPointerFromToken(this.getIntAtOffset(offset));
        }
        return J9ObjectPointer.cast(this.getPointerAtOffset(offset));
    }

    protected J9ClassPointer getObjectClassAtOffset(long offset) throws CorruptDataException {
        long classPointer = J9ObjectHelper.compressObjectReferences ? (long)this.getIntAtOffset(offset) & 0xFFFFFFFFL : this.getPointerAtOffset(offset);
        if (classPointer == 0L) {
            throw new MemoryFault(this.address + offset, "Invalid class address found in object");
        }
        J9ClassPointer cp = AbstractPointer.checkClassCache(classPointer);
        if (cp == null) {
            cp = J9ClassPointer.cast(classPointer);
            AbstractPointer.setClassCache(classPointer, cp);
        }
        return cp;
    }

    private static J9ClassPointer checkClassCache(long pointer) {
        ++probes;
        for (int i = 0; i < 32; ++i) {
            if (keys[i] != pointer) continue;
            ++hits;
            int n = i;
            counts[n] = counts[n] + 1;
            return values[i];
        }
        return null;
    }

    private static void setClassCache(long pointer, J9ClassPointer cp) {
        int min = counts[0];
        int minIndex = 0;
        for (int i = 1; i < 32; ++i) {
            if (min <= counts[i]) continue;
            min = counts[i];
            minIndex = i;
        }
        AbstractPointer.counts[minIndex] = 1;
        AbstractPointer.keys[minIndex] = pointer;
        AbstractPointer.values[minIndex] = cp;
    }

    protected J9ObjectMonitorPointer getObjectMonitorAtOffset(long offset) throws CorruptDataException {
        if (J9ObjectHelper.compressObjectReferences) {
            return J9ObjectMonitorPointer.cast(0xFFFFFFFFL & (long)this.getIntAtOffset(offset));
        }
        return J9ObjectMonitorPointer.cast(this.getPointerAtOffset(offset));
    }

    public String formatFullInteractive() {
        return this.toString();
    }

    public String getTargetName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Pointer")) {
            name = name.substring(0, name.length() - "Pointer".length());
        }
        return name;
    }

    @Override
    public String formatShortInteractive() {
        String name = this.getTargetName();
        name = name.toLowerCase();
        return "!" + name + " 0x" + Long.toHexString(this.getAddress());
    }

    public static void reportClassCacheStats() {
        double hitRate = (double)hits / (double)probes * 100.0;
        System.out.println("AbstractPointer probes: " + probes + " hit rate: " + hitRate + "%");
        Arrays.fill(counts, 0);
        hits = 0L;
        Arrays.fill(keys, 0L);
        probes = 0L;
        Arrays.fill(values, null);
    }

    static {
        keys = new long[32];
        values = new J9ClassPointer[32];
    }
}

