/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolSplitAddressOrderedList;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

class GCFreeListHeapIteratorSplitAddressOrderedList
extends GCFreeListHeapIterator {
    protected UDATA _freeListIndex = new UDATA(0L);
    protected GCMemoryPoolSplitAddressOrderedList _memoryPool = null;
    protected GCHeapLinkedFreeHeader _currentFreeEntry = null;
    protected UDATA _totalListCount = null;

    public GCFreeListHeapIteratorSplitAddressOrderedList(GCMemoryPoolSplitAddressOrderedList memoryPool) throws CorruptDataException {
        this._memoryPool = memoryPool;
        this._totalListCount = this._memoryPool.getFreeListCount();
        this.advanceFreeListEntry();
    }

    private void advanceFreeListEntry() {
        try {
            if (this._currentFreeEntry != null) {
                if (this._currentFreeEntry.getNext().getHeader().notNull()) {
                    this._currentFreeEntry = this._currentFreeEntry.getNext();
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            while (this._freeListIndex.lt(this._totalListCount)) {
                this._currentFreeEntry = this._memoryPool.getFirstEntryAtFreeListIndex(this._freeListIndex);
                if (this._currentFreeEntry.getHeader().notNull()) {
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            this._currentFreeEntry = null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", e, false);
            this._currentFreeEntry = null;
        }
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCHeapLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCHeapLinkedFreeHeader next = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public int getFreeListNumber() {
        return this._freeListIndex.intValue();
    }

    @Override
    public String toString() {
        GCFreeListHeapIteratorSplitAddressOrderedList tempIter = null;
        try {
            tempIter = new GCFreeListHeapIteratorSplitAddressOrderedList(this._memoryPool);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Corruption detected", e, false);
            return e.toString();
        }
        StringBuilder builder = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        while (tempIter.hasNext()) {
            builder.append(tempIter.next() + NEW_LINE);
        }
        return builder.toString();
    }
}

