/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassArrayClassSlotIterator
extends GCIterator {
    protected Iterator<J9ClassPointer> slotIterator;
    protected Iterator<VoidPointer> addressIterator;

    protected GCClassArrayClassSlotIterator(J9ClassPointer clazz) throws CorruptDataException {
        ArrayList<J9ClassPointer> slots = new ArrayList<J9ClassPointer>();
        ArrayList<VoidPointer> addresses = new ArrayList<VoidPointer>();
        J9ClassPointer slot = clazz.arrayClass();
        if (slot.notNull()) {
            slots.add(slot);
            addresses.add(VoidPointer.cast(clazz.arrayClassEA()));
        }
        if (clazz.romClass().modifiers().allBitsIn(J9JavaAccessFlags.J9AccClassArray)) {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
            if (J9BuildFlags.J9VM_OPT_VALHALLA_FLATTENABLE_VALUE_TYPES) {
                try {
                    slot = arrayClass.companionArray();
                    if (slot.notNull()) {
                        slots.add(slot);
                        addresses.add(VoidPointer.cast(arrayClass.companionArrayEA()));
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new CorruptDataException("J9ArrayClass.companionArray field does not exist", e);
                }
            }
            if ((slot = arrayClass.componentType()).notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(arrayClass.componentTypeEA()));
            }
            if ((slot = arrayClass.leafComponentType()).notNull()) {
                slots.add(slot);
                addresses.add(VoidPointer.cast(arrayClass.leafComponentTypeEA()));
            }
        }
        this.slotIterator = slots.iterator();
        this.addressIterator = addresses.iterator();
    }

    public static GCClassArrayClassSlotIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassArrayClassSlotIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    @Override
    public J9ClassPointer next() {
        this.addressIterator.next();
        return this.slotIterator.next();
    }

    @Override
    public VoidPointer nextAddress() {
        this.slotIterator.next();
        return this.addressIterator.next();
    }
}

