/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ROMClassesRangeIterator
extends ROMClassesIterator
implements Iterator<J9ROMClassPointer> {
    private long startAddr;
    private long endAddr;

    public ROMClassesRangeIterator(PrintStream out, U8Pointer startAddr, U8Pointer endAddr) throws CorruptDataException {
        super(out, null);
        this.startAddr = startAddr.longValue();
        this.endAddr = endAddr.longValue();
    }

    @Override
    public boolean hasNext() {
        return J9ROMClassPointer.NULL != this.getNextClass();
    }

    @Override
    public J9ROMClassPointer next() {
        J9ROMClassPointer clazz = this.getNextClass();
        if (clazz == J9ROMClassPointer.NULL) {
            throw new NoSuchElementException();
        }
        this.nextClass = clazz;
        return this.nextClass;
    }

    private J9ROMClassPointer getNextClass() {
        long newHeapPtr = 0L;
        J9ROMClassPointer newNextClass = J9ROMClassPointer.NULL;
        if (this.nextClass == J9ROMClassPointer.NULL) {
            newHeapPtr = this.startAddr;
        } else {
            try {
                newHeapPtr = this.nextClass.getAddress() + this.nextClass.romSize().longValue();
            }
            catch (CorruptDataException e) {
                this.out.append("Unabled to read size of ROMClass at " + this.nextClass.getHexAddress() + ".\n");
                newNextClass = J9ROMClassPointer.NULL;
            }
        }
        if (newHeapPtr != 0L && newHeapPtr < this.endAddr) {
            newNextClass = J9ROMClassPointer.cast(newHeapPtr);
            try {
                if (newNextClass.romSize().eq(0L)) {
                    this.out.append("Size of ROMClass at " + newNextClass.getHexAddress() + "is invalid.\n");
                    newNextClass = J9ROMClassPointer.NULL;
                }
            }
            catch (CorruptDataException e) {
                this.out.append("Unable to read size of ROMClass at " + newNextClass.getHexAddress() + ".\n");
                newNextClass = J9ROMClassPointer.NULL;
            }
        }
        return newNextClass;
    }
}

