/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.structure.J9MemorySegment;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ROMClassesIterator
implements Iterator<J9ROMClassPointer> {
    private J9MemorySegmentPointer nextSegment;
    protected J9ROMClassPointer nextClass;
    protected final PrintStream out;

    public ROMClassesIterator(PrintStream out, J9MemorySegmentListPointer segmentList) {
        this.out = out;
        if (segmentList == null) {
            this.nextSegment = J9MemorySegmentPointer.NULL;
        } else {
            try {
                this.nextSegment = segmentList.nextSegment();
            }
            catch (CorruptDataException e) {
                this.nextSegment = J9MemorySegmentPointer.NULL;
            }
        }
        this.nextClass = J9ROMClassPointer.NULL;
    }

    @Override
    public boolean hasNext() {
        return J9ROMClassPointer.NULL != this.getNextClass().getClassPointer();
    }

    @Override
    public J9ROMClassPointer next() {
        ClassAndSegment classAndSegment = this.getNextClass();
        J9ROMClassPointer clazz = classAndSegment.getClassPointer();
        if (clazz == J9ROMClassPointer.NULL) {
            throw new NoSuchElementException();
        }
        this.nextClass = clazz;
        this.nextSegment = classAndSegment.getSegmentPointer();
        return this.nextClass;
    }

    private ClassAndSegment getNextClass() {
        J9MemorySegmentPointer nextSegmentPtr;
        J9ROMClassPointer newNextClass;
        block7: {
            newNextClass = J9ROMClassPointer.NULL;
            nextSegmentPtr = this.nextSegment;
            try {
                if (this.nextSegment.isNull()) break block7;
                long newHeapPtr = 0L;
                newHeapPtr = this.nextClass == J9ROMClassPointer.NULL ? nextSegmentPtr.heapBase().longValue() : this.nextClass.getAddress() + this.nextClass.romSize().longValue();
                do {
                    if (nextSegmentPtr.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_ROM_CLASS) && newHeapPtr < nextSegmentPtr.heapAlloc().longValue()) {
                        newNextClass = J9ROMClassPointer.cast(newHeapPtr);
                        try {
                            if (!newNextClass.romSize().eq(0L)) {
                                return new ClassAndSegment(newNextClass, nextSegmentPtr);
                            }
                            this.out.append("Size of ROMClass at " + newNextClass.getHexAddress() + "is invalid. Skipping to next segment.\n");
                            newNextClass = J9ROMClassPointer.NULL;
                        }
                        catch (CorruptDataException e) {
                            this.out.append("Unable to read size of ROMClass at " + newNextClass.getHexAddress() + ". Skipping to next segment.\n");
                            newNextClass = J9ROMClassPointer.NULL;
                        }
                    }
                    if ((nextSegmentPtr = nextSegmentPtr.nextSegment()).isNull()) continue;
                    newHeapPtr = nextSegmentPtr.heapBase().longValue();
                } while (!nextSegmentPtr.isNull());
            }
            catch (CorruptDataException e) {
                newNextClass = J9ROMClassPointer.NULL;
            }
        }
        return new ClassAndSegment(newNextClass, nextSegmentPtr);
    }

    public J9MemorySegmentPointer getMemorySegmentPointer() {
        return this.nextSegment;
    }

    @Override
    public void remove() {
    }

    class ClassAndSegment {
        J9ROMClassPointer classPointer;
        J9MemorySegmentPointer segmentPointer;

        ClassAndSegment(J9ROMClassPointer clazz, J9MemorySegmentPointer segment) {
            this.classPointer = clazz;
            this.segmentPointer = segment;
        }

        public J9ROMClassPointer getClassPointer() {
            return this.classPointer;
        }

        public J9MemorySegmentPointer getSegmentPointer() {
            return this.segmentPointer;
        }
    }
}

