/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MarkMapManagerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm27.structure.MM_HeapMap;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.NoSuchElementException;

public class GCObjectHeapIteratorMarkMapIterator_V1
extends GCObjectHeapIterator {
    private static final int HEAP_BYTES_PER_MAP_BIT = (int)MM_HeapMap.J9MODRON_HEAP_SLOTS_PER_HEAPMAP_BIT * UDATA.SIZEOF;
    private static final int HEAP_BYTES_PER_MAP_SLOT = HEAP_BYTES_PER_MAP_BIT * (int)MM_HeapMap.BITS_IN_BYTE * UDATA.SIZEOF;
    protected VoidPointer _heapBase;
    protected UDATAPointer _heapMapBits;
    protected UDATA _markWordCache;
    protected long _nextSlotIndex;
    protected long _topSlotIndex;
    protected int _shiftCount;
    protected J9ObjectPointer _nextObject;

    protected GCObjectHeapIteratorMarkMapIterator_V1(GCHeapRegionDescriptor hrd) throws CorruptDataException {
        super(true, false);
        MM_GCExtensionsPointer extensions = GCObjectHeapIteratorMarkMapIterator_V1.getExtensions();
        MM_IncrementalGenerationalGCPointer collector = MM_IncrementalGenerationalGCPointer.cast(extensions._globalCollector());
        MM_MarkMapManagerPointer markMapManager = collector._markMapManager();
        MM_MarkMapPointer markMap = markMapManager._previousMarkMap();
        this._heapBase = markMap._heapBase();
        this._heapMapBits = markMap._heapMapBits();
        VoidPointer regionBase = hrd.getLowAddress();
        this._nextSlotIndex = this.convertAddressToMapSlotIndex(this._heapBase, regionBase);
        VoidPointer regionTop = hrd.getHighAddress();
        this._topSlotIndex = this.convertAddressToMapSlotIndex(this._heapBase, regionTop);
        this._markWordCache = new UDATA(0L);
        this._shiftCount = 0;
    }

    private long convertAddressToMapSlotIndex(VoidPointer heapBase, VoidPointer address) throws CorruptDataException {
        long heapDelta = address.longValue() - heapBase.longValue();
        return heapDelta / (long)HEAP_BYTES_PER_MAP_SLOT;
    }

    @Override
    public void advance(UDATA size) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            if (null == this._nextObject) {
                this.nextImpl();
            }
            J9ObjectPointer next = this._nextObject;
            this._nextObject = null;
            if (null != next) {
                return next;
            }
        }
        throw new NoSuchElementException("No more objects");
    }

    @Override
    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            J9ObjectPointer next;
            if (null == this._nextObject) {
                this.nextImpl();
            }
            if (null != (next = this._nextObject)) {
                return next;
            }
        }
        throw new NoSuchElementException("No more objects");
    }

    protected void nextImpl() {
        this._nextObject = null;
        while (!(null != this._nextObject || this._nextSlotIndex == this._topSlotIndex && this._markWordCache.eq(0L))) {
            while (null == this._nextObject && !this._markWordCache.eq(0L)) {
                if (this._markWordCache.allBitsIn(1L)) {
                    this._nextObject = this.convertToObject(this._nextSlotIndex - 1L, this._shiftCount);
                }
                ++this._shiftCount;
                this._markWordCache = this._markWordCache.rightShift(1);
            }
            if (null != this._nextObject) continue;
            try {
                this.recacheMarkMapWord();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                throw new NoSuchElementException("Failed to continue reading objects from region");
            }
        }
    }

    private void recacheMarkMapWord() throws CorruptDataException {
        while (this._markWordCache.eq(0L) && this._nextSlotIndex != this._topSlotIndex) {
            this._markWordCache = this._heapMapBits.at(this._nextSlotIndex);
            ++this._nextSlotIndex;
            this._shiftCount = 0;
        }
    }

    private J9ObjectPointer convertToObject(long heapMapSlotIndex, int heapMapShiftCount) {
        long offsetIntoHeap = (long)HEAP_BYTES_PER_MAP_SLOT * heapMapSlotIndex + (long)(HEAP_BYTES_PER_MAP_BIT * heapMapShiftCount);
        return J9ObjectPointer.cast(this._heapBase.addOffset(offsetIntoHeap));
    }

    @Override
    public boolean hasNext() {
        if (null != this._nextObject) {
            return true;
        }
        boolean hasNext = false;
        try {
            this.recacheMarkMapWord();
            hasNext = !this._markWordCache.eq(0L);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
        }
        return hasNext;
    }
}

