/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIteratorAddressOrderedList_V1;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIteratorMarkMapIterator_V1;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIteratorNullIterator;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolBumpPointerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemorySubSpacePointer;
import com.ibm.j9ddr.vm27.structure.J9MemorySegment;
import com.ibm.j9ddr.vm27.structure.MM_HeapRegionDescriptor$RegionType;
import com.ibm.j9ddr.vm27.types.UDATA;

class GCHeapRegionDescriptor_V1
extends GCHeapRegionDescriptor {
    protected VoidPointer lowAddress;
    protected VoidPointer highAddress;
    protected UDATA regionsInSpan;
    protected long regionType;
    protected UDATA typeFlags;
    protected MM_MemorySubSpacePointer memorySubSpace;
    protected MM_MemoryPoolPointer memoryPool;
    protected GCHeapRegionDescriptor headOfSpan;

    public GCHeapRegionDescriptor_V1(MM_HeapRegionDescriptorPointer heapRegionDescriptorPointer) throws CorruptDataException {
        super(heapRegionDescriptorPointer);
        this.heapRegionDescriptor = heapRegionDescriptorPointer;
        this.init();
    }

    protected void init() throws CorruptDataException {
        this.lowAddress = this.heapRegionDescriptor._lowAddress();
        this.regionsInSpan = this.heapRegionDescriptor._regionsInSpan();
        this.regionType = this.heapRegionDescriptor._regionType();
        MM_MemorySubSpacePointer subSpace = this.heapRegionDescriptor._memorySubSpace();
        this.typeFlags = subSpace.notNull() ? subSpace._memoryType().bitOr(J9MemorySegment.MEMORY_TYPE_RAM) : new UDATA(0L);
        this.memorySubSpace = this.heapRegionDescriptor._memorySubSpace();
        this.memoryPool = this.heapRegionDescriptor._memoryPool();
        if (this.regionsInSpan.eq(0L)) {
            this.highAddress = this.heapRegionDescriptor._highAddress();
        } else {
            UDATA delta = UDATA.cast(this.heapRegionDescriptor._highAddress()).sub(UDATA.cast(this.lowAddress));
            this.highAddress = this.lowAddress.addOffset(this.regionsInSpan.mult(delta));
        }
        MM_HeapRegionDescriptorPointer head = this.heapRegionDescriptor._headOfSpan();
        this.headOfSpan = head.isNull() || head.eq(this.heapRegionDescriptor) ? this : GCHeapRegionDescriptor.fromHeapRegionDescriptor(head);
    }

    @Override
    public VoidPointer getLowAddress() {
        return this.lowAddress;
    }

    @Override
    public VoidPointer getHighAddress() {
        return this.highAddress;
    }

    @Override
    public UDATA getSize() {
        return UDATA.cast(this.getHighAddress()).sub(UDATA.cast(this.getLowAddress()));
    }

    @Override
    public UDATA getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean hasValidMarkMap() {
        return MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED_MARKED == this.regionType || MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED_MARKED == this.regionType;
    }

    @Override
    public boolean containsObjects() {
        return J9BuildFlags.gc_realtime && (MM_HeapRegionDescriptor$RegionType.SEGREGATED_LARGE == this.regionType || MM_HeapRegionDescriptor$RegionType.SEGREGATED_SMALL == this.regionType) || MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED == this.regionType || MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED_MARKED == this.regionType || MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED == this.regionType || MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED_MARKED == this.regionType;
    }

    protected VoidPointer getWalkableHighAddress() throws CorruptDataException {
        if (MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED == this.regionType || MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED_MARKED == this.regionType) {
            return MM_MemoryPoolBumpPointerPointer.cast(this.heapRegionDescriptor._memoryPool())._allocatePointer();
        }
        return this.getHighAddress();
    }

    @Override
    public long getRegionType() {
        return this.regionType;
    }

    @Override
    public MM_MemorySubSpacePointer getSubSpace() {
        return this.memorySubSpace;
    }

    @Override
    public MM_MemoryPoolPointer getMemoryPool() {
        return this.memoryPool;
    }

    @Override
    public boolean isAddressInRegion(AbstractPointer address) {
        return address.gte(this.getLowAddress()) && address.lt(this.getHighAddress());
    }

    @Override
    public GCObjectHeapIterator objectIterator(boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        GCObjectHeapIterator iterator = null;
        if (this.hasValidMarkMap()) {
            if (includeLiveObjects) {
                AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_OBJECT_HEAP_ITERATOR_MARK_MAP_VERSION");
                switch (version.getAlgorithmVersion()) {
                    default: 
                }
                iterator = new GCObjectHeapIteratorMarkMapIterator_V1(this);
            } else {
                iterator = new GCObjectHeapIteratorNullIterator();
            }
        } else if (this.containsObjects()) {
            AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION");
            switch (version.getAlgorithmVersion()) {
                default: 
            }
            iterator = new GCObjectHeapIteratorAddressOrderedList_V1(U8Pointer.cast(this.getLowAddress()), U8Pointer.cast(this.getWalkableHighAddress()), includeLiveObjects, includeDeadObjects);
        } else {
            iterator = new GCObjectHeapIteratorNullIterator();
        }
        return iterator;
    }

    @Override
    public boolean isImmortal() {
        return this.getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_IMMORTAL);
    }

    @Override
    public boolean isScoped() {
        return this.getTypeFlags().allBitsIn(J9MemorySegment.MEMORY_TYPE_SCOPED);
    }

    @Override
    public GCHeapRegionDescriptor getHeadOfSpan() {
        return this.headOfSpan;
    }

    @Override
    public String descriptionString() {
        if (MM_HeapRegionDescriptor$RegionType.RESERVED == this.regionType) {
            return "RESERVED";
        }
        if (MM_HeapRegionDescriptor$RegionType.FREE == this.regionType) {
            return "FREE";
        }
        if (J9BuildFlags.gc_realtime) {
            if (MM_HeapRegionDescriptor$RegionType.SEGREGATED_SMALL == this.regionType) {
                return "SEGREGATED_SMALL";
            }
            if (MM_HeapRegionDescriptor$RegionType.SEGREGATED_LARGE == this.regionType) {
                return "SEGREGATED_LARGE";
            }
        }
        if (J9BuildFlags.gc_arraylets && MM_HeapRegionDescriptor$RegionType.ARRAYLET_LEAF == this.regionType) {
            return "ARRAYLET_LEAF";
        }
        if (MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED == this.regionType) {
            return "ADDRESS_ORDERED";
        }
        if (MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED_IDLE == this.regionType) {
            return "ADDRESS_ORDERED_IDLE";
        }
        if (MM_HeapRegionDescriptor$RegionType.ADDRESS_ORDERED_MARKED == this.regionType) {
            return "ADDRESS_ORDERED_MARKED";
        }
        if (MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED == this.regionType) {
            return "BUMP_ALLOCATED";
        }
        if (MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED_IDLE == this.regionType) {
            return "BUMP_ALLOCATED_IDLE";
        }
        if (MM_HeapRegionDescriptor$RegionType.BUMP_ALLOCATED_MARKED == this.regionType) {
            return "BUMP_ALLOCATED_MARKED";
        }
        return "UNKNOWN";
    }
}

