/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm26.structure.J9BCTranslationData;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.commands.J9BCUtil;
import com.ibm.j9ddr.vm26.types.U32;
import java.io.PrintStream;

public class BytecodesCommand
extends Command {
    public BytecodesCommand() {
        this.addCommand("bytecodes", "<address>[,maps]", "cfdump the specified J9Method. (maps is optional)");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9MethodPointer ramMethod = J9MethodPointer.cast(address);
            long maps = 0L;
            if (ramMethod.isNull()) {
                CommandUtils.dbgPrint(out, "bad or missing ram method addr\n");
                return;
            }
            J9ClassPointer ramClass = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(ramMethod);
            if (args.length == 2 && args[1].equals("maps")) {
                maps |= J9BCTranslationData.BCT_DumpMaps;
            }
            maps = J9BuildFlags.env_littleEndian ? (maps |= J9BCTranslationData.BCT_LittleEndianOutput) : (maps |= J9BCTranslationData.BCT_BigEndianOutput);
            long methodIndex = new U32(ramMethod.sub(ramClass.ramMethods())).longValue();
            J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(ramMethod);
            J9ROMClassPointer romClass = ramClass.romClass();
            J9BCUtil.j9bcutil_dumpRomMethod(out, romMethod, romClass, maps, methodIndex);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

