/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.Pointer;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

public class VoidPointer
extends Pointer {
    public static final VoidPointer NULL = new VoidPointer(0L);

    protected VoidPointer(long address) {
        super(address);
    }

    public static VoidPointer cast(AbstractPointer pointer) {
        return VoidPointer.cast(pointer.getAddress());
    }

    public static VoidPointer cast(UDATA udata) {
        return VoidPointer.cast(udata.longValue());
    }

    public static VoidPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new VoidPointer(address);
    }

    @Override
    public Scalar at(long index) throws CorruptDataException {
        throw new NullPointerDereference("Can not dereference a void *");
    }

    @Override
    public Scalar at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public VoidPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public VoidPointer untag(long mask) {
        return new VoidPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public VoidPointer add(long count) {
        return new VoidPointer(this.address + SIZEOF * count);
    }

    @Override
    public VoidPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public VoidPointer addOffset(long offset) {
        return new VoidPointer(this.address + offset);
    }

    @Override
    public VoidPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public AbstractPointer sub(long count) {
        throw new UnsupportedOperationException("Pointer math not supported on void pointers");
    }

    @Override
    public AbstractPointer sub(Scalar count) {
        throw new UnsupportedOperationException("Pointer math not supported on void pointers");
    }

    @Override
    public VoidPointer subOffset(long offset) {
        return new VoidPointer(this.address - offset);
    }

    @Override
    public VoidPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        throw new UnsupportedOperationException();
    }
}

