/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.MonitorTable;
import com.ibm.j9ddr.vm26.j9.MonitorTableListIterator;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.types.U32;

public class MonitorTableList {
    protected static MonitorTable[] monitorTables;

    public static MonitorTableList from() throws CorruptDataException {
        return new MonitorTableList();
    }

    public MonitorTableListIterator iterator() throws CorruptDataException {
        if (null == monitorTables) {
            MonitorTableList.initializeMonitorTables();
        }
        return new MonitorTableListIterator(monitorTables);
    }

    public static J9ObjectMonitorPointer peek(J9ObjectPointer object) throws CorruptDataException {
        J9ObjectMonitorPointer objectMonitor;
        if (null == object || object.isNull()) {
            return J9ObjectMonitorPointer.NULL;
        }
        if (null == monitorTables) {
            MonitorTableList.initializeMonitorTables();
        }
        MonitorTable monitorTable = null;
        int index = 0;
        if (monitorTables.length > 1) {
            long hashcode;
            try {
                hashcode = new U32(ObjectModel.getObjectHashCode(object)).longValue();
            }
            catch (DataUnavailableException e) {
                throw new CorruptDataException("Hashcode unavailable");
            }
            index = (int)(hashcode % (long)monitorTables.length);
        }
        if (null == (objectMonitor = (monitorTable = monitorTables[index]).peek(object))) {
            return J9ObjectMonitorPointer.NULL;
        }
        return objectMonitor;
    }

    private static void initializeMonitorTables() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        try {
            PointerPointer cursor = vm.monitorTables();
            int count = vm.monitorTableCount().intValue();
            monitorTables = new MonitorTable[count];
            for (int i = 0; i < count; ++i) {
                MonitorTableList.monitorTables[i] = MonitorTable.from(J9HashTablePointer.cast(cursor.at(i)));
            }
        }
        catch (NoSuchFieldError e) {
            monitorTables = new MonitorTable[1];
            MonitorTableList.monitorTables[0] = MonitorTable.from(vm.monitorTable());
        }
    }
}

