/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm24.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm24.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm24.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm24.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMThreadStacks
extends Check {
    CheckVMThreadStacks() {
    }

    @Override
    public void check() {
        try {
            GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
            while (vmThreadListIterator.hasNext()) {
                J9VMThreadPointer walkThread = vmThreadListIterator.next();
                WalkState walkState = new WalkState();
                walkState.walkThread = walkThread;
                walkState.flags = J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK | J9Consts.J9_STACKWALK_SKIP_INLINES;
                walkState.callBacks = new BaseStackWalkerCallbacks(){

                    @Override
                    public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackAddress) {
                        CheckVMThreadStacks.this._engine.checkSlotStack(objectSlot, walkThread, stackAddress);
                    }
                };
                StackWalker.walkStackFrames(walkState);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "THREAD STACKS";
    }

    @Override
    public void print() {
        try {
            GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
            final ScanFormatter formatter = new ScanFormatter(this, "thread stacks");
            while (vmThreadListIterator.hasNext()) {
                J9VMThreadPointer walkThread = vmThreadListIterator.next();
                formatter.section("thread slots", walkThread);
                WalkState walkState = new WalkState();
                walkState.walkThread = walkThread;
                walkState.flags = J9Consts.J9_STACKWALK_ITERATE_O_SLOTS | J9Consts.J9_STACKWALK_DO_NOT_SNIFF_AND_WHACK | J9Consts.J9_STACKWALK_SKIP_INLINES;
                walkState.callBacks = new BaseStackWalkerCallbacks(){

                    @Override
                    public void objectSlotWalkFunction(J9VMThreadPointer walkThread, WalkState walkState, PointerPointer objectSlot, VoidPointer stackAddress) {
                        try {
                            formatter.entry(objectSlot.at(0L));
                        }
                        catch (CorruptDataException corruptDataException) {
                            // empty catch block
                        }
                    }
                };
                StackWalker.walkStackFrames(walkState);
                formatter.endSection();
                formatter.section("thread stack", walkThread);
                this.dumpStackTrace(walkThread);
                formatter.endSection();
            }
            formatter.end("thread stacks");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private void dumpStackTrace(J9VMThreadPointer walkThread) {
        WalkState walkState = new WalkState();
        walkState.walkThread = walkThread;
        walkState.flags = J9Consts.J9_STACKWALK_VISIBLE_ONLY | J9Consts.J9_STACKWALK_INCLUDE_NATIVES | J9Consts.J9_STACKWALK_ITERATE_FRAMES;
        walkState.callBacks = new BaseStackWalkerCallbacks(){

            @Override
            public FrameCallbackResult frameWalkFunction(J9VMThreadPointer walkThread, WalkState walkState) {
                String className = "(unknown class)";
                if (walkState.constantPool.notNull()) {
                    try {
                        className = J9ClassHelper.getName(walkState.constantPool.ramClass());
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                }
                if (walkState.method.isNull()) {
                    CheckVMThreadStacks.this.getReporter().println(String.format("0x%08X %s (unknown method)", walkState.pc.getAddress(), className));
                } else if (walkState.jitInfo.isNull()) {
                    boolean isNative = false;
                    U8Pointer bytecodes = U8Pointer.NULL;
                    String name = "(corrupt)";
                    String sig = "(corrupt)";
                    try {
                        J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(walkState.method);
                        isNative = romMethod.modifiers().allBitsIn(J9Consts.J9_JAVA_NATIVE);
                        if (!isNative) {
                            bytecodes = J9ROMMethodHelper.bytecodes(romMethod);
                        }
                        name = J9ROMMethodHelper.getName(romMethod);
                        sig = J9ROMMethodHelper.getSignature(romMethod);
                    }
                    catch (CorruptDataException romMethod) {
                        // empty catch block
                    }
                    if (isNative) {
                        CheckVMThreadStacks.this.getReporter().println(String.format(" NATIVE   %s.%s%s", className, name, sig));
                    } else {
                        CheckVMThreadStacks.this.getReporter().println(String.format(" %08X %s.%s%s", walkState.pc.sub(bytecodes).longValue(), className, name, sig));
                    }
                } else {
                    boolean isInlined = walkState.inlineDepth != 0L;
                    U8Pointer jitPC = walkState.pc;
                    String name = "(corrupt)";
                    String sig = "(corrupt)";
                    try {
                        J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(walkState.method);
                        name = J9UTF8Helper.stringValue(romMethod.nameAndSignature().name());
                        sig = J9UTF8Helper.stringValue(romMethod.nameAndSignature().signature());
                        if (!isInlined) {
                            jitPC = U8Pointer.cast(jitPC.sub(U8Pointer.cast(walkState.method.extra())).longValue());
                        }
                    }
                    catch (CorruptDataException corruptDataException) {
                        // empty catch block
                    }
                    if (isInlined) {
                        CheckVMThreadStacks.this.getReporter().println(String.format(" INLINED  %s.%s%s  (@%s)", className, name, sig, ScanFormatter.formatPointer(walkState.pc)));
                    } else {
                        CheckVMThreadStacks.this.getReporter().println(String.format(" %08X %s.%s%s  (@%s)", jitPC.getAddress(), className, name, sig, ScanFormatter.formatPointer(walkState.pc)));
                    }
                }
                return FrameCallbackResult.KEEP_ITERATING;
            }
        };
        StackWalker.walkStackFrames(walkState);
    }
}

