/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm24.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMSystemPropertyPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import java.util.Iterator;
import java.util.Properties;

public class J9JavaVMHelper {
    public static Properties getSystemProperties(J9JavaVMPointer vm) throws CorruptDataException {
        Properties result = new Properties();
        int count = vm.systemPropertyCount().intValue();
        J9VMSystemPropertyPointer prop = vm.systemProperties();
        for (int i = 0; i < count; ++i) {
            String name = null;
            try {
                name = prop.name().getCStringAtOffset(0L);
            }
            catch (CorruptDataException e) {
                name = "Corrupt System Property[" + i + "]";
            }
            String value = null;
            try {
                value = prop.value().getCStringAtOffset(0L);
            }
            catch (CorruptDataException e) {
                value = "Corrupt Value";
            }
            result.setProperty(name, value);
            prop = prop.add(1L);
        }
        return result;
    }

    public static J9MethodPointer getMethodFromPC(J9JavaVMPointer vmPtr, U8Pointer pc) throws CorruptDataException {
        GCClassLoaderIterator it = GCClassLoaderIterator.from();
        while (it.hasNext()) {
            J9ClassLoaderPointer loader = it.next();
            Iterator<J9ClassPointer> classIt = ClassIterator.fromJ9Classloader(loader);
            while (classIt.hasNext()) {
                J9ClassPointer clazz = classIt.next();
                J9MethodPointer result = J9ClassHelper.getMethodFromPCAndClass(clazz, pc);
                if (result.isNull()) continue;
                return result;
            }
        }
        return J9MethodPointer.NULL;
    }
}

