/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.gc.GCIterator;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizeListManagerPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizeListPointer;
import java.util.NoSuchElementException;

public class GCFinalizeListIterator
extends GCIterator {
    protected GC_FinalizeListPointer currentList;

    protected GCFinalizeListIterator(GC_FinalizeListPointer listHead) throws CorruptDataException {
        this.currentList = listHead;
    }

    public static GCFinalizeListIterator fromFinalizeList(GC_FinalizeListPointer listHead) throws CorruptDataException {
        return new GCFinalizeListIterator(listHead);
    }

    public static GCFinalizeListIterator fromFinalizeListManager(GC_FinalizeListManagerPointer manager) throws CorruptDataException {
        return new GCFinalizeListIterator(manager._head());
    }

    @Override
    public boolean hasNext() {
        return this.currentList.notNull();
    }

    @Override
    public GC_FinalizeListPointer next() {
        try {
            if (this.hasNext()) {
                GC_FinalizeListPointer next = this.currentList;
                this.currentList = this.currentList._next();
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

