/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.gc.GCClassModel;
import com.ibm.j9ddr.vm24.j9.gc.GCIterator;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import java.util.NoSuchElementException;

public class GCClassHeapIterator
extends GCIterator {
    private boolean isJIT = GCClassHeapIterator.getJavaVM().jitConfig().notNull();
    private U8Pointer scanPointer;
    J9MemorySegmentPointer memorySegment;
    private GCClassModel classModel;

    protected GCClassHeapIterator(J9MemorySegmentPointer memorySegment) throws CorruptDataException {
        this.memorySegment = memorySegment;
        this.classModel = GCClassModel.from();
        this.scanPointer = memorySegment.heapBase();
    }

    public static GCClassHeapIterator fromJ9MemorySegment(J9MemorySegmentPointer memorySegment) throws CorruptDataException {
        return new GCClassHeapIterator(memorySegment);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.scanPointer.lt(this.memorySegment.heapAlloc());
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error determining location within heap", cde, true);
            return false;
        }
    }

    @Override
    public J9ClassPointer next() {
        try {
            if (this.hasNext()) {
                if (J9BuildFlags.interp_nativeSupport && this.isJIT) {
                    this.scanPointer = this.scanPointer.add(UDATAPointer.cast(this.scanPointer).at(0L));
                }
                J9ClassPointer clazz = J9ClassPointer.cast(this.scanPointer);
                this.scanPointer = this.scanPointer.add(this.classModel.getSizeInBytes(clazz));
                return clazz;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Could not set the current class", cde, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

