/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class J9DDRImage
implements ManagedImage {
    private final ICore coreFile;
    private J9RASImageDataFactory.MachineData j9MachineData;
    private boolean machineDataSet = false;
    private final URI source;
    private ManagedImageSource imageSource = null;
    private final ImageInputStream meta;
    private boolean closed = false;

    public J9DDRImage(ICore coreFile) {
        this(null, coreFile, null);
    }

    public J9DDRImage(URI source, ICore coreFile, ImageInputStream meta) {
        this.coreFile = coreFile;
        this.source = source;
        this.meta = meta;
        if (coreFile instanceof ILibraryDependentCore) {
            this.passBackExecutablePath((ILibraryDependentCore)coreFile);
        }
    }

    public ICore getCore() {
        return this.coreFile;
    }

    public URI getSource() {
        return this.source;
    }

    private void passBackExecutablePath(ILibraryDependentCore core) {
        Iterator<J9DDRImageAddressSpace> addressSpacesIt = this.getAddressSpaces();
        while (addressSpacesIt.hasNext()) {
            J9DDRImageAddressSpace thisAS = addressSpacesIt.next();
            J9DDRImageProcess proc = thisAS.getCurrentProcess();
            String executablePath = proc.getExecutablePath();
            if (executablePath == null) continue;
            core.executablePathHint(executablePath);
        }
    }

    private void checkJ9RASMachineData() {
        if (!this.machineDataSet) {
            this.j9MachineData = J9RASImageDataFactory.getMachineData(this.coreFile);
            this.machineDataSet = true;
        }
    }

    public Iterator<J9DDRImageAddressSpace> getAddressSpaces() {
        Collection<? extends IAddressSpace> addressSpaces = this.coreFile.getAddressSpaces();
        LinkedList<J9DDRImageAddressSpace> dtfjList = new LinkedList<J9DDRImageAddressSpace>();
        for (IAddressSpace iAddressSpace : addressSpaces) {
            dtfjList.add(new J9DDRImageAddressSpace(iAddressSpace));
        }
        return dtfjList.iterator();
    }

    public long getCreationTime() throws DataUnavailable {
        Properties prop;
        String result;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.dumpTimeMillis();
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        if ((result = (prop = this.coreFile.getProperties()).getProperty("core.creation.time")) != null) {
            return Long.parseLong(result);
        }
        throw new DataUnavailable();
    }

    public String getHostName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.hostName();
            }
            catch (CorruptDataException e) {
                throw new DataUnavailable();
            }
            catch (DataUnavailableException e) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public Iterator<?> getIPAddresses() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.ipaddresses();
            }
            catch (CorruptDataException e) {
                throw new DataUnavailable();
            }
            catch (DataUnavailableException e) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public long getInstalledMemory() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.memoryBytes();
            }
            catch (CorruptDataException e) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public int getProcessorCount() throws DataUnavailable {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.cpus();
            }
            catch (CorruptDataException e) {
                throw new DataUnavailable();
            }
        }
        throw new DataUnavailable();
    }

    public String getProcessorSubType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties prop = this.coreFile.getProperties();
        String result = prop.getProperty("cpu.subtype");
        if (result != null) {
            return result;
        }
        throw new DataUnavailable();
    }

    public String getProcessorType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osArch();
            }
            catch (CorruptDataException e) {
                throw new DTFJCorruptDataException(this.j9MachineData.getProcess(), e);
            }
        }
        Properties prop = this.coreFile.getProperties();
        String result = prop.getProperty("cpu.type");
        if (result != null) {
            return result;
        }
        throw new DataUnavailable();
    }

    public String getSystemSubType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties prop;
        String result;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osVersion();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        if ((result = (prop = this.coreFile.getProperties()).getProperty("system.subtype")) != null) {
            return result;
        }
        throw new DataUnavailable();
    }

    public String getSystemType() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties prop;
        String result;
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.osName();
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
        if ((result = (prop = this.coreFile.getProperties()).getProperty("system.type")) != null) {
            return result;
        }
        throw new DataUnavailable();
    }

    public void close() {
        this.closed = true;
        try {
            this.coreFile.close();
            if (this.meta != null) {
                this.meta.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
            if (this.imageSource.hasMetaData() && this.imageSource.getMetadata().getExtractedTo() != null) {
                this.imageSource.getMetadata().getExtractedTo().delete();
            }
        }
    }

    public Properties getProperties() {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.systemInfo();
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        return new Properties();
    }

    public boolean isTruncated() {
        if (this.coreFile == null) {
            return true;
        }
        return this.coreFile.isTruncated();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof J9DDRImage)) {
            return false;
        }
        J9DDRImage compareto = (J9DDRImage)o;
        return this.source.equals(compareto.source);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(ManagedImageSource source) {
        this.imageSource = source;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getCreationTimeNanos() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkJ9RASMachineData();
        if (this.j9MachineData != null) {
            try {
                return this.j9MachineData.dumpTimeNanos();
            }
            catch (CorruptDataException e) {
                throw new DTFJCorruptDataException(this.j9MachineData.getProcess(), e);
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
        throw new DataUnavailable();
    }
}

