/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.util;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PatternString
implements Serializable {
    private static final long serialVersionUID = 3257289149408162611L;
    private boolean isRegularString;
    private boolean alwaysMatches;
    final String pattern;
    final String[] tokens;
    public static final char wildCard = '*';
    public static final char singleCharWildCard = '?';
    private static int[] nullArray = new int[0];
    public static final PatternString ALWAYS_MATCHES = new PatternString(String.valueOf('*'));
    private MatchState savedState = new MatchState();

    public PatternString(String pattern) {
        this.pattern = pattern;
        if (pattern.equals(String.valueOf('*'))) {
            this.alwaysMatches = true;
            this.tokens = null;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(pattern, String.valueOf('*') + '?', true);
        LinkedList<String> tokenList = new LinkedList<String>();
        this.isRegularString = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.isRegularString) {
                switch (token.charAt(0)) {
                    case '*': 
                    case '?': {
                        this.isRegularString = false;
                    }
                }
            }
            tokenList.add(token);
        }
        this.tokens = tokenList.toArray(new String[tokenList.size()]);
    }

    int indexOfWildcard() {
        if (this.isRegularString) {
            return -1;
        }
        if (this.alwaysMatches) {
            return 0;
        }
        int index = 0;
        for (int i = 0; i < this.tokens.length; ++i) {
            String token = this.tokens[i];
            switch (token.charAt(0)) {
                case '*': 
                case '?': {
                    return index;
                }
            }
            index += token.length();
        }
        return -1;
    }

    public PatternStringPair split(int index) {
        char c = this.pattern.charAt(index);
        if (c == '*') {
            return new PatternStringPair(this.pattern.substring(0, index + 1), this.pattern.substring(index));
        }
        return new PatternStringPair(this.pattern.substring(0, index), this.pattern.substring(index + 1));
    }

    public int[] indexOf(int c) {
        int totalLocations;
        int[] results = new int[this.pattern.length()];
        int index = this.pattern.indexOf(c);
        if (index == -1) {
            totalLocations = this.findAdditionalLocations(results, this.pattern, c, true);
        } else {
            totalLocations = this.findAdditionalLocations(results, this.pattern.substring(0, index), c, true);
            results[totalLocations++] = index;
        }
        if (totalLocations == 0) {
            return nullArray;
        }
        if (totalLocations == this.pattern.length()) {
            return results;
        }
        int[] newResults = new int[totalLocations];
        System.arraycopy(results, 0, newResults, 0, totalLocations);
        return newResults;
    }

    private int findAdditionalLocations(int[] results, String sub, int c, boolean forward) {
        int resultIndex = 0;
        int len = sub.length();
        for (int i = 0; i < len; ++i) {
            int j = forward ? i : len - i - 1;
            char ch = sub.charAt(j);
            if (ch != '*' && ch != '?') continue;
            results[resultIndex++] = j;
        }
        return resultIndex;
    }

    public int[] lastIndexOf(int c) {
        int totalLocations;
        int maxResults = this.pattern.length();
        int[] results = new int[maxResults];
        int index = this.pattern.lastIndexOf(c);
        if (index == -1) {
            totalLocations = this.findAdditionalLocations(results, this.pattern, c, false);
        } else {
            int offset = index + 1;
            totalLocations = this.findAdditionalLocations(results, this.pattern.substring(offset), c, false);
            int i = 0;
            while (i < totalLocations) {
                int n = i++;
                results[n] = results[n] + offset;
            }
            results[totalLocations++] = index;
        }
        if (totalLocations == 0) {
            return nullArray;
        }
        if (totalLocations == maxResults) {
            return results;
        }
        int[] newResults = new int[totalLocations];
        System.arraycopy(results, 0, newResults, 0, totalLocations);
        return newResults;
    }

    public boolean isRegularString() {
        return this.isRegularString;
    }

    public static boolean isWildcard(char c) {
        return c == '*' || c == '?';
    }

    public boolean endsWith(String string) {
        String reversePattern = new StringBuffer(this.pattern).reverse().toString();
        String reverseString = new StringBuffer(string).reverse().toString();
        return new PatternString(reversePattern).startsWith(reverseString);
    }

    public boolean isMatch(String string) {
        return this.alwaysMatches || (this.isRegularString ? this.pattern.equals(string) : this.isMatch(string, false));
    }

    public boolean startsWith(String string) {
        return this.alwaysMatches || (this.isRegularString ? this.pattern.startsWith(string) : this.isMatch(string, true));
    }

    private boolean isMatch(String string, boolean startsWith) {
        this.savedState.reset();
        return this.isMatch(string, 0, startsWith, 0, this.savedState);
    }

    private boolean isMatch(String string, int stringStartIndex, boolean startsWith, int startTokenIndex, MatchState state) {
        for (int i = startTokenIndex; i < this.tokens.length; ++i) {
            int nextIndex;
            if (startsWith && state.matchesRemainder(string, stringStartIndex)) {
                return true;
            }
            String currentToken = this.tokens[i];
            char c = currentToken.charAt(0);
            if (PatternString.isWildcard(c)) {
                state.matchWildcard(currentToken.charAt(0));
                continue;
            }
            int stringTokenIndex = state.matchToken(string, stringStartIndex, stringStartIndex, currentToken);
            if (stringTokenIndex < 0) {
                if (startsWith) {
                    return state.startsWithRemainder(string, stringStartIndex, currentToken);
                }
                return false;
            }
            int searchIndex = stringTokenIndex + 1;
            while ((nextIndex = state.matchToken(string, stringStartIndex, searchIndex, currentToken)) >= 0) {
                MatchState newState = (MatchState)state.clone();
                newState.reset();
                if (this.isMatch(string, nextIndex + currentToken.length(), startsWith, i + 1, newState)) {
                    return true;
                }
                searchIndex = nextIndex + 1;
            }
            state.reset();
            stringStartIndex = stringTokenIndex + currentToken.length();
        }
        return state.matchesRemainder(string, stringStartIndex);
    }

    public String toString() {
        return this.pattern;
    }

    class MatchState
    implements Cloneable {
        boolean onWildCard;
        boolean onSingleCharWildCard;
        int numChars;

        MatchState() {
        }

        void reset() {
            this.onSingleCharWildCard = false;
            this.onWildCard = false;
            this.numChars = 0;
        }

        boolean matchesRemainder(String string, int stringStartIndex) {
            return string.length() == stringStartIndex + this.numChars || this.onWildCard && string.length() >= stringStartIndex + this.numChars;
        }

        void matchWildcard(char c) {
            switch (c) {
                case '*': {
                    this.onWildCard = true;
                    return;
                }
                case '?': {
                    this.onSingleCharWildCard = true;
                    ++this.numChars;
                    return;
                }
            }
        }

        boolean startsWithRemainder(String string, int stringStartIndex, String token) {
            String remainderToMatch = string.substring(stringStartIndex + this.numChars);
            return token.startsWith(remainderToMatch);
        }

        int matchToken(String string, int stringStartIndex, int searchIndex, String token) {
            int index;
            if (this.onSingleCharWildCard) {
                searchIndex = Math.max(stringStartIndex + this.numChars, searchIndex);
            }
            if ((index = string.indexOf(token, searchIndex)) < 0) {
                return -1;
            }
            switch (index - stringStartIndex) {
                default: {
                    if (this.onWildCard || this.onSingleCharWildCard && stringStartIndex + this.numChars == index) break;
                    return -1;
                }
                case 0: 
            }
            return index;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    public static class PatternStringPair {
        public final PatternString first;
        public final PatternString second;

        PatternStringPair(PatternString first, PatternString second) {
            this.first = first;
            this.second = second;
        }

        PatternStringPair(String first, String second) {
            this(new PatternString(first), new PatternString(second));
        }
    }
}

