/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.SortListener;
import java.io.Serializable;
import java.util.Random;
import javax.swing.ProgressMonitor;

public abstract class PrimitiveArray
implements Serializable,
SortListener {
    int shift = 12;
    int CHUNK_SIZE = 1 << this.shift;
    int mask = this.CHUNK_SIZE - 1;
    int chunkOffset;
    SortListener listener;
    int size;
    int progress;
    int maxProgress;
    ProgressMonitor monitor;
    Random random = new Random(-4611175785791833410L);
    static final int[] log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public int size() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    abstract long lget(int var1);

    abstract void lput(int var1, long var2);

    public int indexOf(long value) {
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = this.lget(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int nearestIndexOf(long value) {
        int low = 0;
        int high = this.size - 1;
        int mid = 0;
        long midVal = 0L;
        while (low <= high) {
            mid = low + high >> 1;
            midVal = this.lget(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        if (value > midVal) {
            return mid;
        }
        if (mid > 0) {
            return mid - 1;
        }
        return -1;
    }

    public int indexOf(int value) {
        return this.indexOf((long)value);
    }

    public void sort(ProgressMonitor monitor) {
        this.monitor = monitor;
        this.sort();
        this.monitor = null;
    }

    public void sort(SortListener listener, ProgressMonitor monitor) {
        this.monitor = monitor;
        this.sort(listener);
        this.monitor = null;
    }

    public void sort() {
        this.sort((SortListener)null);
    }

    public void reverseSort() {
        this.reverseSort(null);
    }

    public void sort(SortListener listener) {
        this.listener = listener;
        if (this.monitor != null) {
            this.maxProgress = this.size / 2;
            this.monitor.setMaximum(this.maxProgress);
        }
        this.quickSort(0, this.size - 1);
        this.listener = null;
    }

    public void reverseSort(SortListener listener) {
        this.listener = listener;
        this.quickSort(0, this.size - 1);
        int i = 0;
        for (int j = this.size - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
        this.listener = null;
    }

    @Override
    public void swap(int a, int b) {
        long t = this.lget(a);
        this.lput(a, this.lget(b));
        this.lput(b, t);
        if (this.listener != null) {
            this.listener.swap(a, b);
        }
    }

    void quickSort(int p, int r) {
        if (this.monitor != null) {
            if (this.progress % 256 == 0) {
                this.monitor.setProgress(this.progress);
            }
            ++this.progress;
        }
        if (r - p < 7) {
            for (int i = p; i <= r; ++i) {
                for (int j = i; j > p && this.lget(j - 1) > this.lget(j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        if (p < r) {
            int q = this.randomPartition(p, r);
            this.quickSort(p, q);
            this.quickSort(q + 1, r);
        }
    }

    int randomPartition(int p, int r) {
        int i = this.random.nextInt(r - p + 1) + p;
        this.swap(p, i);
        return this.partition(p, r);
    }

    int partition(int p, int r) {
        long x = this.lget(p);
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (this.lget(--j) > x) {
                continue;
            }
            while (this.lget(++i) < x) {
            }
            if (i >= j) break;
            this.swap(i, j);
        }
        return j;
    }

    static int log2(int n) {
        int bit = 0;
        while ((n & 0xFFFFFF00) != 0) {
            bit += 8;
            n >>>= 8;
        }
        return bit + log2bytes[n];
    }
}

