/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ClosingFileReader;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.CorruptCoreException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.minidump.EarlyInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.Memory64Stream;
import com.ibm.j9ddr.corereaders.minidump.MemoryInfoStream;
import com.ibm.j9ddr.corereaders.minidump.MiscInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ModuleStream;
import com.ibm.j9ddr.corereaders.minidump.SystemInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ThreadInfoStream;
import com.ibm.j9ddr.corereaders.minidump.ThreadStream;
import com.ibm.j9ddr.corereaders.minidump.WindowsProcessAddressSpace;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class MiniDumpReader
extends AbstractCoreReader
implements ICoreFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final int INFO_BLOCK_ADDRESS = 131072;
    private static final int COMMAND_LINE_ADDRESS_ADDRESS_32 = 131140;
    private static final int COMMAND_LINE_ADDRESS_ADDRESS_64 = 131192;
    private static final int COMMAND_LINE_LENGTH_ADDRESS_32 = 131136;
    private static final int COMMAND_LINE_LENGTH_ADDRESS_64 = 131184;
    public static final String WINDOWS_BUILDNO_PROPERTY = "os.windows.buildno";
    private int _numberOfStreams = 0;
    private long _streamDirectoryRva = 0L;
    private short _processorArchitecture = 0;
    private int _windowsMajorVersion = 0;
    private Set<String> _additionalFileNames = new TreeSet<String>();
    private int _pid;
    private final Properties properties = new Properties();
    private List<LateInitializedStream> threadStreams = new LinkedList<LateInitializedStream>();
    private List<ThreadInfoStream> threadInfoStreams = new LinkedList<ThreadInfoStream>();
    private List<MemoryInfoStream> memoryInfoStreams = new LinkedList<MemoryInfoStream>();
    private List<LateInitializedStream> moduleStreams = new LinkedList<LateInitializedStream>();
    private boolean modulesRead = false;
    private List<IModule> modules;
    private IModule executable;
    private List<IOSThread> threads;
    private List<IAddressSpace> addressSpaces;
    private static boolean _is64bit = false;

    public ICore processDump(File file) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        this.coreFile = file;
        ClosingFileReader fileReader = new ClosingFileReader(file, ByteOrder.LITTLE_ENDIAN);
        if (!MiniDumpReader.isMiniDump(fileReader)) {
            throw new InvalidDumpFormatException("The file " + file.getAbsolutePath() + " is not a valid MiniDump file.");
        }
        this.setReader(fileReader);
        return this;
    }

    @Override
    public ICore processDump(ImageInputStream in) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.coreFile = null;
        if (!MiniDumpReader.isMiniDump(in)) {
            throw new InvalidDumpFormatException("The passed input stream is not a valid MiniDump file.");
        }
        this.setReader(in);
        return this;
    }

    public boolean validDump(byte[] data, long filesize) {
        try {
            return new String(data, 0, 4, "UTF-8").equalsIgnoreCase("mdmp");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    @Override
    public ICore processDump(String path) throws FileNotFoundException, InvalidDumpFormatException, IOException {
        File file;
        this.coreFile = file = new File(path);
        ClosingFileReader fileReader = new ClosingFileReader(file, ByteOrder.LITTLE_ENDIAN);
        if (!MiniDumpReader.isMiniDump(fileReader)) {
            throw new InvalidDumpFormatException("The file " + file.getAbsolutePath() + " is not a valid MiniDump file.");
        }
        this.setReader(fileReader);
        return this;
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(String path) throws IOException {
        if (!new File(path).exists()) {
            return ICoreFileReader.DumpTestResult.FILE_NOT_FOUND;
        }
        byte[] header = CoreReader.getFileHeader(path);
        try {
            return new String(header, 0, 4, "ASCII").equalsIgnoreCase("mdmp") ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICoreFileReader.DumpTestResult testDump(ImageInputStream in) throws IOException {
        byte[] header = CoreReader.getFileHeader(in);
        try {
            return new String(header, 0, 4, "ASCII").equalsIgnoreCase("mdmp") ? ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT : ICoreFileReader.DumpTestResult.UNRECOGNISED_FORMAT;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setReader(ImageInputStream reader) throws IOException {
        reader.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        super.setReader(reader);
        try {
            this.readCore();
        }
        catch (CorruptCoreException e) {
            throw new IOException("Failed to read the core : " + e.getMessage());
        }
    }

    private void readCore() throws IOException, CorruptCoreException {
        this.parseHeader();
        this.parseStreams();
    }

    private void parseHeader() throws IOException {
        this.seek(0L);
        this.readBytes(4);
        this.readInt();
        this._numberOfStreams = this.readInt();
        this._streamDirectoryRva = this.readInt();
        this.readInt();
        int timeAndDate = this.readInt();
        this.properties.setProperty("core.creation.time", Long.toString((long)timeAndDate * 1000L));
    }

    private void parseStreams() throws IOException, CorruptCoreException {
        this.seek(this._streamDirectoryRva);
        LinkedList<EarlyInitializedStream> earlyStreams = new LinkedList<EarlyInitializedStream>();
        block11: for (int i = 0; i < this._numberOfStreams; ++i) {
            int streamType = this.readInt();
            int dataSize = this.readInt();
            int location = this.readInt();
            switch (streamType) {
                case 3: {
                    this.threadStreams.add(new ThreadStream(dataSize, location));
                    continue block11;
                }
                case 4: {
                    this.moduleStreams.add(new ModuleStream(dataSize, location));
                    continue block11;
                }
                case 7: {
                    earlyStreams.add(0, new SystemInfoStream(dataSize, location));
                    continue block11;
                }
                case 9: {
                    earlyStreams.add(new Memory64Stream(dataSize, location));
                    continue block11;
                }
                case 15: {
                    earlyStreams.add(new MiscInfoStream(dataSize, location));
                    continue block11;
                }
                case 17: {
                    this.threadInfoStreams.add(new ThreadInfoStream(dataSize, location));
                    continue block11;
                }
                case 16: {
                    this.memoryInfoStreams.add(new MemoryInfoStream(dataSize, location));
                }
            }
        }
        for (EarlyInitializedStream entry : earlyStreams) {
            entry.readFrom(this);
            int ptrSize = entry.readPtrSize(this);
            if (0 == ptrSize) continue;
            _is64bit = ptrSize == 64;
        }
        for (MemoryInfoStream entry : this.memoryInfoStreams) {
            entry.readFrom(this, this.is64Bit(), this._memoryRanges);
        }
        if (_is64bit) {
            int wowCount = 0;
            for (IModule module : this.getModules()) {
                try {
                    String modName = module.getName().toLowerCase();
                    if (!modName.contains("syswow64")) continue;
                    ++wowCount;
                }
                catch (CorruptDataException corruptDataException) {}
            }
            if (wowCount > 5) {
                _is64bit = false;
                this.addressSpaces = null;
            }
        }
    }

    String getCommandLine() throws CorruptDataException, DataUnavailableException {
        if (this._windowsMajorVersion >= 6) {
            throw new DataUnavailableException("Command line not available from Windows core dump");
        }
        String commandLine = null;
        try {
            long commandAddress;
            short length;
            IMemory memory = this.getMemory();
            if (this.is64Bit()) {
                length = memory.getShortAt(131184L);
                commandAddress = memory.getLongAt(131192L);
            } else {
                length = memory.getShortAt(131136L);
                commandAddress = 0xFFFFFFFF & memory.getIntAt(131140L);
            }
            if (commandAddress == 0L) {
                throw new DataUnavailableException("Command line not in core file");
            }
            byte[] buf = new byte[length];
            memory.getBytesAt(commandAddress, buf);
            commandLine = new String(buf, "UTF-16LE");
            return commandLine;
        }
        catch (Exception e) {
            throw new CorruptDataException("Failed to read command line from core file", e);
        }
    }

    private static boolean isMiniDump(ImageInputStream f) throws IOException {
        f.seek(0L);
        byte[] signature = new byte[4];
        f.readFully(signature);
        return new String(signature, "UTF-8").equalsIgnoreCase("mdmp");
    }

    public boolean is64Bit() {
        return _is64bit;
    }

    protected void setProcessorArchitecture(short processorArchitecture, String procSubtype, int numberOfProcessors) {
        this._processorArchitecture = processorArchitecture;
        this.properties.setProperty("cpu.count", Integer.toString(numberOfProcessors));
        if (processorArchitecture == 0) {
            this.properties.setProperty("cpu.type", "x86");
        } else if (processorArchitecture == 9) {
            this.properties.setProperty("cpu.type", "AMD64");
        } else {
            this.properties.setProperty("cpu.type", "Unknown: " + processorArchitecture);
        }
        this.properties.setProperty("cpu.subtype", procSubtype);
    }

    protected void setWindowsType(byte type2, int major, int minor, int buildNo) {
        this._windowsMajorVersion = major;
        this.properties.setProperty("system.type", this.decodeWindowsVersionNumber(major, minor, buildNo, type2));
        this.properties.setProperty("system.subtype", major + "." + minor + " build " + buildNo);
        this.properties.setProperty(WINDOWS_BUILDNO_PROPERTY, Integer.toString(buildNo));
    }

    private String decodeWindowsVersionNumber(int major, int minor, int buildNo, byte productType) {
        switch (major) {
            case 5: {
                switch (minor) {
                    case 0: {
                        return "Windows 2000";
                    }
                    case 1: {
                        return "Windows XP";
                    }
                    case 2: {
                        return "Windows Server 2003";
                    }
                }
                break;
            }
            case 6: {
                switch (minor) {
                    case 0: {
                        switch (productType) {
                            case 1: {
                                return "Windows Vista";
                            }
                            case 3: {
                                return "Windows Server 2008";
                            }
                        }
                    }
                    case 1: {
                        switch (productType) {
                            case 1: {
                                return "Windows 7";
                            }
                            case 3: {
                                return "Windows Server 2008 R2";
                            }
                        }
                    }
                }
            }
        }
        return "Unknown Windows variant: " + major + "." + minor + "." + buildNo + " type " + productType;
    }

    public void setProcessID(int pid) {
        this._pid = pid;
    }

    public void addModule(String moduleName) {
        this._additionalFileNames.add(moduleName);
    }

    protected short getProcessorArchitecture() {
        return this._processorArchitecture;
    }

    protected void setMemorySources(Collection<? extends IMemorySource> ranges) {
        this._memoryRanges = ranges;
    }

    @Override
    public String getDumpFormat() {
        return "minidump";
    }

    public List<IAddressSpace> getAddressSpaces() {
        if (null == this.addressSpaces) {
            WindowsProcessAddressSpace addressSpace = new WindowsProcessAddressSpace(this.is64Bit() ? 8 : 4, ByteOrder.LITTLE_ENDIAN, this);
            addressSpace.addMemorySources(this._memoryRanges);
            this.addressSpaces = new ArrayList<IAddressSpace>(1);
            this.addressSpaces.add(addressSpace);
        }
        return this.addressSpaces;
    }

    private IMemory getMemory() {
        return (IMemory)this.getAddressSpaces().get(0);
    }

    @Override
    public Platform getPlatform() {
        return Platform.WINDOWS;
    }

    public IModule getExecutable() {
        this.readModulesInfo();
        return this.executable;
    }

    public List<IModule> getModules() {
        this.readModulesInfo();
        return this.modules;
    }

    private void readModulesInfo() {
        if (!this.modulesRead) {
            this.modules = new LinkedList<IModule>();
            for (LateInitializedStream stream : this.moduleStreams) {
                try {
                    stream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit());
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "readModulesInfo", "Problem processing module stream", ex);
                }
            }
            this.modulesRead = true;
        }
    }

    void setExecutable(IModule module) {
        this.executable = module;
    }

    void addLibrary(IModule module) {
        this.modules.add(module);
    }

    public int getPid() {
        return this._pid;
    }

    public List<IOSThread> getThreads() {
        if (this.threads == null) {
            this.threads = new LinkedList<IOSThread>();
            for (LateInitializedStream lateInitializedStream : this.threadStreams) {
                try {
                    lateInitializedStream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit());
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "getThreads", "Problem processing thread stream", ex);
                }
            }
            for (ThreadInfoStream threadInfoStream : this.threadInfoStreams) {
                try {
                    threadInfoStream.readFrom(this, (IAddressSpace)this.getAddressSpaces().get(0), this.is64Bit(), this.threads);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    logger.logp(Level.WARNING, "MiniDumpReader", "getThreads", "Problem processing thread info stream", ex);
                }
            }
        }
        return Collections.unmodifiableList(this.threads);
    }

    void addThread(IOSThread thread) {
        this.threads.add(thread);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

