/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class IMemoryImageInputStream
extends ImageInputStreamImpl {
    private final IMemory memory;
    private long address;

    public IMemoryImageInputStream(IMemory memory, long startingAddress) {
        this.memory = memory;
        this.address = startingAddress;
        this.setByteOrder(memory.getByteOrder());
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = 0;
        try {
            read = this.memory.getBytesAt(this.address, buffer, offset, length);
        }
        catch (MemoryFault f) {
            if (f.getAddress() == this.address) {
                return -1;
            }
            read = (int)(f.getAddress() - this.address);
        }
        this.address += (long)read;
        return read;
    }

    @Override
    public int read() throws IOException {
        int toReturn = 0;
        try {
            toReturn = 0xFF & this.memory.getByteAt(this.address);
        }
        catch (MemoryFault e) {
            return -1;
        }
        ++this.address;
        return toReturn;
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.address;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.address = pos;
    }
}

