/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class SymtabCommand
extends LoadCommand {
    int symtabOffset;
    int numSymbols;
    int stringsOffset;
    int stringsSize;
    List<SymtabEntry64> entries;
    byte[] stringsBytes;
    List<String> strings;

    @Override
    public SymtabCommand readCommand(ImageInputStream stream, long streamSegmentOffset) throws IOException {
        super.readCommand(stream, streamSegmentOffset);
        this.symtabOffset = stream.readInt();
        this.numSymbols = stream.readInt();
        this.stringsOffset = stream.readInt();
        this.stringsSize = stream.readInt();
        this.stringsBytes = null;
        return this;
    }

    public void readSymbolTable(ImageInputStream stream) throws IOException {
        int i;
        stream.seek((long)this.symtabOffset + this.segmentOffset);
        this.entries = new ArrayList<SymtabEntry64>(this.numSymbols);
        for (i = 0; i < this.numSymbols; ++i) {
            SymtabEntry64 entry = new SymtabEntry64();
            entry.strIndex = stream.readInt();
            entry.nType = stream.readByte();
            entry.nSect = stream.readByte();
            entry.nDesc = stream.readShort();
            entry.nValue = stream.readLong();
            this.entries.add(entry);
        }
        stream.seek((long)this.stringsOffset + this.segmentOffset);
        this.strings = new ArrayList<String>();
        this.stringsBytes = new byte[this.stringsSize];
        stream.readFully(this.stringsBytes);
        i = 0;
        while (i < this.stringsBytes.length) {
            int j;
            for (j = i; j < this.stringsBytes.length && this.stringsBytes[j] != 0; ++j) {
            }
            String stringEntry = new String(this.stringsBytes, i, j - i, StandardCharsets.US_ASCII);
            this.strings.add(stringEntry);
            i = j + 1;
        }
    }

    public static class SymtabEntry64 {
        int strIndex;
        byte nType;
        byte nSect;
        short nDesc;
        long nValue;
        public static final int N_UNDF = 0;
        public static final int N_ABS = 2;
        public static final int N_SECT = 14;
        public static final int N_PBUD = 12;
        public static final int N_INDR = 10;
        public static final int REFERENCE_FLAG_UNDEFINED_NON_LAZY = 0;
        public static final int REFERENCE_FLAG_UNDEFINED_LAZY = 1;
        public static final int REFERENCE_FLAG_DEFINED = 2;
        public static final int REFERENCE_FLAG_PRIVATE_DEFINED = 3;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_NON_LAZY = 4;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_LAZY = 5;

        public boolean isStab() {
            return 0 != (this.nType & 0xFFFFFFE0);
        }

        public byte getStab() {
            return (byte)(this.nType & 0xFFFFFFE0);
        }

        public boolean isPrivateExternal() {
            return 0 != (this.nType & 0x10);
        }

        public byte getType() {
            return (byte)(this.nType & 0xE);
        }

        public boolean isExternal() {
            return 0 != (this.nType & 1);
        }

        public int getCommonAlignment() {
            return this.nDesc >>> 8 & 0xF;
        }

        public int getReferenceType() {
            return this.nDesc & 7;
        }
    }
}

