/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.LibraryResolverFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFAArch64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFAMD64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFARM32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFIA32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFPPC32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFPPC64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFRISCV64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFS39031DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFS39064DumpReader;
import com.ibm.j9ddr.corereaders.elf.LinuxProcessAddressSpace;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.MissingFileModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public abstract class ELFDumpReader
implements ILibraryDependentCore {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    public static final String USELOADEDLIBRARIES = "com.ibm.j9ddr.corereaders.elf.ELFDumpReader.USELOADEDLIBRARIES";
    public static final String KNOWNLIBPATHS_PROPERTY = "com.ibm.j9ddr.corereaders.elf.ELFDumpReader.KNOWNLIBPATHS";
    public static final String[] KNOWNLIBPATHS_DEFAULT_32 = new String[]{"/lib", "/usr/lib", "/usr/local/lib"};
    public static final String[] KNOWNLIBPATHS_DEFAULT_64 = new String[]{"/lib64", "/usr/lib64", "/usr/local/lib64"};
    private static final String[] KNOWNLIBPATHSGLOBAL;
    private final String[] knownLibPaths;
    protected final ELFFileReader _reader;
    protected final LinuxProcessAddressSpace _process;
    protected final ILibraryResolver _resolver;
    private final List<DataEntry> _processEntries = new ArrayList<DataEntry>();
    private final List<DataEntry> _threadEntries = new ArrayList<DataEntry>();
    private final List<DataEntry> _auxiliaryVectorEntries = new ArrayList<DataEntry>();
    private final List<DataEntry> _highwordRegisterEntries = new ArrayList<DataEntry>();
    private int _pid;
    private String _executableFileName;
    private String _commandLine;
    private String _executablePathOverride;
    private int _signalNumber = -1;
    private IModule _executable;
    private List<IModule> _modules;
    private CorruptDataException _modulesException;
    private long _platformIdAddress;
    private boolean useLoadedLibraries;
    private ArrayList<ELFFileReader> openFileTracker = new ArrayList();
    private Unwind unwinder;

    protected ELFDumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        this._reader = reader;
        this._process = new LinuxProcessAddressSpace(this._reader.addressSizeBits() / 8, this._reader.getByteOrder(), this);
        this.unwinder = new Unwind(this._process);
        this._resolver = reader.getFile() == null ? LibraryResolverFactory.getResolverForCoreFile(reader.getStream()) : LibraryResolverFactory.getResolverForCoreFile(reader.getFile());
        boolean bl = this.useLoadedLibraries = System.getProperty(USELOADEDLIBRARIES) != null;
        this.knownLibPaths = KNOWNLIBPATHSGLOBAL != null ? KNOWNLIBPATHSGLOBAL : (this._reader.is64Bit() ? KNOWNLIBPATHS_DEFAULT_64 : KNOWNLIBPATHS_DEFAULT_32);
        this.processProgramHeader();
        this.processAuxiliaryHeader();
        this.readProcessData();
        try {
            this._executablePathOverride = System.getProperty("com.ibm.j9ddr.corereaders.exepath");
            this.readModules();
        }
        catch (Exception e) {
            this._modulesException = new CorruptDataException(e);
        }
    }

    @Override
    public boolean isTruncated() {
        return this._reader.isTruncated();
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
        if (this._executable instanceof ELFFileReader) {
            ((ELFFileReader)((Object)this._executable)).is.close();
        }
        for (IModule module : this._modules) {
            if (!(module instanceof ELFFileReader)) continue;
            ((ELFFileReader)((Object)module)).is.close();
        }
        for (ELFFileReader reader : this.openFileTracker) {
            if (reader == null) continue;
            reader.close();
        }
        this._resolver.dispose();
    }

    public static ELFDumpReader getELFDumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        switch (reader.getMachineType()) {
            case 3: {
                return new ELFIA32DumpReader(reader);
            }
            case 62: {
                return new ELFAMD64DumpReader(reader);
            }
            case 20: {
                return new ELFPPC32DumpReader(reader);
            }
            case 21: {
                return new ELFPPC64DumpReader(reader);
            }
            case 22: {
                if (reader.is64Bit()) {
                    return new ELFS39064DumpReader(reader);
                }
                return new ELFS39031DumpReader(reader);
            }
            case 40: {
                return new ELFARM32DumpReader(reader);
            }
            case 183: {
                return new ELFAArch64DumpReader(reader);
            }
            case 243: {
                return new ELFRISCV64DumpReader(reader);
            }
        }
        throw new IOException("Unrecognised machine type: " + reader.getMachineType());
    }

    public static ELFDumpReader getELFDumpReader(File file) throws IOException, InvalidDumpFormatException {
        ELFFileReader reader = ELFFileReader.getELFFileReader(file);
        return ELFDumpReader.getELFDumpReader(reader);
    }

    public static ELFDumpReader getELFDumpReader(ImageInputStream in) throws IOException, InvalidDumpFormatException {
        ELFFileReader reader = ELFFileReader.getELFFileReader(in);
        return ELFDumpReader.getELFDumpReader(reader);
    }

    public List<IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public String getDumpFormat() {
        return "ELF";
    }

    @Override
    public Platform getPlatform() {
        return Platform.LINUX;
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("system.type", "Linux");
        props.setProperty("cpu.type", this.getProcessorType());
        props.setProperty("cpu.subtype", this.getProcessorSubType());
        return props;
    }

    public String getCommandLine() throws CorruptDataException {
        return this._commandLine;
    }

    private void readProcessData() throws IOException {
        if (this._processEntries.size() == 0) {
            throw new IOException("No process entries found in Elf file.");
        }
        if (this._processEntries.size() != 1) {
            throw new IOException("Unexpected number of process entries found in ELF file. Expected 1, found " + this._processEntries.size());
        }
        DataEntry entry = this._processEntries.get(0);
        this._reader.seek(entry.offset);
        this._reader.readByte();
        this._reader.readByte();
        this._reader.readByte();
        this._reader.readByte();
        this._reader.seek(entry.offset + this._reader.padToWordBoundary(4L));
        this._reader.readElfWord();
        this.readUID();
        this.readUID();
        this._pid = this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.seek(entry.offset + entry.size - 96L);
        this._executableFileName = new String(this._reader.readBytes(16), StandardCharsets.US_ASCII).trim();
        this._commandLine = new String(this._reader.readBytes(80), StandardCharsets.US_ASCII).trim();
    }

    private void readModules() throws IOException {
        if (this._executable == null || this._executable instanceof MissingFileModule) {
            this._modulesException = null;
            this._modules = new LinkedList<IModule>();
            this.readProcessData();
            LibraryDataSource executableFile = this.findExecutableOnDiskOrAppended();
            ELFFileReader executableELF = null;
            if (executableFile != null && executableFile.getType() != LibraryDataSource.Source.NOT_FOUND && !this.useLoadedLibraries) {
                try {
                    executableELF = this.getELFReaderFromDataSource(executableFile);
                }
                catch (InvalidDumpFormatException invalidDumpFormatException) {
                    // empty catch block
                }
                if (null != executableELF) {
                    this.createAllModules(executableELF, executableFile.getName());
                }
            } else if (this._executable instanceof MissingFileModule) {
                logger.log(Level.FINE, "Libraries unavailable, falling back to loaded modules within the core file.");
                executableELF = this.getELFReaderForExecutableWithinCoreFile();
                if (null != executableELF) {
                    this.createAllModules(executableELF, this._executablePathOverride);
                } else {
                    this._executable = new MissingFileModule(this._process, this._executableFileName, Collections.emptyList());
                }
            } else {
                this._executable = new MissingFileModule(this._process, this._executableFileName, Collections.emptyList());
            }
        }
    }

    private void createAllModules(ELFFileReader executableELF, String executableName) throws IOException {
        LinkedList<IModule> allModules = new LinkedList<IModule>();
        TreeMap<Long, ELFFileReader> inCoreReaders = this.getElfReadersForModulesWithinCoreFile(executableName);
        Map<Long, String> libraryNamesFromDebugData = this.readLibraryNamesFromDebugData(executableELF, inCoreReaders, executableELF);
        for (Map.Entry entry : inCoreReaders.entrySet()) {
            IModule module;
            long coreFileAddress = (Long)entry.getKey();
            ELFFileReader inCoreReader = (ELFFileReader)entry.getValue();
            String moduleName = inCoreReader.readSONAME(this._reader);
            if ("lib.so".equals(moduleName)) {
                moduleName = executableName;
            }
            String debugName = libraryNamesFromDebugData.get(coreFileAddress);
            ELFFileReader readerForModuleOnDiskOrAppended = null;
            if (debugName != null) {
                moduleName = debugName;
                readerForModuleOnDiskOrAppended = this.getReaderForModuleOnDiskOrAppended(debugName);
            } else {
                readerForModuleOnDiskOrAppended = this.getReaderForModuleOnDiskOrAppended(moduleName);
            }
            if (!inCoreReader.isCompatibleWith(readerForModuleOnDiskOrAppended)) {
                readerForModuleOnDiskOrAppended = null;
            }
            if ((module = this.createModuleFromElfReader(coreFileAddress, moduleName, inCoreReader, readerForModuleOnDiskOrAppended)) == null) continue;
            allModules.add(module);
        }
        this._modules.addAll(allModules);
        ELFFileReader readerForExectuableOnDiskOrAppended = this.getReaderForModuleOnDiskOrAppended(executableName);
        this._executable = this.createModuleFromElfReader(0L, executableName, executableELF, readerForExectuableOnDiskOrAppended);
    }

    private ELFFileReader getELFReaderForExecutableWithinCoreFile() {
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isLoadable()) continue;
            try {
                ELFFileReader reader = this.getReaderForSegment(this._reader.getStream(), programHeaderEntry);
                if (reader == null || !reader.isExecutable()) continue;
                return reader;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private TreeMap<Long, ELFFileReader> getElfReadersForModulesWithinCoreFile(String executableName) {
        TreeMap<Long, ELFFileReader> moduleReadersByBaseAddress = new TreeMap<Long, ELFFileReader>();
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            if (programHeaderEntry.fileSize == 0L || !programHeaderEntry.isLoadable()) continue;
            try {
                ELFFileReader loadedElf = this.getReaderForSegment(this._reader.getStream(), programHeaderEntry);
                if (loadedElf == null) continue;
                moduleReadersByBaseAddress.put(programHeaderEntry.virtualAddress, loadedElf);
            }
            catch (IOException e) {
                logger.log(Level.FINER, "IOException reading module from: " + this._reader.getSourceName() + " @ " + Long.toHexString(programHeaderEntry.fileOffset));
            }
        }
        return moduleReadersByBaseAddress;
    }

    private ELFFileReader getELFReaderFromDataSource(LibraryDataSource source) throws IOException, InvalidDumpFormatException {
        ELFFileReader executableELF = null;
        switch (source.getType()) {
            case FILE: {
                executableELF = ELFFileReader.getELFFileReader(source.getFile());
                break;
            }
            case STREAM: {
                executableELF = ELFFileReader.getELFFileReader(source.getStream());
                break;
            }
        }
        this.openFileTracker.add(executableELF);
        return executableELF;
    }

    private Map<Long, String> readLibraryNamesFromDebugData(ELFFileReader executableELF, Map<Long, ELFFileReader> coreModulesMap, ELFFileReader coreFileReader) throws IOException {
        long address;
        long tag;
        TreeMap<Long, String> libraryNamesByBaseAddress = new TreeMap<Long, String>();
        ProgramHeaderEntry dynamic = executableELF.getDynamicTableEntry();
        if (dynamic == null) {
            return libraryNamesByBaseAddress;
        }
        long dynamicTableAddress = dynamic.virtualAddress;
        if (!this.isReadableAddress(dynamicTableAddress)) {
            return libraryNamesByBaseAddress;
        }
        this._reader.seekToAddress(dynamicTableAddress);
        do {
            tag = this._reader.readElfWord();
            address = this._reader.readElfWord();
            if (tag >= 0L && tag <= 33L || tag >= 0x60000000L && tag <= 0x6FFFFFFFL || tag >= 0x70000000L && tag <= Integer.MAX_VALUE) continue;
            logger.log(Level.WARNING, "Error reading dynamic section. Invalid tag value '0x" + Long.toHexString(tag) + "'. The core file is invalid and the results may unpredictable");
        } while (tag != 0L && tag != 21L);
        if (tag != 21L) {
            return libraryNamesByBaseAddress;
        }
        this._reader.seekToAddress(address);
        this._reader.readElfWord();
        long next = this._reader.readElfWord();
        while (0L != next) {
            this._reader.seekToAddress(next);
            long baseAddress = this._reader.readElfWord();
            long nameAddress = this._reader.readElfWord();
            this._reader.readElfWord();
            next = this._reader.readElfWord();
            if (0L == baseAddress) continue;
            String name = null;
            try {
                name = this._process.readStringAt(nameAddress);
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
            if (null == name || name.length() == 0) continue;
            if (name.startsWith("/")) {
                libraryNamesByBaseAddress.put(baseAddress, name);
                continue;
            }
            ELFFileReader moduleWithinCoreFile = coreModulesMap.get(baseAddress);
            if (moduleWithinCoreFile == null) continue;
            String SONameForModuleAtThisAddress = moduleWithinCoreFile.readSONAME(coreFileReader);
            libraryNamesByBaseAddress.put(baseAddress, SONameForModuleAtThisAddress);
        }
        return libraryNamesByBaseAddress;
    }

    private IModule createModuleFromElfReader(long loadedBaseAddress, String name, ELFFileReader inCoreReader, ELFFileReader diskReader) {
        ArrayList<IMemorySource> ranges;
        Collection<? extends IMemorySource> declaredRanges;
        Properties properties;
        List<? extends ISymbol> symbols;
        if (name == null) {
            return null;
        }
        if (inCoreReader == null) {
            return new MissingFileModule(this._process, name, Collections.emptyList());
        }
        ProgramHeaderEntry ehFrameEntry = null;
        for (ProgramHeaderEntry programHeaderEntry : inCoreReader.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isEhFrame()) continue;
            ehFrameEntry = programHeaderEntry;
        }
        try {
            if (ehFrameEntry != null) {
                this.unwinder.addCallFrameInformation(loadedBaseAddress, ehFrameEntry, name);
            }
        }
        catch (MemoryFault mf) {
            logger.log(Level.FINER, "MemoryFault reading GNU_EH_FRAME data for module with name " + name + " and base address " + Long.toHexString(loadedBaseAddress));
        }
        catch (CorruptDataException cde) {
            logger.log(Level.FINER, "CorruptDataException reading GNU_EH_FRAME data for module with name " + name + " and base address " + Long.toHexString(loadedBaseAddress));
        }
        catch (IOException e) {
            logger.log(Level.FINER, "IOException reading GNU_EH_FRAME data for module with name " + name + " and base address " + Long.toHexString(loadedBaseAddress));
        }
        try {
            List<SectionHeaderEntry> sectionHeaderEntries;
            Map<Long, String> sectionHeaderStringTable;
            if (diskReader != null) {
                symbols = diskReader.getSymbols(loadedBaseAddress, true);
                sectionHeaderStringTable = diskReader.getSectionHeaderStringTable();
                sectionHeaderEntries = diskReader.getSectionHeaderEntries();
            } else {
                symbols = inCoreReader.getSymbols(loadedBaseAddress, false);
                sectionHeaderStringTable = inCoreReader.getSectionHeaderStringTable();
                sectionHeaderEntries = inCoreReader.getSectionHeaderEntries();
            }
            properties = inCoreReader.getProperties();
            declaredRanges = inCoreReader.getMemoryRanges(loadedBaseAddress, sectionHeaderEntries, sectionHeaderStringTable);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "Error generating module with name " + name + " and base address " + Long.toHexString(loadedBaseAddress));
            return null;
        }
        if (loadedBaseAddress == 0L) {
            ranges = new ArrayList<IMemorySource>(declaredRanges);
        } else {
            ranges = new ArrayList(declaredRanges.size());
            for (IMemorySource iMemorySource : declaredRanges) {
                IMemorySource coreSource = this._process.getRangeForAddress(iMemorySource.getBaseAddress());
                if (iMemorySource.getBaseAddress() == loadedBaseAddress) continue;
                if (null != coreSource) {
                    if (!coreSource.isBacked() && iMemorySource.getSize() > 0L) {
                        this._process.removeMemorySource(coreSource);
                        this._process.addMemorySource(iMemorySource);
                    }
                } else if (iMemorySource.getSize() > 0L) {
                    this._process.addMemorySource(iMemorySource);
                }
                ranges.add(iMemorySource);
            }
        }
        return new Module(this._process, name, symbols, ranges, loadedBaseAddress, properties);
    }

    private boolean isValidAddress(long address) {
        IMemorySource range = this._process.getRangeForAddress(address);
        return range != null;
    }

    private boolean isReadableAddress(long address) {
        try {
            this._process.getByteAt(address);
            return true;
        }
        catch (MemoryFault f) {
            return false;
        }
    }

    private LibraryDataSource findExecutableOnDiskOrAppended() {
        int spaceIndex;
        if (this._executablePathOverride != null) {
            try {
                LibraryDataSource libSource = this._resolver.getLibrary(this._executablePathOverride, false);
                return libSource;
            }
            catch (FileNotFoundException e) {
                logger.fine("Could not resolve executable, have the native libraries been collected ?");
                logger.logp(Level.FINER, "com.ibm.j9ddr.corereaders.elf.ELFDumpReader", "findExecutableOnDiskOrAppended", "IOException resolving library", e);
            }
        }
        if ((spaceIndex = this._commandLine.indexOf(32)) != -1) {
            String executablePath = this._commandLine.substring(0, spaceIndex);
            try {
                LibraryDataSource libSource = this._resolver.getLibrary(executablePath, true);
                return libSource;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            LibraryDataSource libSource = this._resolver.getLibrary(this._executableFileName, true);
            return libSource;
        }
        catch (IOException iOException) {
            return new LibraryDataSource(this._executableFileName);
        }
    }

    protected abstract long readUID() throws IOException;

    protected abstract String getProcessorType();

    protected abstract SortedMap<String, Number> readRegisters() throws IOException;

    protected abstract String getStackPointerRegisterName();

    protected abstract long getBasePointerFrom(Map<String, Number> var1);

    protected abstract long getInstructionPointerFrom(Map<String, Number> var1);

    protected abstract long getLinkRegisterFrom(Map<String, Number> var1);

    protected abstract void readHighwordRegisters(DataEntry var1, Map<String, Number> var2) throws IOException, InvalidDumpFormatException;

    protected long getStackPointerFrom(Map<String, Number> registers) {
        return registers.get(this.getStackPointerRegisterName()).longValue();
    }

    protected long getOffsetToIPFromBP() {
        return 1L;
    }

    protected String getProcessorSubType() {
        try {
            String proc = this.readStringAt(this._platformIdAddress);
            if (proc == null) {
                return "unknown";
            }
            return proc;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String readStringAt(long address) throws IOException {
        if (this.isReadableAddress(address)) {
            byte ascii;
            this._reader.seekToAddress(address);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((ascii = this._reader.readByte()) != 0) {
                buffer.write(ascii);
            }
            return new String(buffer.toByteArray(), StandardCharsets.US_ASCII);
        }
        return null;
    }

    private void processProgramHeader() throws IOException {
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            IMemorySource range;
            if (programHeaderEntry.isNote()) {
                this.readNotes(programHeaderEntry);
            }
            if ((range = programHeaderEntry.asMemorySource()).getTopAddress() == -1L && range.getBaseAddress() == 0L) continue;
            this._process.addMemorySource(range);
        }
    }

    private void processAuxiliaryHeader() throws IOException {
        for (DataEntry entry : this._auxiliaryVectorEntries) {
            this.readAuxiliaryVector(entry);
        }
    }

    private void readNotes(ProgramHeaderEntry entry) throws IOException {
        long offset = entry.fileOffset;
        long limit = offset + entry.fileSize;
        while (offset >= entry.fileOffset && offset < limit) {
            offset = this.readNote(offset);
        }
    }

    private long readNote(long offset) throws IOException {
        this._reader.seek(offset);
        long nameLength = this._reader.readInt();
        long dataSize = this._reader.readInt();
        long type2 = this._reader.readInt();
        long dataOffset = offset + 12L + ELFDumpReader.padToIntBoundary(nameLength);
        if (1L == type2) {
            this._threadEntries.add(new DataEntry(dataOffset, dataSize));
        } else if (3L == type2) {
            this._processEntries.add(new DataEntry(dataOffset, dataSize));
        } else if (6L == type2) {
            this._auxiliaryVectorEntries.add(new DataEntry(dataOffset, dataSize));
        } else if (768L == type2) {
            this._highwordRegisterEntries.add(new DataEntry(dataOffset, dataSize));
        }
        return dataOffset + ELFDumpReader.padToIntBoundary(dataSize);
    }

    private static long padToIntBoundary(long value) {
        return value + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    private void readAuxiliaryVector(DataEntry entry) throws IOException {
        this._reader.seek(entry.offset);
        if (0L != entry.size) {
            long type2 = this._reader.readElfWord();
            while (0L != type2) {
                if (15L == type2) {
                    this._platformIdAddress = this._reader.readElfWord();
                } else if (9L == type2) {
                    this._reader.readElfWord();
                } else if (16L == type2) {
                    this._reader.readElfWord();
                } else {
                    this._reader.readElfWord();
                }
                type2 = this._reader.readElfWord();
            }
        }
    }

    public IModule getExecutable() throws CorruptDataException {
        if (this._modulesException != null) {
            throw this._modulesException;
        }
        return this._executable;
    }

    public List<? extends IModule> getModules() throws CorruptDataException {
        if (this._modulesException != null) {
            throw this._modulesException;
        }
        return this._modules;
    }

    public long getProcessId() {
        return this._pid;
    }

    public List<? extends IOSThread> getThreads() {
        ArrayList<IOSThread> threads = new ArrayList<IOSThread>(this._threadEntries.size());
        for (DataEntry entry : this._threadEntries) {
            try {
                threads.add(this.readThread(entry));
            }
            catch (IOException iOException) {}
        }
        return threads;
    }

    private IOSThread readThread(DataEntry entry) throws IOException {
        this._reader.seek(entry.offset);
        this._signalNumber = this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readShort();
        this._reader.readShort();
        this._reader.readElfWord();
        this._reader.readElfWord();
        long pid = (long)this._reader.readInt() & 0xFFFFFFFFL;
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        long utimeSec = this._reader.readElfWord();
        long utimeUSec = this._reader.readElfWord();
        long stimeSec = this._reader.readElfWord();
        long stimeUSec = this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        SortedMap<String, Number> registers = this.readRegisters();
        Properties properties = new Properties();
        properties.setProperty("Thread user time secs", Long.toString(utimeSec));
        properties.setProperty("Thread user time usecs", Long.toString(utimeUSec));
        properties.setProperty("Thread sys time secs", Long.toString(stimeSec));
        properties.setProperty("Thread sys time usecs", Long.toString(stimeUSec));
        if (pid == (long)this._pid) {
            for (DataEntry registerEntry : this._highwordRegisterEntries) {
                try {
                    this.readHighwordRegisters(registerEntry, registers);
                }
                catch (InvalidDumpFormatException e) {
                    logger.warning(e.toString());
                }
            }
        }
        return new LinuxThread(pid, registers, properties);
    }

    public int getSignalNumber() {
        if (this._signalNumber == -1) {
            this.getThreads();
        }
        return this._signalNumber;
    }

    protected abstract String[] getDwarfRegisterKeys();

    protected long maskInstructionPointer(long pointer) {
        return pointer;
    }

    @Override
    public void executablePathHint(String path) {
        this._executablePathOverride = path;
        try {
            this.readModules();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ELFFileReader getReaderForSegment(ImageInputStream in, ProgramHeaderEntry entry) throws IOException {
        try {
            return ELFFileReader.getELFFileReaderWithOffset(in, entry.fileOffset, entry.fileSize);
        }
        catch (InvalidDumpFormatException e) {
            return null;
        }
    }

    private ELFFileReader getReaderForModuleOnDiskOrAppended(String name) throws IOException {
        if (name != null) {
            try {
                LibraryDataSource libsource = this._resolver.getLibrary(name);
                if (libsource != null && LibraryDataSource.Source.NOT_FOUND != libsource.getType()) {
                    ELFFileReader loadedElf = this.getELFReaderFromDataSource(libsource);
                    return loadedElf;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (InvalidDumpFormatException invalidDumpFormatException) {
                // empty catch block
            }
            if (!name.startsWith("/")) {
                for (String path : this.knownLibPaths) {
                    String fullPath = path.endsWith("/") ? path + name : path + "/" + name;
                    try {
                        LibraryDataSource libsource = this._resolver.getLibrary(fullPath);
                        if (libsource != null && LibraryDataSource.Source.NOT_FOUND != libsource.getType()) {
                            ELFFileReader loadedElf = this.getELFReaderFromDataSource(libsource);
                            return loadedElf;
                        }
                    }
                    catch (InvalidDumpFormatException | FileNotFoundException exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    static {
        String paths = System.getProperty(KNOWNLIBPATHS_PROPERTY);
        KNOWNLIBPATHSGLOBAL = paths != null ? paths.split(File.pathSeparator) : null;
    }

    protected class LinuxThread
    implements IOSThread {
        private final Map<String, Number> registers;
        private final Properties properties;
        private final long tid;
        private final List<IMemoryRange> memoryRanges = new LinkedList<IMemoryRange>();
        private final List<IOSStackFrame> stackFrames = new LinkedList<IOSStackFrame>();
        private boolean stackWalked = false;

        private LinuxThread(long tid, Map<String, Number> registers, Properties properties) {
            this.registers = registers;
            this.properties = properties;
            this.tid = tid;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            this.getStackFrames();
            return this.memoryRanges;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        public List<? extends IRegister> getRegisters() {
            ArrayList<Register> regList = new ArrayList<Register>(this.registers.size());
            for (String regName : this.registers.keySet()) {
                Number value = this.registers.get(regName);
                regList.add(new Register(regName, value));
            }
            return regList;
        }

        @Override
        public long getInstructionPointer() {
            if (this.registers != null) {
                return ELFDumpReader.this.getInstructionPointerFrom(this.registers);
            }
            return 0L;
        }

        @Override
        public List<? extends IOSStackFrame> getStackFrames() {
            if (!this.stackWalked) {
                this.walkStack();
                this.stackWalked = true;
            }
            return this.stackFrames;
        }

        public void walkStack() {
            long stackPointer = ELFDumpReader.this.getStackPointerFrom(this.registers);
            long basePointer = ELFDumpReader.this.getBasePointerFrom(this.registers);
            long instructionPointer = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this.getInstructionPointerFrom(this.registers));
            if (0L == instructionPointer || !ELFDumpReader.this.isValidAddress(instructionPointer)) {
                instructionPointer = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this.getLinkRegisterFrom(this.registers));
            }
            if (0L != instructionPointer && ELFDumpReader.this.isValidAddress(instructionPointer) && ELFDumpReader.this.isValidAddress(stackPointer)) {
                IMemorySource range = ELFDumpReader.this._process.getRangeForAddress(stackPointer);
                this.memoryRanges.add(new MemoryRange(ELFDumpReader.this._process.getAddressSpace(), range, "stack"));
                UnwindTable unwindTable = null;
                try {
                    if (ELFDumpReader.this.unwinder == null) {
                        ELFDumpReader.this.unwinder = new Unwind(ELFDumpReader.this._process);
                    }
                    unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(instructionPointer);
                    Map<String, Number> nextRegisters = this.registers;
                    if (unwindTable != null) {
                        nextRegisters = unwindTable.apply(nextRegisters, ELFDumpReader.this.getDwarfRegisterKeys());
                        long newStackPointer = unwindTable.getFrameAddress();
                        nextRegisters.put(ELFDumpReader.this.getStackPointerRegisterName(), newStackPointer);
                        OSStackFrame stackFrame = new OSStackFrame(newStackPointer, instructionPointer);
                        this.stackFrames.add(stackFrame);
                        instructionPointer = ELFDumpReader.this.maskInstructionPointer(unwindTable.getReturnAddress());
                        unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(instructionPointer);
                    }
                    int loops = 0;
                    while (instructionPointer != 0L && ELFDumpReader.this.isValidAddress(instructionPointer) && loops++ < 256) {
                        if (unwindTable != null) {
                            nextRegisters = unwindTable.apply(nextRegisters, ELFDumpReader.this.getDwarfRegisterKeys());
                            long newStackPointer = unwindTable.getFrameAddress();
                            nextRegisters.put(ELFDumpReader.this.getStackPointerRegisterName(), newStackPointer);
                            OSStackFrame stackFrame = new OSStackFrame(newStackPointer, instructionPointer);
                            this.stackFrames.add(stackFrame);
                            instructionPointer = ELFDumpReader.this.maskInstructionPointer(unwindTable.getReturnAddress());
                            unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(instructionPointer);
                            continue;
                        }
                        if (basePointer != 0L) {
                            if (ELFDumpReader.this.isValidAddress(instructionPointer)) {
                                this.stackFrames.add(new OSStackFrame(basePointer, instructionPointer));
                            }
                            long ptr = basePointer;
                            basePointer = ELFDumpReader.this._process.getPointerAt(ptr);
                            instructionPointer = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this._process.getPointerAt(ptr += (long)ELFDumpReader.this._process.bytesPerPointer() * ELFDumpReader.this.getOffsetToIPFromBP()));
                            unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(instructionPointer);
                            continue;
                        }
                        logger.log(Level.FINER, "Base pointer is zero");
                    }
                }
                catch (MemoryFault ex) {
                    logger.log(Level.FINER, "MemoryFault reading stack @ " + String.format("0x%x", ex.getAddress()) + " for thread " + this.tid);
                }
                catch (CorruptDataException e) {
                    logger.log(Level.FINER, "CorruptDataException reading stack from: " + ELFDumpReader.this._reader.getSourceName() + " for thread " + this.tid);
                }
                catch (IOException e) {
                    logger.log(Level.FINER, "IOException reading stack from: " + ELFDumpReader.this._reader.getSourceName() + " for thread " + this.tid);
                }
            }
        }

        private void dumpRegisters(Map<String, Number> registers) {
            System.err.printf("-------------------------\n", new Object[0]);
            int rcount = 0;
            LinkedList<String> keys = new LinkedList<String>();
            for (String key : registers.keySet()) {
                if (key == null) continue;
                keys.add(key);
            }
            Collections.sort(keys);
            for (String key : keys) {
                System.err.printf("%s = 0x%x (%d) ", key, registers.get(key), registers.get(key));
                if (++rcount % 4 != 0) continue;
                System.err.println();
            }
            System.err.println();
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.tid;
        }

        @Override
        public long getBasePointer() {
            return ELFDumpReader.this.getBasePointerFrom(this.registers);
        }

        @Override
        public long getStackPointer() {
            return ELFDumpReader.this.getStackPointerFrom(this.registers);
        }
    }

    public static class RegisterComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            int last = s1.length() - 1;
            if (last >= 1 && Character.isDigit(s1.charAt(last)) && Character.isLetter(s1.charAt(last - 1))) {
                s1 = s1.substring(0, last) + "0" + s1.substring(last);
            }
            if ((last = s2.length() - 1) >= 1 && Character.isDigit(s2.charAt(last)) && Character.isLetter(s2.charAt(last - 1))) {
                s2 = s2.substring(0, last) + "0" + s2.substring(last);
            }
            return s1.compareTo(s2);
        }
    }
}

