/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.Address32;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class ELF32FileReader
extends ELFFileReader {
    public ELF32FileReader(File file, ByteOrder byteOrder) throws IOException, InvalidDumpFormatException {
        super(file, byteOrder);
    }

    public ELF32FileReader(ImageInputStream in, long offset, long limit) throws IOException, InvalidDumpFormatException {
        super(in, offset, limit);
    }

    public boolean validDump(byte[] data, long filesize) {
        return 127 == data[0] && 69 == data[1] && 76 == data[2] && 70 == data[3] && 1 == data[4];
    }

    @Override
    protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
        int type2 = this.is.readInt();
        long fileOffset = ELF32FileReader.unsigned(this.is.readInt());
        long virtualAddress = ELF32FileReader.unsigned(this.is.readInt());
        long physicalAddress = ELF32FileReader.unsigned(this.is.readInt());
        long fileSize = ELF32FileReader.unsigned(this.is.readInt());
        long memorySize = ELF32FileReader.unsigned(this.is.readInt());
        int flags = this.is.readInt();
        long alignment = ELF32FileReader.unsigned(this.is.readInt());
        return new ProgramHeaderEntry(type2, fileOffset, fileSize, virtualAddress, physicalAddress, memorySize, flags, alignment, this);
    }

    private static long unsigned(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    @Override
    protected long padToWordBoundary(long l) {
        return l + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    @Override
    protected long readElfWord() throws IOException {
        return (long)this.is.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected Address readElfWordAsAddress() throws IOException {
        return new Address32(this.is.readInt());
    }

    @Override
    protected int addressSizeBits() {
        return 32;
    }

    @Override
    protected List<ELFSymbol> readSymbolsAt(SectionHeaderEntry entry) throws IOException {
        if (0L != entry.size % 16L) {
            return Collections.emptyList();
        }
        this.seek(entry.offset);
        int count = (int)Math.min(Math.abs(entry.size / 16L), 8096L);
        ArrayList<ELFSymbol> symbols = new ArrayList<ELFSymbol>(count);
        for (long i = 0L; i < (long)count; ++i) {
            long name = (long)this.is.readInt() & 0xFFFFFFFFL;
            long value = (long)this.is.readInt() & 0xFFFFFFFFL;
            long size = (long)this.is.readInt() & 0xFFFFFFFFL;
            byte info = this.is.readByte();
            byte other = this.is.readByte();
            int sectionIndex = this.is.readShort() & 0xFFFF;
            symbols.add(new ELFSymbol(name, value, size, info, other, sectionIndex));
        }
        return symbols;
    }
}

