/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.stream.ImageInputStream;

public abstract class AbstractCoreReader
implements ICore {
    protected ImageInputStream _fileReader;
    protected Collection<? extends IMemorySource> _memoryRanges = new ArrayList<IMemorySource>();
    protected File coreFile;

    protected AbstractCoreReader() {
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbstractCoreReader)) {
            return false;
        }
        AbstractCoreReader reader = (AbstractCoreReader)obj;
        if (this.coreFile == null) {
            if (reader.coreFile != null) {
                return false;
            }
            return this._fileReader.equals(reader._fileReader);
        }
        if (reader.coreFile == null) {
            return false;
        }
        return this.coreFile.equals(reader.coreFile);
    }

    public int hashCode() {
        if (this.coreFile == null) {
            return super.hashCode();
        }
        return this.coreFile.hashCode();
    }

    public void setReader(ImageInputStream reader) throws IOException {
        this._fileReader = reader;
    }

    public long readLong() throws IOException {
        return this._fileReader.readLong();
    }

    public int readInt() throws IOException {
        return this._fileReader.readInt();
    }

    public short readShort() throws IOException {
        return this._fileReader.readShort();
    }

    public byte readByte() throws IOException {
        return this._fileReader.readByte();
    }

    public void seek(long pos) throws IOException {
        this._fileReader.seek(pos);
    }

    public byte[] readBytes(int len) throws IOException {
        byte[] buffer = new byte[len];
        this._fileReader.readFully(buffer);
        return buffer;
    }

    public void readFully(byte[] b) throws IOException {
        this._fileReader.readFully(b);
    }

    public void readFully(byte[] buffer, int offset, int length) throws IOException {
        this._fileReader.readFully(buffer, offset, length);
    }

    protected boolean checkOffset(long location) throws IOException {
        boolean canRead;
        long currentPos = this._fileReader.getStreamPosition();
        try {
            this._fileReader.seek(location);
            this._fileReader.readByte();
            canRead = true;
        }
        catch (IOException ioe) {
            canRead = false;
        }
        this._fileReader.seek(currentPos);
        return canRead;
    }

    protected String readString() throws IOException {
        byte b;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while ((b = this.readByte()) != 0) {
            buffer.write(b);
        }
        return new String(buffer.toByteArray(), StandardCharsets.US_ASCII);
    }

    public static String format(int i) {
        return "0x" + Integer.toHexString(i);
    }

    public static String format(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static long readLong(byte[] data, int start) {
        return 0xFF00000000000000L & (long)data[start + 0] << 56 | 0xFF000000000000L & (long)data[start + 1] << 48 | 0xFF0000000000L & (long)data[start + 2] << 40 | 0xFF00000000L & (long)data[start + 3] << 32 | 0xFF000000L & (long)data[start + 4] << 24 | 0xFF0000L & (long)data[start + 5] << 16 | 0xFF00L & (long)data[start + 6] << 8 | 0xFFL & (long)data[start + 7];
    }

    protected static int readInt(byte[] data, int start) {
        return 0xFF000000 & data[start + 0] << 24 | 0xFF0000 & data[start + 1] << 16 | 0xFF00 & data[start + 2] << 8 | 0xFF & data[start + 3];
    }

    @Override
    public void close() throws IOException {
        if (this._fileReader != null) {
            this._fileReader.close();
        }
    }
}

