/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class StructureTypeManager {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_VOID = 0;
    public static final int TYPE_U8 = 1;
    public static final int TYPE_U16 = 2;
    public static final int TYPE_U32 = 3;
    public static final int TYPE_U64 = 4;
    public static final int TYPE_UDATA = 5;
    public static final int TYPE_I8 = 6;
    public static final int TYPE_I16 = 7;
    public static final int TYPE_I32 = 8;
    public static final int TYPE_I64 = 9;
    public static final int TYPE_IDATA = 10;
    public static final int TYPE_SIMPLE_MIN = 1;
    public static final int TYPE_SIMPLE_MAX = 99;
    public static final int TYPE_BOOL = 100;
    public static final int TYPE_ENUM = 101;
    public static final int TYPE_DOUBLE = 102;
    public static final int TYPE_FLOAT = 103;
    public static final int TYPE_BITFIELD = 104;
    public static final int TYPE_ENUM_POINTER = 105;
    public static final int TYPE_POINTER = 110;
    public static final int TYPE_J9SRP = 111;
    public static final int TYPE_J9WSRP = 112;
    public static final int TYPE_ARRAY = 113;
    public static final int TYPE_J9SRP_POINTER = 114;
    public static final int TYPE_J9WSRP_POINTER = 115;
    public static final int TYPE_STRUCTURE = 120;
    public static final int TYPE_STRUCTURE_POINTER = 121;
    public static final int TYPE_FJ9OBJECT = 130;
    public static final int TYPE_FJ9OBJECT_POINTER = 131;
    public static final int TYPE_J9OBJECTCLASS = 132;
    public static final int TYPE_J9OBJECTCLASS_POINTER = 133;
    public static final int TYPE_J9OBJECTMONITOR = 134;
    public static final int TYPE_J9OBJECTMONITOR_POINTER = 135;
    public static final Map<String, Integer> simpleTypeCodeMap;
    public static final Map<Integer, String> simpleTypeAccessorMap;
    private final Set<String> structureNames = new HashSet<String>();
    private final Set<String> enumNames = new HashSet<String>();
    private static final Pattern CVQualifierPattern;

    public StructureTypeManager(Collection<StructureReader.StructureDescriptor> structures) {
        for (StructureReader.StructureDescriptor structure : structures) {
            if (structure.getFields().size() == 0 && structure.getConstants().size() > 0) {
                this.enumNames.add(structure.getName());
                continue;
            }
            this.structureNames.add(structure.getName());
        }
    }

    public int getType(String rawType) {
        String type2 = CVQualifierPattern.matcher(rawType).replaceAll("");
        if (simpleTypeCodeMap.containsKey(type2)) {
            return simpleTypeCodeMap.get(type2);
        }
        CTypeParser parser = new CTypeParser(type2);
        if (parser.getSuffix().endsWith("]")) {
            return 113;
        }
        if (parser.getSuffix().contains(":")) {
            return 104;
        }
        if (type2.endsWith("*")) {
            int pointerType = this.getType(type2.substring(0, type2.length() - 1).trim());
            switch (pointerType) {
                case -1: {
                    return -1;
                }
                case 120: {
                    return 121;
                }
                case 130: {
                    return 131;
                }
                case 132: {
                    return 133;
                }
                case 134: {
                    return 135;
                }
                case 111: {
                    return 114;
                }
                case 112: {
                    return 115;
                }
                case 101: {
                    return 105;
                }
            }
            return 110;
        }
        if (type2.equals("J9SRP") || type2.startsWith("J9SRP(")) {
            return 111;
        }
        if (type2.equals("J9WSRP") || type2.startsWith("J9WSRP(")) {
            return 112;
        }
        if (type2.startsWith("struct ") || type2.startsWith("class ") || this.structureNames.contains(type2.trim())) {
            return 120;
        }
        if (type2.startsWith("enum ") || this.enumNames.contains(type2.trim())) {
            return 101;
        }
        return -1;
    }

    static {
        HashMap<String, Integer> localSimpleTypeCodeMap = new HashMap<String, Integer>();
        localSimpleTypeCodeMap.put("void", 0);
        localSimpleTypeCodeMap.put("U8", 1);
        localSimpleTypeCodeMap.put("U16", 2);
        localSimpleTypeCodeMap.put("U32", 3);
        localSimpleTypeCodeMap.put("U64", 4);
        localSimpleTypeCodeMap.put("UDATA", 5);
        localSimpleTypeCodeMap.put("I8", 6);
        localSimpleTypeCodeMap.put("I16", 7);
        localSimpleTypeCodeMap.put("I32", 8);
        localSimpleTypeCodeMap.put("I64", 9);
        localSimpleTypeCodeMap.put("IDATA", 10);
        localSimpleTypeCodeMap.put("char", 1);
        localSimpleTypeCodeMap.put("bool", 100);
        localSimpleTypeCodeMap.put("double", 102);
        localSimpleTypeCodeMap.put("float", 103);
        localSimpleTypeCodeMap.put("fj9object_t", 130);
        localSimpleTypeCodeMap.put("iconv_t", 10);
        localSimpleTypeCodeMap.put("j9objectclass_t", 132);
        localSimpleTypeCodeMap.put("j9objectmonitor_t", 134);
        simpleTypeCodeMap = Collections.unmodifiableMap(localSimpleTypeCodeMap);
        HashMap<Integer, String> localSimpleTypeAccessorMap = new HashMap<Integer, String>();
        localSimpleTypeAccessorMap.put(1, "getByteAtOffset");
        localSimpleTypeAccessorMap.put(2, "getShortAtOffset");
        localSimpleTypeAccessorMap.put(3, "getIntAtOffset");
        localSimpleTypeAccessorMap.put(4, "getLongAtOffset");
        localSimpleTypeAccessorMap.put(5, "getUDATAAtOffset");
        localSimpleTypeAccessorMap.put(6, "getByteAtOffset");
        localSimpleTypeAccessorMap.put(7, "getShortAtOffset");
        localSimpleTypeAccessorMap.put(8, "getIntAtOffset");
        localSimpleTypeAccessorMap.put(9, "getLongAtOffset");
        localSimpleTypeAccessorMap.put(10, "getIDATAAtOffset");
        simpleTypeAccessorMap = Collections.unmodifiableMap(localSimpleTypeAccessorMap);
        CVQualifierPattern = Pattern.compile("\\s*\\b(const|volatile)\\b\\s*");
    }
}

