/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.config.Config;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.cert.Certificate;

public class RuleId {
    protected String title;
    protected String location;
    protected String certAlgorithm;
    protected String certHash;
    protected String checksumAlg;
    protected String checksumHash;
    protected String[] jnlpHash;
    private static String[] exceptionSites = null;

    public RuleId(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, string2, string3, string4, string5, string6, null);
    }

    public RuleId(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray) {
        this.title = string;
        this.location = string2;
        this.certAlgorithm = string3;
        this.certHash = string4;
        this.checksumAlg = string5;
        this.checksumHash = string6;
        this.jnlpHash = stringArray;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertAlgorithm() {
        return this.certAlgorithm;
    }

    public String getCertHash() {
        return this.certHash;
    }

    public String getChecksumAlg() {
        return this.checksumAlg;
    }

    public String getChecksumHash() {
        return this.checksumHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(AppRef appRef, CodeRef codeRef) {
        if (appRef.getType() == AppRef.Type.DOCBASE) {
            block30: {
                try {
                    if (this.title != null || this.certHash != null || this.checksumHash != null) break block30;
                    URL uRL = appRef.getLocation();
                    if (this.location == null || uRL != null && RuleId.compareStringToURL(this.location, uRL, true, true)) {
                        Trace.println("Matching Rule id for docbase only: " + this, TraceLevel.RULESET);
                        return true;
                    }
                    if (uRL == null && this.jnlpHash != null) {
                        for (String string : this.jnlpHash) {
                            if (string != null && string.equals(appRef.getJnlpHash())) {
                                Trace.println("Rule location: " + this.location + " matches UNKNOWN jnlp location" + " due to matching jnlp-checksum", TraceLevel.RULESET);
                                return true;
                            }
                            Trace.println("hash: " + string + " does not match app jnlp hash: " + appRef.getJnlpHash(), TraceLevel.RULESET);
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
            Trace.println("Rule location: " + this.location + " doesn't match " + "docbase location: " + appRef.getLocation(), TraceLevel.RULESET);
            return false;
        }
        if (this.title != null && !this.title.equals(appRef.getTitle())) {
            Trace.println("Rule title: " + this.title + " doesn't match artifactId: " + appRef.getTitle(), TraceLevel.RULESET);
            return false;
        }
        Trace.println("Rule title: " + this.title + " matches artifactId: " + appRef.getTitle(), TraceLevel.RULESET);
        if (this.location != null) {
            try {
                boolean bl;
                if (appRef.getLocation() != null) {
                    bl = RuleId.compareStringToURL(this.location, appRef.getLocation(), true, true);
                    if (!bl) {
                        Trace.println("Rule location: " + this.location + " does not match artifact location: " + appRef.getLocation(), TraceLevel.RULESET);
                        return false;
                    }
                } else {
                    bl = false;
                    if (this.jnlpHash == null) {
                        Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location", TraceLevel.RULESET);
                        return false;
                    }
                    for (String string : this.jnlpHash) {
                        if (string == null || !string.equals(appRef.getJnlpHash())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        Trace.println("Rule location: " + this.location + " does not match UNKNOWN artifact location" + " with jnlp checksum: " + appRef.getJnlpHash(), TraceLevel.RULESET);
                        return false;
                    }
                    Trace.println("Rule location: " + this.location + " matches UNKNOWN jnlp location" + " due to matching jnlp-checksum", TraceLevel.RULESET);
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
                return false;
            }
            Trace.println("Rule location: " + this.location + " matches artifactId: " + appRef.getLocation(), TraceLevel.RULESET);
        }
        if (this.certHash != null) {
            try {
                Certificate[] certificateArray = null;
                boolean bl = false;
                String string = null;
                CodeSigner[] codeSignerArray = codeRef.getCodeSigners();
                for (int i = 0; codeSignerArray != null && i < codeSignerArray.length; ++i) {
                    certificateArray = codeRef.getCerts(codeSignerArray[i]);
                    if (certificateArray == null || !this.certHash.equals(string = CertUtils.getMainCertHash(certificateArray, this.certAlgorithm))) continue;
                    bl = true;
                    break;
                }
                if (certificateArray == null) {
                    Trace.println("Rule hash not matching unsigned artifact", TraceLevel.RULESET);
                    return false;
                }
                if (!bl) {
                    Trace.println("Rule hash:\n         " + this.certHash + "\n" + "not matching artifact certificate hash:\n         " + string, TraceLevel.RULESET);
                    return false;
                }
                Trace.println("Rule hash matches certificate hash", TraceLevel.RULESET);
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + "while finding hash for codeRef: " + codeRef, TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        if (this.checksumHash != null) {
            try {
                CodeSigner[] codeSignerArray = codeRef.getCodeSigners();
                if (codeSignerArray != null && codeSignerArray.length > 0) {
                    Trace.println("checksum rule cannot match signed content", TraceLevel.RULESET);
                    return false;
                }
                String string = codeRef.getChecksum(this.checksumAlg);
                if (!this.checksumHash.equals(string)) {
                    if (string == null) {
                        Trace.println("Rule checksum not equal to codebase artifact", TraceLevel.RULESET);
                        return false;
                    }
                    Trace.println("Rule checksum not equal to artifact checksum: " + string, TraceLevel.RULESET);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.println("invalid checksum in rule: " + this.checksumHash);
                return false;
            }
            catch (IOException iOException) {
                Trace.println("IOException: " + iOException + " while finding checksum for: " + codeRef.getJarLocation(), TraceLevel.RULESET);
                Trace.ignored(iOException);
                return false;
            }
        }
        Trace.println("Matching Rule ID: " + this, TraceLevel.RULESET);
        return true;
    }

    public String toString() {
        String string = "\n        title: " + this.title + "\n        location: " + this.location;
        if (this.certHash != null) {
            string = string + "\n        certificate algorithm: " + this.certAlgorithm + "\n        certificate hash: " + this.certHash;
        }
        if (this.checksumHash != null) {
            string = string + "\n        checksum algorithm: " + this.checksumAlg + "\n        checksum hash: " + this.checksumHash;
        }
        return string;
    }

    public static boolean compareStringToURL(String string, URL uRL, boolean bl, boolean bl2) {
        String string2;
        int n;
        String string3 = uRL.getHost();
        String string4 = uRL.getProtocol();
        int n2 = uRL.getDefaultPort();
        int n3 = uRL.getPort();
        String string5 = uRL.getPath();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        URL uRL2 = null;
        try {
            uRL2 = new URL(string);
            string7 = uRL2.getProtocol();
            string6 = uRL2.getHost();
            n = uRL2.getPort();
            string8 = uRL2.getPath();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL2 = new URL("http://" + string);
                string7 = null;
                string6 = uRL2.getHost();
                n = uRL2.getPort();
                string8 = uRL2.getPath();
            }
            catch (MalformedURLException malformedURLException2) {
                Trace.println("invalid location: " + string, TraceLevel.RULESET);
                return false;
            }
        }
        Trace.println("RuleId compare: (" + string7 + ", " + string6 + ", " + n + ", " + string8 + ") to url: " + uRL, TraceLevel.RULESET);
        if (bl) {
            if (n == -1 || n == n3 || n == n2 && n3 == -1) {
                bl5 = true;
            }
        } else if (n == n3 || n == -1 && n3 == n2 || n == n2 && n3 == -1) {
            bl5 = true;
        }
        if (string7 == null || string7.equals(string4)) {
            bl3 = true;
            if ("file".equals(string7)) {
                bl7 = true;
            }
        }
        if (string6.equals("*")) {
            bl4 = false;
        } else if (bl && string6.startsWith("*.")) {
            string2 = string6.substring(2);
            if (string3.toLowerCase().endsWith(string2.toLowerCase())) {
                bl4 = true;
            }
        } else if (string6.equalsIgnoreCase(string3)) {
            bl4 = true;
        }
        if (bl2) {
            bl6 = RuleId.pathIncludes(string8, string5, string4, string3, bl7);
        } else if (string8 == null || string8.length() == 0 || string8.equals(string5)) {
            bl6 = true;
        } else if (bl7) {
            try {
                string2 = new File(string5).getCanonicalPath();
                String string9 = new File(string8).getCanonicalPath();
                bl6 = string9.equals(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl3 && bl4 && bl5 && bl6;
    }

    private static boolean pathIncludes(String string, String string2, String string3, String string4, boolean bl) {
        boolean bl2 = false;
        int n = string2.indexOf(37);
        if (n >= 0 && (string2.indexOf("%2E", n) >= 0 || string2.indexOf("%2e", n) >= 0 || string2.indexOf("%2F", n) >= 0 || string2.indexOf("%2f", n) >= 0)) {
            throw new SecurityException("Unsupported encoded character in path");
        }
        String string5 = URLUtil.decodePath(string2);
        for (int i = 0; i < string5.length(); ++i) {
            char c = string5.charAt(i);
            if (c > '\u001f' && c != '\u007f' && c != '?' && c != '%' && c != '\\' && c != '#') continue;
            throw new SecurityException("Unsupported character in decoded path");
        }
        try {
            string2 = new URI(string3, string4, string5, null).normalize().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SecurityException("unexpected excpetion", uRISyntaxException);
        }
        if (string == null || string.length() == 0 || string2.equals(string)) {
            bl2 = true;
        } else {
            String string6;
            String string7 = string6 = string.endsWith("/") ? string : string + "/";
            if (string2.startsWith(string6)) {
                bl2 = true;
            } else if (bl) {
                try {
                    String string8 = new File(string2).getCanonicalPath();
                    String string9 = new File(string6).getCanonicalPath();
                    if (string8.startsWith(string9)) {
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl2;
    }

    protected static boolean isException(AppRef appRef, CodeRef codeRef) {
        try {
            URL uRL;
            URL uRL2 = appRef.getHTMLLocation() != null ? appRef.getHTMLLocation() : null;
            URL uRL3 = appRef.getJNLPLocation() != null ? appRef.getJNLPLocation() : null;
            URL uRL4 = uRL = codeRef != null ? codeRef.getJarLocation() : null;
            if (exceptionSites == null) {
                exceptionSites = Config.getExceptionSites();
            }
            if (uRL2 != null && RuleId.onExceptionList(uRL2)) {
                if (uRL3 != null && !URLUtil.sameBase(uRL2, uRL3) && !RuleId.onExceptionList(uRL3)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", String.valueOf(appRef.getHTMLLocation()), "jnlp", String.valueOf(appRef.getJNLPLocation()));
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                if (uRL != null && !URLUtil.sameBase(uRL2, uRL) && !RuleId.onExceptionList(uRL)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "html", String.valueOf(appRef.getHTMLLocation()), "jar", String.valueOf(codeRef.getJarLocation()));
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                return true;
            }
            if (uRL2 == null && uRL3 != null && RuleId.onExceptionList(uRL3)) {
                if (uRL != null && !URLUtil.sameBase(uRL3, uRL) && !RuleId.onExceptionList(uRL)) {
                    String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "jnlp", String.valueOf(appRef.getJNLPLocation()), "jar", String.valueOf(codeRef.getJarLocation()));
                    Trace.println(string, TraceLevel.BASIC);
                    throw new BlockedException(string, new Exception());
                }
                return true;
            }
            if (uRL2 == null && uRL3 == null) {
                if (appRef.getAnchorURL() != null && RuleId.onExceptionList(appRef.getAnchorURL())) {
                    if (uRL != null && !URLUtil.sameBase(appRef.getAnchorURL(), uRL) && !RuleId.onExceptionList(uRL)) {
                        String string = ResourceManager.getString("deployment.blocked.exception.list.domains", "jar", String.valueOf(appRef.getAnchorURL()), "jar", String.valueOf(codeRef.getJarLocation()));
                        Trace.println(string, TraceLevel.BASIC);
                        throw new BlockedException(string, new Exception());
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (IOException iOException) {
            Trace.println("IOException processing exception list: " + iOException, TraceLevel.RULESET);
            Trace.ignored(iOException);
            return false;
        }
    }

    private static boolean onExceptionList(URL uRL) throws IOException {
        for (int i = 0; i < exceptionSites.length; ++i) {
            boolean bl;
            if (exceptionSites[i] == null || exceptionSites[i].length() <= 0 || !RuleId.compareStringToURL(exceptionSites[i], uRL, false, bl = exceptionSites[i].endsWith("/"))) continue;
            return true;
        }
        return false;
    }
}

