/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.JreLocator;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JreFindDialog
extends JDialog
implements ActionListener {
    private final JButton _cancelButton = new JButton(ResourceManager.getMessage("find.cancelButton"));
    private final JButton _prevButton = new JButton(ResourceManager.getMessage("find.prevButton"));
    private final JButton _nextButton = new JButton(ResourceManager.getMessage("find.nextButton"));
    private JLabel _titleLabel;
    private JComponent _mainComponent = null;
    private JPanel _buttonPanel;
    private File _directory;
    private int _state;
    private GridBagConstraints _constraints;
    private JTextArea _ta;
    private PathChooser _pc;
    private Dimension _panelPref;
    private JREInfo[] _jres;

    public JreFindDialog(JDialog jDialog) {
        super(jDialog, ResourceManager.getMessage("find.dialog.title"), true);
        this.initComponents();
    }

    private void initComponents() {
        this.setJREs(null);
        this._titleLabel = new JLabel(ResourceManager.getMessage("find.title"));
        this._titleLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.title"));
        JreFindDialog.setFont(this._titleLabel, 2, 18);
        this._cancelButton.addActionListener(this);
        this._nextButton.addActionListener(this);
        this._prevButton.addActionListener(this);
        this._cancelButton.setMnemonic(ResourceManager.getMnemonic("find.cancelButton"));
        this._prevButton.setMnemonic(ResourceManager.getMnemonic("find.prevButton"));
        this._nextButton.setMnemonic(ResourceManager.getMnemonic("find.nextButton"));
        this._cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.cancelButton"));
        this._prevButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.prevButton"));
        this._buttonPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(this._cancelButton);
        jPanel.add(this._prevButton);
        jPanel.add(this._nextButton);
        this._buttonPanel.add((Component)jPanel, "East");
        String string = ResourceManager.getMessage("find.intro");
        this._ta = new JSmartTextArea(string);
        this._pc = new PathChooser();
        this._ta.getAccessibleContext().setAccessibleName(ResourceManager.getMessage("find.title"));
        this._ta.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.title"));
        this._panelPref = this._pc.getUI().getPreferredSize(this._pc);
        this._directory = null;
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JreFindDialog.this.setVisible(false);
                JreFindDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.setState(0);
    }

    public static JREInfo[] search(JDialog jDialog) {
        JreFindDialog jreFindDialog = new JreFindDialog(jDialog);
        jreFindDialog.show();
        return jreFindDialog._jres;
    }

    private static void setFont(JComponent jComponent, int n, int n2) {
        int n3 = jComponent.getFont().getSize();
        n2 = Math.max(n3, n2);
        jComponent.setFont(jComponent.getFont().deriveFont(n, n2));
    }

    public void show() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this._buttonPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        if (this._mainComponent != null) {
            this.getContentPane().add((Component)this._mainComponent, gridBagConstraints);
        }
        this._constraints = gridBagConstraints;
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width = Math.max(dimension.width, 500);
        dimension.height = Math.max(dimension.height, 420);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        UIFactory.placeWindow(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = ResourceManager.getMnemonic("find.cancelButton");
                if (keyEvent.getKeyCode() == n) {
                    JreFindDialog.this._cancelButton.doClick();
                }
            }
        });
        super.show();
        this.dispose();
        this.setState(-1);
    }

    protected void cancel() {
        this.setJREs(null);
        this.setVisible(false);
    }

    protected void next() {
        int n = this.getState();
        if (++n == 3) {
            this.setVisible(false);
        } else {
            this.setState(n);
        }
    }

    protected void previous() {
        int n = this.getState();
        this.setState(--n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this._cancelButton)) {
            this.cancel();
        } else if (object.equals(this._prevButton)) {
            this.previous();
        } else if (object.equals(this._nextButton)) {
            this.next();
        }
    }

    private void setDirectory(File file) {
        this._directory = file;
        this._nextButton.setEnabled(file != null);
    }

    private File getDirectory() {
        return this._directory;
    }

    private void setJREs(JREInfo[] jREInfoArray) {
        this._jres = jREInfoArray;
    }

    private void setState(int n) {
        Serializable serializable;
        this._cancelButton.setEnabled(true);
        this._prevButton.setEnabled(false);
        this._nextButton.setEnabled(true);
        this._state = n;
        if (this._mainComponent != null) {
            this.getContentPane().remove(this._mainComponent);
            this._mainComponent = null;
        }
        switch (this._state) {
            case 0: {
                this._mainComponent = this._ta;
                this._nextButton.setText(ResourceManager.getMessage("find.nextButton"));
                break;
            }
            case 1: {
                this._mainComponent = this._pc;
                this._pc.setCurrentDirectory(this._directory);
                if (this._directory == null) {
                    this._pc.updateDirectory();
                }
                this._prevButton.setEnabled(true);
                this._nextButton.setText(ResourceManager.getMessage("find.nextButton"));
                break;
            }
            case 2: {
                serializable = new SearchPanel();
                this._mainComponent = serializable;
                serializable.start();
                this._nextButton.setText(ResourceManager.getMessage("find.finishButton"));
                break;
            }
        }
        if (this._mainComponent != null) {
            this._mainComponent.setPreferredSize(this._panelPref);
            this.getContentPane().add((Component)this._mainComponent, this._constraints);
            this._mainComponent.revalidate();
            serializable = this.getSize();
            Dimension dimension = this.getPreferredSize();
            ((Dimension)serializable).width = Math.max(((Dimension)serializable).width, dimension.width);
            ((Dimension)serializable).height = Math.max(((Dimension)serializable).height, dimension.height);
            this.setSize(((Dimension)serializable).width, ((Dimension)serializable).height);
        }
        this._nextButton.getAccessibleContext().setAccessibleDescription(this._nextButton.getText());
        this.repaint();
    }

    private int getState() {
        return this._state;
    }

    private class PathChooser
    extends JFileChooser {
        public PathChooser() {
            this.setFileSelectionMode(1);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                        JFileChooser jFileChooser;
                        File file;
                        if (actionEvent.getSource() instanceof JFileChooser && (file = (jFileChooser = (JFileChooser)actionEvent.getSource()).getSelectedFile()) != null && file.isDirectory()) {
                            jFileChooser.setCurrentDirectory(file);
                            JreFindDialog.this.setDirectory(file);
                        }
                        PathChooser.this.updateDirectory();
                    } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                        JreFindDialog.this.cancel();
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName()) || "directoryChanged".equals(propertyChangeEvent.getPropertyName())) {
                        PathChooser.this.updateDirectory();
                    }
                }
            });
            try {
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = JFileChooser.class.getMethod("setControlButtonsAreShown", classArray);
                if (method != null) {
                    Object[] objectArray = new Object[]{Boolean.FALSE};
                    method.invoke((Object)this, objectArray);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.setDialogType(0);
        }

        private void updateDirectory() {
            File file = this.getSelectedFile();
            if (file == null) {
                file = this.getCurrentDirectory();
            }
            JreFindDialog.this.setDirectory(file);
        }
    }

    private class SearchPanel
    extends JPanel
    implements ActionListener {
        private DefaultListModel model;
        private JList list;
        private JLabel searchLabel;
        private String searchPrefix = ResourceManager.getMessage("find.searching.prefix");
        private JLabel titleLabel;
        private Searcher searcher;
        private Timer timer;
        private boolean active;

        public SearchPanel() {
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.getAccessibleContext().setAccessibleName(ResourceManager.getMessage("find.title"));
            this.list.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.title"));
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object instanceof JREInfo) {
                        object = ((JREInfo)object).getPath();
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SearchPanel.this.updateJREs();
                }
            });
            this.searchLabel = new JLabel(" ");
            this.searchLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.searching.prefix"));
            JreFindDialog.setFont(this.searchLabel, 0, 12);
            this.titleLabel = new JLabel(ResourceManager.getMessage("find.searching.title"));
            this.titleLabel.getAccessibleContext().setAccessibleDescription(ResourceManager.getMessage("find.searching.title"));
            JreFindDialog.setFont(this.titleLabel, 0, 12);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 2, 0, 2);
            gridBagConstraints.gridy = 0;
            this.add((Component)this.titleLabel, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.add((Component)this.searchLabel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets.bottom = 0;
            this.add((Component)new JScrollPane(this.list), gridBagConstraints);
            this.titleLabel.getAccessibleContext().setAccessibleDescription(this.titleLabel.getText());
        }

        public void start() {
            this.active = true;
            JreFindDialog.this._nextButton.setEnabled(false);
            JreFindDialog.this._prevButton.setEnabled(true);
            if (this.model != null) {
                this.model.removeAllElements();
            }
            this.timer = new Timer(100, this);
            this.timer.setRepeats(true);
            this.timer.start();
            this.searcher = new Searcher();
            this.searcher.start(JreFindDialog.this.getDirectory());
        }

        public void stop() {
            this.active = false;
            this.stopSearching();
        }

        private void stopSearching() {
            if (this.searcher != null) {
                this.searcher.stop();
                this.searcher = null;
                this.timer.stop();
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.searcher.isFinished()) {
                File file = this.searcher.getCurrentFile();
                if (file != null) {
                    this.searchLabel.setText(this.searchPrefix + file.getPath());
                } else {
                    this.searchLabel.setText(this.searchPrefix);
                }
            } else {
                if (this.model.getSize() > 0) {
                    this.titleLabel.setText(ResourceManager.getMessage("find.foundJREs.title"));
                    JreFindDialog.this._nextButton.setEnabled(true);
                } else {
                    this.titleLabel.setText(ResourceManager.getMessage("find.noJREs.title"));
                    JreFindDialog.this._nextButton.setEnabled(false);
                }
                this.searchLabel.setText(" ");
                this.stopSearching();
            }
        }

        private void updateJREs() {
            if (!this.active) {
                return;
            }
            if (this.model != null) {
                int n = this.model.getSize();
                if (n > 0) {
                    JreFindDialog.this._nextButton.setEnabled(true);
                    int[] nArray = this.list.getSelectedIndices();
                    if (nArray != null && nArray.length > 0) {
                        JREInfo[] jREInfoArray = new JREInfo[nArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            jREInfoArray[i] = (JREInfo)this.model.getElementAt(nArray[i]);
                        }
                        JreFindDialog.this.setJREs(jREInfoArray);
                    } else {
                        Object[] objectArray = new JREInfo[n];
                        this.model.copyInto(objectArray);
                        JreFindDialog.this.setJREs((JREInfo[])objectArray);
                    }
                } else {
                    JreFindDialog.this.setJREs(null);
                    JreFindDialog.this._nextButton.setEnabled(false);
                }
            } else {
                JreFindDialog.this.setJREs(null);
            }
        }

        private boolean alreadyFound(JREInfo jREInfo) {
            for (int i = 0; i < this.model.getSize(); ++i) {
                Object e = this.model.get(i);
                if (e == null || !(e instanceof JREInfo) || !jREInfo.getPath().equals(((JREInfo)e).getPath())) continue;
                return true;
            }
            return false;
        }

        private void add(final Searcher searcher, final JREInfo jREInfo) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SearchPanel.this.searcher == searcher && !SearchPanel.this.alreadyFound(jREInfo)) {
                        SearchPanel.this.model.addElement(jREInfo);
                        SearchPanel.this.updateJREs();
                    }
                }
            });
        }

        private class Searcher
        implements Runnable {
            private File file;
            private boolean stop;
            private File currentFile;
            private boolean finished;

            private Searcher() {
            }

            void start(File file) {
                this.file = file;
                new Thread(this).start();
                SearchPanel.this.updateJREs();
            }

            public File getCurrentFile() {
                return this.currentFile;
            }

            public void stop() {
                this.stop = true;
            }

            public void run() {
                this.check(this.file, false);
                this.finished = true;
            }

            public boolean isFinished() {
                return this.finished;
            }

            private boolean check(File file, boolean bl) {
                Object[] objectArray;
                this.currentFile = file;
                String string = file.getName();
                if (file.isFile() && (string.equals("java") || string.equals("javaw.exe"))) {
                    JREInfo jREInfo = this.getVersion(file, bl);
                    if (jREInfo != null) {
                        SearchPanel.this.add(this, jREInfo);
                        return true;
                    }
                } else if (!file.isFile() && (objectArray = file.list()) != null) {
                    Arrays.sort(objectArray);
                    int n = objectArray.length;
                    for (int i = 0; i < n && !this.stop; ++i) {
                        bl = this.check(new File(file, (String)objectArray[i]), bl);
                    }
                }
                return bl;
            }

            private JREInfo getVersion(File file, boolean bl) {
                if (!this.isValidJavaPath(file, bl)) {
                    return null;
                }
                try {
                    File file2 = file.getCanonicalFile();
                    JREInfo jREInfo = JreLocator.getVersion(file2);
                    if (jREInfo != null) {
                        if (jREInfo.getPlatform().compareTo("1.3") < 0) {
                            return null;
                        }
                        jREInfo.setOSName(Config.getOSName());
                        jREInfo.setOSArch(Config.getOSArch());
                    }
                    return jREInfo;
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isValidJavaPath(File file, boolean bl) {
                String string = file.getParent();
                if (string.endsWith(File.separator + "native_threads") || string.endsWith(File.separator + "green_threads")) {
                    return false;
                }
                String string2 = File.separator + "jre" + File.separator + "bin";
                if (string.endsWith(string2) && string.length() > string2.length() && bl) {
                    String string3 = string.substring(0, string.length() - string2.length() + 1) + "bin" + File.separator;
                    File file2 = new File(string3 + "java");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                    file2 = new File(string3 + "javaw.exe");
                    if (file2.exists() && file2.isFile()) {
                        return false;
                    }
                }
                return !string.endsWith("sparcv9");
            }
        }
    }
}

