/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Mix;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class BezierScroller
extends AnimatingControlsSurface {
    private static String[] appletStrs = new String[]{" ", "Java2Demo", "BezierScroller - Animated Bezier Curve shape with images", "For README.txt file scrolling run in application mode", " "};
    private static final int NUMPTS = 6;
    private static Color greenBlend = new Color(0, 255, 0, 100);
    private static Color blueBlend = new Color(0, 0, 255, 100);
    private static Font font = new Font("serif", 0, 12);
    private static BasicStroke bs = new BasicStroke(3.0f);
    private static Image hotj_img;
    private static BufferedImage img;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private float[] animpts = new float[12];
    private float[] deltas = new float[12];
    private BufferedReader reader;
    private int nStrs;
    private int strH;
    private int yy;
    private int ix;
    private int iy;
    private int imgX;
    private List<String> vector;
    private List<String> appletVector;
    private float alpha = 0.2f;
    private int alphaDirection;
    protected boolean doImage;
    protected boolean doShape;
    protected boolean doText;
    protected boolean buttonToggle;

    public BezierScroller() {
        this.setBackground(Color.WHITE);
        this.doText = true;
        this.doShape = true;
        hotj_img = this.getImage("java-logo.gif");
        Image image = this.getImage("jumptojavastrip.png");
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        img = new BufferedImage(n, n2, 1);
        img.createGraphics().drawImage(image, 0, 0, this);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void animate(float[] fArray, float[] fArray2, int n, int n2) {
        float f = fArray[n] + fArray2[n];
        if (f <= 0.0f) {
            f = -f;
            fArray2[n] = (float)(Math.random() * 4.0 + 2.0);
        } else if (f >= (float)n2) {
            f = 2.0f * (float)n2 - f;
            fArray2[n] = -((float)(Math.random() * 4.0 + 2.0));
        }
        fArray[n] = f;
    }

    public void getFile() {
        try {
            String string = "README.txt";
            this.reader = new BufferedReader(new FileReader(string));
            if (this.reader != null) {
                this.getLine();
            }
        }
        catch (Exception exception) {
            this.reader = null;
        }
        if (this.reader == null) {
            this.appletVector = new ArrayList<String>(100);
            for (int i = 0; i < 100; ++i) {
                this.appletVector.add(appletStrs[i % appletStrs.length]);
            }
            this.getLine();
        }
        this.buttonToggle = true;
    }

    public String getLine() {
        String string = null;
        if (this.reader != null) {
            try {
                string = this.reader.readLine();
                if (string != null) {
                    if (string.length() == 0) {
                        string = " ";
                    }
                    this.vector.add(string);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(BezierScroller.class.getName()).log(Level.SEVERE, null, exception);
                this.reader = null;
            }
        } else if (!this.appletVector.isEmpty()) {
            string = this.appletVector.remove(0);
            this.vector.add(string);
        }
        return string;
    }

    @Override
    public void reset(int n, int n2) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animpts[i + 0] = (float)(Math.random() * (double)n);
            this.animpts[i + 1] = (float)(Math.random() * (double)n2);
            this.deltas[i + 0] = (float)(Math.random() * 6.0 + 4.0);
            this.deltas[i + 1] = (float)(Math.random() * 6.0 + 4.0);
            if (this.animpts[i + 0] > (float)n / 2.0f) {
                this.deltas[i + 0] = -this.deltas[i + 0];
            }
            if (!(this.animpts[i + 1] > (float)n2 / 2.0f)) continue;
            this.deltas[i + 1] = -this.deltas[i + 1];
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.strH = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.nStrs = n2 / this.strH + 2;
        this.vector = new ArrayList<String>(this.nStrs);
        this.ix = (int)(Math.random() * (double)(n - 80));
        this.iy = (int)(Math.random() * (double)(n2 - 80));
    }

    @Override
    public void step(int n, int n2) {
        if (this.doText && this.vector.isEmpty()) {
            this.getFile();
        }
        if (this.doText) {
            String string = this.getLine();
            if (string == null || this.vector.size() == this.nStrs && !this.vector.isEmpty()) {
                this.vector.remove(0);
            }
            this.yy = string == null ? 0 : n2 - this.vector.size() * this.strH;
        }
        for (int i = 0; i < this.animpts.length && this.doShape; i += 2) {
            this.animate(this.animpts, this.deltas, i + 0, n);
            this.animate(this.animpts, this.deltas, i + 1, n2);
        }
        if (this.doImage && this.alphaDirection == 0) {
            float f;
            this.alpha = (float)((double)this.alpha + 0.025);
            if ((double)f > 0.99) {
                this.alphaDirection = 1;
                this.alpha = 1.0f;
            }
        } else if (this.doImage && this.alphaDirection == 1) {
            float f;
            this.alpha = (float)((double)this.alpha - 0.02);
            if ((double)f < 0.01) {
                this.alphaDirection = 0;
                this.alpha = 0.0f;
                this.ix = (int)(Math.random() * (double)(n - 80));
                this.iy = (int)(Math.random() * (double)(n2 - 80));
            }
        }
        if (this.doImage && (this.imgX += 80) == 800) {
            this.imgX = 0;
        }
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        if (this.doText) {
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.setFont(font);
            float f = this.yy;
            for (String string : this.vector) {
                graphics2D.drawString(string, 1.0f, f += (float)this.strH);
            }
        }
        if (this.doShape) {
            float[] fArray = this.animpts;
            int n3 = fArray.length;
            float f = fArray[n3 - 2];
            float f2 = fArray[n3 - 1];
            float f3 = fArray[0];
            float f4 = fArray[1];
            float f5 = (f3 + f) / 2.0f;
            float f6 = (f4 + f2) / 2.0f;
            GeneralPath generalPath = new GeneralPath(1);
            generalPath.moveTo(f5, f6);
            for (int i = 2; i <= fArray.length; i += 2) {
                float f7 = (f5 + f3) / 2.0f;
                float f8 = (f6 + f4) / 2.0f;
                f = f3;
                f2 = f4;
                if (i < fArray.length) {
                    f3 = fArray[i + 0];
                    f4 = fArray[i + 1];
                } else {
                    f3 = fArray[0];
                    f4 = fArray[1];
                }
                f5 = (f3 + f) / 2.0f;
                f6 = (f4 + f2) / 2.0f;
                float f9 = (f + f5) / 2.0f;
                float f10 = (f2 + f6) / 2.0f;
                generalPath.curveTo(f7, f8, f9, f10, f5, f6);
            }
            generalPath.closePath();
            graphics2D.setColor(blueBlend);
            graphics2D.setStroke(bs);
            graphics2D.draw(generalPath);
            graphics2D.setColor(greenBlend);
            graphics2D.fill(generalPath);
            PathIterator pathIterator = generalPath.getPathIterator(null);
            float[] fArray2 = new float[6];
            while (!pathIterator.isDone()) {
                if (pathIterator.currentSegment(fArray2) == 3) {
                    graphics2D.drawImage(hotj_img, (int)fArray2[0], (int)fArray2[1], this);
                }
                pathIterator.next();
            }
        }
        if (this.doImage) {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alpha);
            graphics2D.setComposite(alphaComposite);
            graphics2D.drawImage((Image)img.getSubimage(this.imgX, 0, 80, 80), this.ix, this.iy, this);
        }
    }

    public static void main(String[] stringArray) {
        BezierScroller.createDemoFrame(new BezierScroller());
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        BezierScroller demo;
        JToolBar toolbar;
        JComboBox combo;

        public DemoControls(BezierScroller bezierScroller) {
            super(bezierScroller.name);
            this.demo = bezierScroller;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Image", false);
            this.addTool("Shape", true);
            this.addTool("Text", true);
        }

        public void addTool(String string, boolean bl) {
            JToggleButton jToggleButton = (JToggleButton)this.toolbar.add(new JToggleButton(string));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setSelected(bl);
            jToggleButton.addActionListener(this);
            int n = jToggleButton.getPreferredSize().width;
            Dimension dimension = new Dimension(n, 21);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            jToggleButton.setMinimumSize(dimension);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.getText().equals("Image")) {
                this.demo.doImage = jToggleButton.isSelected();
            } else if (jToggleButton.getText().equals("Shape")) {
                this.demo.doShape = jToggleButton.isSelected();
            } else {
                this.demo.doText = jToggleButton.isSelected();
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            int n = 0;
            while (this.thread == thread) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (!this.demo.buttonToggle) continue;
                ((AbstractButton)this.toolbar.getComponentAtIndex(n++ % 2)).doClick();
                this.demo.buttonToggle = false;
            }
            this.thread = null;
        }
    }
}

