/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.channel.framework.impl.ConnectionDescriptorImpl;
import com.ibm.ws.tcp.channel.impl.BindInfo;
import com.ibm.ws.tcp.channel.impl.NewConnectionInitialReadCallback;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.TCPFactoryConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPReadRequestContextImpl;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.channel.framework.ConnectionDescriptor;
import com.ibm.wsspi.channel.framework.InboundVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.RetryableChannelException;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class TCPPort {
    private TCPChannel tcpChannel = null;
    private ServerSocket serverSocket = null;
    protected InboundVirtualConnectionFactory vcf = null;
    private TCPReadCompletedCallback cc = null;
    private int listenPort = 0;
    private static final TraceComponent tc = Tr.register(TCPPort.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPPort(TCPChannel tCPChannel, VirtualConnectionFactory virtualConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TCPPort");
        }
        this.tcpChannel = tCPChannel;
        this.vcf = (InboundVirtualConnectionFactory)virtualConnectionFactory;
        this.cc = new NewConnectionInitialReadCallback(this.tcpChannel);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TCPPort");
        }
    }

    protected synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private void attemptSocketBind(InetSocketAddress inetSocketAddress, boolean bl) throws IOException {
        this.serverSocket.setReuseAddress(bl);
        this.serverSocket.bind(inetSocketAddress, this.tcpChannel.getConfig().getListenBacklog());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerSocket bind worked, reuse=" + this.serverSocket.getReuseAddress());
        }
        if (!TCPFactoryConfiguration.isWindows()) {
            this.serverSocket.setReuseAddress(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerSocket reuse set to true to allow for later override");
            }
        }
    }

    private BindInfo portBoundEarly(int n) {
        Map map;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "portBoundEarly(int)");
        }
        if ((map = TCPFactoryConfiguration.getEarlyBinds()) != null) {
            BindInfo bindInfo;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got Map of early binds");
            }
            if ((bindInfo = (BindInfo)map.get(new Integer(n))) != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Bind: " + bindInfo);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "portBoundEarly(int)");
            }
            return bindInfo;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "portBoundEarly(int)");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized ServerSocket initServerSocket() throws IOException, RetryableChannelException {
        block33: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerSocket called, new ServerSocket needs to be created");
            }
            TCPChannelConfiguration tCPChannelConfiguration = this.tcpChannel.getConfig();
            IOException iOException = null;
            BindInfo bindInfo = this.portBoundEarly(tCPChannelConfiguration.getPort());
            if (bindInfo == null) {
                InetSocketAddress inetSocketAddress = null;
                inetSocketAddress = tCPChannelConfiguration.getHostname() == null ? new InetSocketAddress((InetAddress)null, tCPChannelConfiguration.getPort()) : new InetSocketAddress(tCPChannelConfiguration.getHostname(), tCPChannelConfiguration.getPort());
                if (!inetSocketAddress.isUnresolved()) {
                    this.serverSocket = this.openServerSocket();
                    if (tCPChannelConfiguration.getReceiveBufferSize() >= 4 && tCPChannelConfiguration.getReceiveBufferSize() <= 0x1000000) {
                        this.serverSocket.setReceiveBufferSize(tCPChannelConfiguration.getReceiveBufferSize());
                    }
                    if (tCPChannelConfiguration.getSoReuseAddress() == 1) {
                        try {
                            this.attemptSocketBind(inetSocketAddress, true);
                        }
                        catch (IOException iOException2) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Forced re-use==true bind attempt failed, ioe=" + iOException2);
                            }
                            iOException = iOException2;
                        }
                    } else {
                        try {
                            this.attemptSocketBind(inetSocketAddress, false);
                        }
                        catch (IOException iOException3) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "ServerSocket bind failed on first attempt with IOException: " + iOException3.getMessage());
                            }
                            iOException = iOException3;
                            try {
                                InetSocketAddress inetSocketAddress2;
                                String string = tCPChannelConfiguration.getHostname();
                                if (string == null) {
                                    string = "localhost";
                                }
                                if (!(inetSocketAddress2 = new InetSocketAddress(string, tCPChannelConfiguration.getPort())).isUnresolved()) {
                                    SocketChannel socketChannel = SocketChannel.open(inetSocketAddress2);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "attempt to connect to port to check listen status worked, someone else is using the port!");
                                    }
                                    socketChannel.close();
                                    this.serverSocket.close();
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Test connection addr is unresolvable; " + inetSocketAddress2);
                                }
                            }
                            catch (IOException iOException4) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "attempt to connect to port to check listen status failed with IOException: " + iOException4.getMessage());
                                }
                                try {
                                    this.attemptSocketBind(inetSocketAddress, true);
                                    iOException = null;
                                }
                                catch (IOException iOException5) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "ServerSocket bind failed on second attempt with IOException: " + iOException5.getMessage());
                                    }
                                    iOException = iOException5;
                                }
                            }
                        }
                    }
                    if (iOException == null) {
                        this.listenPort = this.serverSocket.getLocalPort();
                        break block33;
                    } else {
                        String string = tCPChannelConfiguration.getHostname();
                        if (string == null) {
                            string = "*";
                        }
                        Tr.error(tc, "BIND_ERROR", new Object[]{tCPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(tCPChannelConfiguration.getPort())});
                        throw new RetryableChannelException(iOException.getMessage());
                    }
                }
                String string = tCPChannelConfiguration.getHostname();
                if (string == null) {
                    string = "*";
                }
                Tr.error(tc, "LOCAL_HOST_UNRESOLVED", new Object[]{tCPChannelConfiguration.getChannelData().getExternalName(), string, String.valueOf(tCPChannelConfiguration.getPort())});
                throw new IOException("local address unresolved");
            }
            Exception exception = bindInfo.getBindException();
            if (exception == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found early bind, setting serverSocket and listenPort");
                }
                this.serverSocket = bindInfo.getServerSocket();
                this.listenPort = this.serverSocket.getLocalPort();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Early Bind generated the following exception: " + exception);
                }
                Tr.error(tc, "BIND_ERROR", new Object[]{tCPChannelConfiguration.getChannelData().getExternalName(), bindInfo.getHostname(), String.valueOf(bindInfo.getPort())});
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof RetryableChannelException) {
                    throw (RetryableChannelException)exception;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "new ServerSocket successfully created");
        }
        return this.serverSocket;
    }

    protected ServerSocket openServerSocket() throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        return serverSocketChannel.socket();
    }

    protected synchronized void destroyServerSocket() {
        if (null == this.serverSocket) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ServerSocket being closed for port " + this.listenPort);
        }
        this.closeServerSocket();
        this.serverSocket = null;
    }

    protected void closeServerSocket() {
        block2: {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "IOExeption on ServerSocket.close " + iOException.getMessage());
            }
        }
    }

    protected TCPChannel getTCPChannel() {
        return this.tcpChannel;
    }

    public void processNewConnection(SocketIOChannel socketIOChannel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "processNewConnection");
        }
        VirtualConnection virtualConnection = this.vcf.createConnection();
        TCPConnLink tCPConnLink = (TCPConnLink)this.tcpChannel.getConnectionLink(virtualConnection);
        TCPReadRequestContextImpl tCPReadRequestContextImpl = tCPConnLink.getTCPReadConnLink();
        tCPConnLink.setSocketIOChannel(socketIOChannel);
        ConnectionDescriptor connectionDescriptor = virtualConnection.getConnectionDescriptor();
        Socket socket = socketIOChannel.getSocket();
        InetAddress inetAddress = socket.getInetAddress();
        InetAddress inetAddress2 = socket.getLocalAddress();
        if (connectionDescriptor != null) {
            connectionDescriptor.setAddrs(inetAddress, inetAddress2);
        } else {
            ConnectionDescriptorImpl connectionDescriptorImpl = new ConnectionDescriptorImpl(inetAddress, inetAddress2);
            virtualConnection.setConnectionDescriptor(connectionDescriptorImpl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing Connection: " + virtualConnection.getConnectionDescriptor());
        }
        int n = virtualConnection.attemptToSetFileChannelCapable(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "FileChannelCapable set in VC to: " + n);
        }
        tCPReadRequestContextImpl.setJITAllocateSize(tCPConnLink.getConfig().getNewConnectionBufferSize());
        int n2 = tCPConnLink.getConfig().getInactivityTimeout();
        if (n2 == ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) {
            n2 = -1;
        }
        virtualConnection.getStateMap().put("REMOTE_ADDRESS", tCPConnLink.getRemoteAddress().getHostAddress());
        tCPReadRequestContextImpl.read(1L, this.cc, true, n2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "processNewConnection");
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }
}

