/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcp.channel.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferImpl;
import com.ibm.ws.tcp.channel.impl.SimpleSync;
import com.ibm.ws.tcp.channel.impl.SocketIOChannel;
import com.ibm.ws.tcp.channel.impl.TCPChannelConfiguration;
import com.ibm.ws.tcp.channel.impl.TCPConnLink;
import com.ibm.ws.tcp.channel.impl.ValidateUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TCPBaseRequestContext {
    private boolean requestTypeRead;
    protected boolean blockedThread = false;
    protected SimpleSync blockWait = null;
    protected IOException blockingIOError = null;
    private boolean waitingForIO = false;
    private int currentReadQueue = -1;
    private int currentWriteQueue = -1;
    private WsByteBuffer[] buffers;
    private boolean forceQueue = false;
    private long ioAmount;
    private long ioDoneAmt = 0L;
    private long lastIOAmt = 0L;
    private long ioCompleteAmt = 0L;
    public static long maxReadSize = Integer.MAX_VALUE;
    public static long maxWriteSize = Integer.MAX_VALUE;
    protected TCPConnLink oTCPConnLink;
    protected TCPChannelConfiguration config;
    protected long timeoutTime;
    private int timeoutInterval;
    private WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private boolean missedSet = false;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private ByteBuffer[] byteBufferArrayOf1Direct = null;
    private ByteBuffer[] byteBufferArrayOf2Direct = null;
    private ByteBuffer[] byteBufferArrayOf3Direct = null;
    private ByteBuffer[] byteBufferArrayOf4Direct = null;
    private static final TraceComponent tc = Tr.register(TCPBaseRequestContext.class, "TCPChannel", "com.ibm.ws.tcp.channel.resources.tcpchannelmessages");

    protected TCPBaseRequestContext(TCPConnLink tCPConnLink) {
        this.oTCPConnLink = tCPConnLink;
        this.config = this.oTCPConnLink.getConfig();
    }

    public TCPConnLink getTCPConnLink() {
        return this.oTCPConnLink;
    }

    public TCPConnectionContext getInterface() {
        return this.oTCPConnLink;
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
        int n;
        this.buffers = wsByteBufferArray;
        this.missedSet = false;
        if (this.byteBufferArray != null) {
            for (n = 0; n < this.byteBufferArray.length; ++n) {
                this.byteBufferArray[n] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (n = 0; n < this.byteBufferArrayDirect.length; ++n) {
                this.byteBufferArrayDirect[n] = null;
            }
        }
        this.byteBufferArrayDirect = null;
        if (this.buffers != null) {
            for (n = 0; n < this.buffers.length && this.buffers[n] != null; ++n) {
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setBuffers called with the following number of buffers: " + n);
            }
            if (n == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (n == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (n == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (n == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[n];
            }
            if (n > 1) {
                for (int i = 0; i < n; ++i) {
                    this.byteBufferArray[i] = this.buffers[i].getWrappedByteBufferNonSafe();
                }
            } else if (n == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setBuffers buffer has status of: " + this.buffers[0].getStatus());
                }
                if ((this.buffers[0].getStatus() & 2) == 0) {
                    if (this.byteBufferArrayOf1 == null) {
                        this.byteBufferArrayOf1 = new ByteBuffer[1];
                    }
                    this.byteBufferArray = this.byteBufferArrayOf1;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setBuffers calling getWrappedByteBufferNonSafe()");
                    }
                    this.byteBufferArray[0] = this.buffers[0].getWrappedByteBufferNonSafe();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "setBuffers SKIPPING getWrappedByteBufferNonSafe()");
                    }
                    this.missedSet = true;
                }
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    protected void setBuffersToDirect(WsByteBuffer[] wsByteBufferArray) {
        this.buffers = wsByteBufferArray;
        if (this.buffers != null) {
            int n;
            for (n = 0; n < this.buffers.length && this.buffers[n] != null; ++n) {
            }
            if (n == 1) {
                if (this.byteBufferArrayOf1Direct == null) {
                    this.byteBufferArrayOf1Direct = new ByteBuffer[1];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf1Direct;
            } else if (n == 2) {
                if (this.byteBufferArrayOf2Direct == null) {
                    this.byteBufferArrayOf2Direct = new ByteBuffer[2];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf2Direct;
            } else if (n == 3) {
                if (this.byteBufferArrayOf3Direct == null) {
                    this.byteBufferArrayOf3Direct = new ByteBuffer[3];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf3;
            } else if (n == 4) {
                if (this.byteBufferArrayOf4Direct == null) {
                    this.byteBufferArrayOf4Direct = new ByteBuffer[4];
                }
                this.byteBufferArrayDirect = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArrayDirect = new ByteBuffer[n];
            }
            for (int i = 0; i < n; ++i) {
                this.byteBufferArrayDirect[i] = ((WsByteBufferImpl)this.buffers[i]).oWsBBDirect;
            }
        } else {
            this.byteBufferArrayDirect = null;
        }
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        this.missedSet = false;
        if (this.byteBufferArray != null) {
            for (n = 0; n < this.byteBufferArray.length; ++n) {
                this.byteBufferArray[n] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (n = 0; n < this.byteBufferArrayDirect.length; ++n) {
                this.byteBufferArrayDirect[n] = null;
            }
        }
        this.defaultBuffers[0] = null;
        this.byteBufferArrayDirect = null;
        if (wsByteBuffer != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = wsByteBuffer;
            if ((wsByteBuffer.getStatus() & 2) == 0) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
                this.byteBufferArray[0] = wsByteBuffer.getWrappedByteBufferNonSafe();
            } else {
                this.missedSet = true;
            }
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public void clearBuffers() {
        WsByteBufferUtils.clearBufferArray(this.buffers);
    }

    protected void setForceQueue(boolean bl) {
        this.forceQueue = bl;
    }

    protected boolean isForceQueue() {
        return this.forceQueue;
    }

    public long getIOAmount() {
        return this.ioAmount;
    }

    public long getIODoneAmount() {
        return this.ioDoneAmt;
    }

    protected long getLastIOAmt() {
        return this.lastIOAmt;
    }

    protected void setLastIOAmt(long l) {
        this.lastIOAmt = l;
    }

    protected void setIOAmount(long l) {
        this.ioAmount = l;
    }

    protected void setIODoneAmount(long l) {
        this.ioDoneAmt = l;
    }

    protected void setIOCompleteAmount(long l) {
        this.ioCompleteAmt = l;
    }

    protected long getIOCompleteAmount() {
        return this.ioCompleteAmt;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    protected void setTimeoutTime(int n) {
        if (n == -1) {
            this.timeoutTime = -1L;
            this.timeoutInterval = 0;
        } else {
            if (n == 0) {
                n = this.config.getInactivityTimeout();
            }
            if (n != ValidateUtils.INACTIVITY_TIMEOUT_NO_TIMEOUT) {
                this.timeoutTime = System.currentTimeMillis() + (long)n;
                this.timeoutInterval = n;
            } else {
                this.timeoutTime = -1L;
                this.timeoutInterval = 0;
            }
        }
    }

    protected boolean hasTimeout() {
        return this.timeoutTime != -1L;
    }

    public int getTimeoutInterval() {
        return this.timeoutInterval;
    }

    protected int getCurrentReadQueue() {
        return this.currentReadQueue;
    }

    protected void setCurrentReadQueue(int n) {
        this.currentReadQueue = n;
    }

    protected int getCurrentWriteQueue() {
        return this.currentWriteQueue;
    }

    protected void setCurrentWriteQueue(int n) {
        this.currentWriteQueue = n;
    }

    protected String getFFDCDumpData() {
        return "";
    }

    protected boolean isRequestTypeRead() {
        return this.requestTypeRead;
    }

    protected void setRequestTypeRead(boolean bl) {
        this.requestTypeRead = bl;
    }

    protected ByteBuffer[] getByteBufferArray() {
        if (!this.missedSet) {
            return this.byteBufferArray;
        }
        if (this.byteBufferArrayOf1 == null) {
            this.byteBufferArrayOf1 = new ByteBuffer[1];
        }
        this.byteBufferArray = this.byteBufferArrayOf1;
        this.byteBufferArray[0] = this.buffers[0].getWrappedByteBufferNonSafe();
        this.missedSet = false;
        return this.byteBufferArray;
    }

    protected ByteBuffer[] getByteBufferArrayDirect() {
        return this.byteBufferArrayDirect;
    }

    protected boolean isWaitingForIO() {
        return this.waitingForIO;
    }

    protected void setWaitingForIO(boolean bl) {
        this.waitingForIO = bl;
    }

    public boolean updateIOCounts(long l, int n) {
        this.setLastIOAmt(l);
        this.setIODoneAmount(this.getIODoneAmount() + l);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String string = null;
            string = n == 0 ? "Read " : "Wrote ";
            SocketIOChannel socketIOChannel = this.oTCPConnLink.getSocketIOChannel();
            Tr.event(tc, string + l + "(" + this.getIODoneAmount() + ")" + " bytes, " + this.getIOAmount() + " requested on local: " + socketIOChannel.getSocket().getLocalSocketAddress() + " remote: " + socketIOChannel.getSocket().getRemoteSocketAddress());
        }
        if (this.getIODoneAmount() >= this.getIOAmount()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (n == 0) {
                    Tr.debug(tc, "read complete, at least minimum amount of data read");
                } else {
                    Tr.debug(tc, "write complete, at least minimum amount of data written");
                }
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (n == 0) {
                Tr.debug(tc, "read not complete, more data needed");
            } else {
                Tr.debug(tc, "write not complete, more data needs to be written");
            }
        }
        return false;
    }

    protected Object[] buildDumpList() {
        Object[] objectArray = new Object[]{this.getTCPConnLink(), this.getTCPConnLink().getTCPChannel(), this.getTCPConnLink().getSocketIOChannel(), this.getTCPConnLink().getTCPReadConnLink(), this.getTCPConnLink().getTCPWriteConnLink()};
        return objectArray;
    }
}

