/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.chains.Chain;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionImpl;
import com.ibm.ws.channel.framework.impl.RuntimeState;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.InvalidChainNameException;

public class OutboundVirtualConnectionFactoryImpl
implements VirtualConnectionFactory {
    private static final TraceComponent tc = Tr.register(OutboundVirtualConnectionFactoryImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelFrameworkImpl cf = null;
    private int refCount = 0;
    private String name = null;
    private Chain outboundChain = null;
    private Channel[] chans = null;

    public OutboundVirtualConnectionFactoryImpl(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, ChainException {
        this.name = chainData.getName();
        this.refCount = 1;
        this.cf = channelFrameworkImpl;
        this.cf.initChainInternal(chainData);
        this.outboundChain = this.cf.getRunningChain(this.name);
        if (this.outboundChain == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to create factory; name=" + this.name);
            }
            throw new InvalidChainNameException("Invalid chain when trying to access via the channel framework");
        }
        this.chans = this.outboundChain.getChannels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created factory; " + this);
        }
    }

    public VirtualConnection createConnection() throws ChannelException, ChainException {
        OutboundVirtualConnectionImpl outboundVirtualConnectionImpl = new OutboundVirtualConnectionImpl();
        if (this.outboundChain.getState() != RuntimeState.STARTED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting outbound chain, " + this.name);
            }
            this.cf.startChainInternal(this.outboundChain.getChainData());
            this.outboundChain = this.cf.getRunningChain(this.name);
            if (this.refCount <= 0) {
                this.refCount = 1;
            }
        }
        ConnectionLink[] connectionLinkArray = new ConnectionLink[this.chans.length];
        connectionLinkArray[0] = this.chans[0].getConnectionLink(outboundVirtualConnectionImpl);
        for (int i = 1; i < this.chans.length; ++i) {
            try {
                connectionLinkArray[i] = this.chans[i].getConnectionLink(outboundVirtualConnectionImpl);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".createConnection", "125", new Object[]{this, this.chans[i]});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting conn link from " + this.chans[i].getName() + ", " + exception.getMessage());
                }
                throw new ChannelException(exception.getMessage());
            }
            connectionLinkArray[i - 1].setDeviceLink(connectionLinkArray[i]);
            connectionLinkArray[i].setApplicationCallback(connectionLinkArray[i - 1]);
        }
        outboundVirtualConnectionImpl.setConnectionLink((OutboundConnectionLink)connectionLinkArray[0]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Putting name of chain into vc statemap: " + this.name);
        }
        outboundVirtualConnectionImpl.getStateMap().put("ChainName", this.name);
        return outboundVirtualConnectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRefCount() {
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            ++this.refCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Increased refcount; " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementRefCount() {
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            --this.refCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Decreased refcount; " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ChainException, ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy; " + this);
        }
        ChannelFrameworkImpl channelFrameworkImpl = this.cf;
        synchronized (channelFrameworkImpl) {
            if (this.refCount == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Virtual connection factory already destroyed");
                }
                throw new ChainException("Virtual connection factory already destroyed");
            }
            this.decrementRefCount();
            if (0 == this.refCount) {
                if (this.outboundChain.getState() == RuntimeState.STARTED) {
                    this.cf.stopChainInternal(this.outboundChain, 0L);
                }
                this.cf.destroyChainInternal(this.outboundChain);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void destroyInternal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyInternal; " + this);
        }
        try {
            this.cf.stopChainInternal(this.outboundChain, 0L);
            this.cf.destroyChainInternal(this.outboundChain);
        }
        catch (ChannelException channelException) {
        }
        catch (ChainException chainException) {
            // empty catch block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyInternal");
        }
    }

    public FlowType getType() {
        return FlowType.OUTBOUND;
    }

    public String getName() {
        return this.name;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public Chain getChain() {
        return this.outboundChain;
    }

    public String toString() {
        return "Outbound VCF: chain = " + this.name + ", refCount = " + this.refCount;
    }
}

